/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.c14n.implementations;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.xml.security.c14n.CanonicalizationException;
import org.apache.xml.security.c14n.CanonicalizerSpi;
import org.apache.xml.security.c14n.helper.AttrCompare;
import org.apache.xml.security.c14n.implementations.NameSpaceSymbTable;
import org.apache.xml.security.c14n.implementations.UtfHelpper;
import org.apache.xml.security.signature.NodeFilter;
import org.apache.xml.security.signature.XMLSignatureInput;
import org.apache.xml.security.utils.UnsyncByteArrayOutputStream;
import org.apache.xml.security.utils.XMLUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Comment;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;
import org.xml.sax.SAXException;

public abstract class CanonicalizerBase
extends CanonicalizerSpi {
    private static final byte[] _END_PI = new byte[]{63, 62};
    private static final byte[] _BEGIN_PI = new byte[]{60, 63};
    private static final byte[] _END_COMM = new byte[]{45, 45, 62};
    private static final byte[] _BEGIN_COMM = new byte[]{60, 33, 45, 45};
    private static final byte[] __XA_ = new byte[]{38, 35, 120, 65, 59};
    private static final byte[] __X9_ = new byte[]{38, 35, 120, 57, 59};
    private static final byte[] _QUOT_ = new byte[]{38, 113, 117, 111, 116, 59};
    private static final byte[] __XD_ = new byte[]{38, 35, 120, 68, 59};
    private static final byte[] _GT_ = new byte[]{38, 103, 116, 59};
    private static final byte[] _LT_ = new byte[]{38, 108, 116, 59};
    private static final byte[] _END_TAG = new byte[]{60, 47};
    private static final byte[] _AMP_ = new byte[]{38, 97, 109, 112, 59};
    static final AttrCompare COMPARE = new AttrCompare();
    static final String XML = "xml";
    static final String XMLNS = "xmlns";
    static final byte[] equalsStr = new byte[]{61, 34};
    static final int NODE_BEFORE_DOCUMENT_ELEMENT = -1;
    static final int NODE_NOT_BEFORE_OR_AFTER_DOCUMENT_ELEMENT = 0;
    static final int NODE_AFTER_DOCUMENT_ELEMENT = 1;
    protected static final Attr nullNode;
    List nodeFilter;
    boolean _includeComments;
    Set _xpathNodeSet = null;
    Node _excludeNode = null;
    OutputStream _writer = new UnsyncByteArrayOutputStream();

    public CanonicalizerBase(boolean bl) {
        this._includeComments = bl;
    }

    public byte[] engineCanonicalizeSubTree(Node node4) throws CanonicalizationException {
        return this.engineCanonicalizeSubTree(node4, (Node)null);
    }

    public byte[] engineCanonicalizeXPathNodeSet(Set set2) throws CanonicalizationException {
        this._xpathNodeSet = set2;
        return this.engineCanonicalizeXPathNodeSetInternal(XMLUtils.getOwnerDocument(this._xpathNodeSet));
    }

    public byte[] engineCanonicalize(XMLSignatureInput xMLSignatureInput) throws CanonicalizationException {
        try {
            if (xMLSignatureInput.isExcludeComments()) {
                this._includeComments = false;
            }
            if (xMLSignatureInput.isOctetStream()) {
                return this.engineCanonicalize(xMLSignatureInput.getBytes());
            }
            if (xMLSignatureInput.isElement()) {
                byte[] byArray = this.engineCanonicalizeSubTree(xMLSignatureInput.getSubNode(), xMLSignatureInput.getExcludeNode());
                return byArray;
            }
            if (xMLSignatureInput.isNodeSet()) {
                this.nodeFilter = xMLSignatureInput.getNodeFilters();
                this.circumventBugIfNeeded(xMLSignatureInput);
                byte[] byArray = xMLSignatureInput.getSubNode() != null ? this.engineCanonicalizeXPathNodeSetInternal(xMLSignatureInput.getSubNode()) : this.engineCanonicalizeXPathNodeSet(xMLSignatureInput.getNodeSet());
                return byArray;
            }
            return null;
        }
        catch (CanonicalizationException canonicalizationException) {
            throw new CanonicalizationException("empty", canonicalizationException);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new CanonicalizationException("empty", parserConfigurationException);
        }
        catch (IOException iOException) {
            throw new CanonicalizationException("empty", iOException);
        }
        catch (SAXException sAXException) {
            throw new CanonicalizationException("empty", sAXException);
        }
    }

    public void setWriter(OutputStream outputStream) {
        this._writer = outputStream;
    }

    byte[] engineCanonicalizeSubTree(Node node4, Node node5) throws CanonicalizationException {
        this._excludeNode = node5;
        try {
            NameSpaceSymbTable nameSpaceSymbTable = new NameSpaceSymbTable();
            int n = -1;
            if (node4 instanceof Element) {
                this.getParentNameSpaces((Element)node4, nameSpaceSymbTable);
                n = 0;
            }
            this.canonicalizeSubTree(node4, nameSpaceSymbTable, node4, n);
            this._writer.close();
            if (this._writer instanceof ByteArrayOutputStream) {
                byte[] byArray = ((ByteArrayOutputStream)this._writer).toByteArray();
                if (this.reset) {
                    ((ByteArrayOutputStream)this._writer).reset();
                }
                return byArray;
            }
            if (this._writer instanceof UnsyncByteArrayOutputStream) {
                byte[] byArray = ((UnsyncByteArrayOutputStream)this._writer).toByteArray();
                if (this.reset) {
                    ((UnsyncByteArrayOutputStream)this._writer).reset();
                }
                return byArray;
            }
            return null;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new CanonicalizationException("empty", unsupportedEncodingException);
        }
        catch (IOException iOException) {
            throw new CanonicalizationException("empty", iOException);
        }
    }

    final void canonicalizeSubTree(Node node4, NameSpaceSymbTable nameSpaceSymbTable, Node node5, int n) throws CanonicalizationException, IOException {
        if (this.isVisibleInt(node4) == -1) {
            return;
        }
        Node node6 = null;
        Node node7 = null;
        OutputStream outputStream = this._writer;
        Node node8 = this._excludeNode;
        boolean bl = this._includeComments;
        HashMap hashMap = new HashMap();
        while (true) {
            switch (node4.getNodeType()) {
                default: {
                    break;
                }
                case 2: 
                case 6: 
                case 12: {
                    throw new CanonicalizationException("empty");
                }
                case 9: 
                case 11: {
                    nameSpaceSymbTable.outputNodePush();
                    node6 = node4.getFirstChild();
                    break;
                }
                case 8: {
                    if (!bl) break;
                    CanonicalizerBase.outputCommentToWriter((Comment)node4, outputStream, n);
                    break;
                }
                case 7: {
                    CanonicalizerBase.outputPItoWriter((ProcessingInstruction)node4, outputStream, n);
                    break;
                }
                case 3: 
                case 4: {
                    CanonicalizerBase.outputTextToWriter(node4.getNodeValue(), outputStream);
                    break;
                }
                case 1: {
                    n = 0;
                    if (node4 == node8) break;
                    Element element2 = (Element)node4;
                    nameSpaceSymbTable.outputNodePush();
                    outputStream.write(60);
                    String string2 = element2.getTagName();
                    UtfHelpper.writeByte(string2, outputStream, hashMap);
                    Iterator iterator2 = this.handleAttributesSubtree(element2, nameSpaceSymbTable);
                    if (iterator2 != null) {
                        while (iterator2.hasNext()) {
                            Attr attr = (Attr)iterator2.next();
                            CanonicalizerBase.outputAttrToWriter(attr.getNodeName(), attr.getNodeValue(), outputStream, hashMap);
                        }
                    }
                    outputStream.write(62);
                    node6 = node4.getFirstChild();
                    if (node6 == null) {
                        outputStream.write(_END_TAG);
                        UtfHelpper.writeStringToUtf8(string2, outputStream);
                        outputStream.write(62);
                        nameSpaceSymbTable.outputNodePop();
                        if (node7 == null) break;
                        node6 = node4.getNextSibling();
                        break;
                    }
                    node7 = element2;
                }
            }
            while (node6 == null && node7 != null) {
                outputStream.write(_END_TAG);
                UtfHelpper.writeByte(((Element)node7).getTagName(), outputStream, hashMap);
                outputStream.write(62);
                nameSpaceSymbTable.outputNodePop();
                if (node7 == node5) {
                    return;
                }
                node6 = node7.getNextSibling();
                if ((node7 = node7.getParentNode()) instanceof Element) continue;
                n = 1;
                node7 = null;
            }
            if (node6 == null) {
                return;
            }
            node4 = node6;
            node6 = node4.getNextSibling();
        }
    }

    private byte[] engineCanonicalizeXPathNodeSetInternal(Node node4) throws CanonicalizationException {
        try {
            this.canonicalizeXPathNodeSet(node4, node4);
            this._writer.close();
            if (this._writer instanceof ByteArrayOutputStream) {
                byte[] byArray = ((ByteArrayOutputStream)this._writer).toByteArray();
                if (this.reset) {
                    ((ByteArrayOutputStream)this._writer).reset();
                }
                return byArray;
            }
            if (this._writer instanceof UnsyncByteArrayOutputStream) {
                byte[] byArray = ((UnsyncByteArrayOutputStream)this._writer).toByteArray();
                if (this.reset) {
                    ((UnsyncByteArrayOutputStream)this._writer).reset();
                }
                return byArray;
            }
            return null;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new CanonicalizationException("empty", unsupportedEncodingException);
        }
        catch (IOException iOException) {
            throw new CanonicalizationException("empty", iOException);
        }
    }

    final void canonicalizeXPathNodeSet(Node node4, Node node5) throws CanonicalizationException, IOException {
        if (this.isVisibleInt(node4) == -1) {
            return;
        }
        boolean bl = false;
        NameSpaceSymbTable nameSpaceSymbTable = new NameSpaceSymbTable();
        if (node4 instanceof Element) {
            this.getParentNameSpaces((Element)node4, nameSpaceSymbTable);
        }
        Node node6 = null;
        Node node7 = null;
        OutputStream outputStream = this._writer;
        int n = -1;
        HashMap hashMap = new HashMap();
        while (true) {
            switch (node4.getNodeType()) {
                default: {
                    break;
                }
                case 2: 
                case 6: 
                case 12: {
                    throw new CanonicalizationException("empty");
                }
                case 9: 
                case 11: {
                    nameSpaceSymbTable.outputNodePush();
                    node6 = node4.getFirstChild();
                    break;
                }
                case 8: {
                    if (!this._includeComments || this.isVisibleDO(node4, nameSpaceSymbTable.getLevel()) != 1) break;
                    CanonicalizerBase.outputCommentToWriter((Comment)node4, outputStream, n);
                    break;
                }
                case 7: {
                    if (!this.isVisible(node4)) break;
                    CanonicalizerBase.outputPItoWriter((ProcessingInstruction)node4, outputStream, n);
                    break;
                }
                case 3: 
                case 4: {
                    Node node8;
                    if (!this.isVisible(node4)) break;
                    CanonicalizerBase.outputTextToWriter(node4.getNodeValue(), outputStream);
                    for (node8 = node4.getNextSibling(); node8 != null && (node8.getNodeType() == 3 || node8.getNodeType() == 4); node8 = node8.getNextSibling()) {
                        CanonicalizerBase.outputTextToWriter(node8.getNodeValue(), outputStream);
                        node4 = node8;
                        node6 = node4.getNextSibling();
                    }
                    break;
                }
                case 1: {
                    n = 0;
                    Node node8 = (Element)node4;
                    String string2 = null;
                    int n2 = this.isVisibleDO(node4, nameSpaceSymbTable.getLevel());
                    if (n2 == -1) {
                        node6 = node4.getNextSibling();
                        break;
                    }
                    boolean bl2 = bl = n2 == 1;
                    if (bl) {
                        nameSpaceSymbTable.outputNodePush();
                        outputStream.write(60);
                        string2 = node8.getTagName();
                        UtfHelpper.writeByte(string2, outputStream, hashMap);
                    } else {
                        nameSpaceSymbTable.push();
                    }
                    Iterator iterator2 = this.handleAttributes((Element)node8, nameSpaceSymbTable);
                    if (iterator2 != null) {
                        while (iterator2.hasNext()) {
                            Attr attr = (Attr)iterator2.next();
                            CanonicalizerBase.outputAttrToWriter(attr.getNodeName(), attr.getNodeValue(), outputStream, hashMap);
                        }
                    }
                    if (bl) {
                        outputStream.write(62);
                    }
                    if ((node6 = node4.getFirstChild()) == null) {
                        if (bl) {
                            outputStream.write(_END_TAG);
                            UtfHelpper.writeByte(string2, outputStream, hashMap);
                            outputStream.write(62);
                            nameSpaceSymbTable.outputNodePop();
                        } else {
                            nameSpaceSymbTable.pop();
                        }
                        if (node7 == null) break;
                        node6 = node4.getNextSibling();
                        break;
                    }
                    node7 = node8;
                }
            }
            while (node6 == null && node7 != null) {
                if (this.isVisible(node7)) {
                    outputStream.write(_END_TAG);
                    UtfHelpper.writeByte(((Element)node7).getTagName(), outputStream, hashMap);
                    outputStream.write(62);
                    nameSpaceSymbTable.outputNodePop();
                } else {
                    nameSpaceSymbTable.pop();
                }
                if (node7 == node5) {
                    return;
                }
                node6 = node7.getNextSibling();
                if ((node7 = node7.getParentNode()) instanceof Element) continue;
                node7 = null;
                n = 1;
            }
            if (node6 == null) {
                return;
            }
            node4 = node6;
            node6 = node4.getNextSibling();
        }
    }

    int isVisibleDO(Node node4, int n) {
        if (this.nodeFilter != null) {
            Iterator iterator2 = this.nodeFilter.iterator();
            while (iterator2.hasNext()) {
                int n2 = ((NodeFilter)iterator2.next()).isNodeIncludeDO(node4, n);
                if (n2 == 1) continue;
                return n2;
            }
        }
        if (this._xpathNodeSet != null && !this._xpathNodeSet.contains(node4)) {
            return 0;
        }
        return 1;
    }

    int isVisibleInt(Node node4) {
        if (this.nodeFilter != null) {
            Iterator iterator2 = this.nodeFilter.iterator();
            while (iterator2.hasNext()) {
                int n = ((NodeFilter)iterator2.next()).isNodeInclude(node4);
                if (n == 1) continue;
                return n;
            }
        }
        if (this._xpathNodeSet != null && !this._xpathNodeSet.contains(node4)) {
            return 0;
        }
        return 1;
    }

    boolean isVisible(Node node4) {
        if (this.nodeFilter != null) {
            Iterator iterator2 = this.nodeFilter.iterator();
            while (iterator2.hasNext()) {
                if (((NodeFilter)iterator2.next()).isNodeInclude(node4) == 1) continue;
                return false;
            }
        }
        return this._xpathNodeSet == null || this._xpathNodeSet.contains(node4);
    }

    void handleParent(Element element2, NameSpaceSymbTable nameSpaceSymbTable) {
        if (!element2.hasAttributes()) {
            return;
        }
        NamedNodeMap namedNodeMap = element2.getAttributes();
        int n = namedNodeMap.getLength();
        for (int i = 0; i < n; ++i) {
            Attr attr = (Attr)namedNodeMap.item(i);
            if ("http://www.w3.org/2000/xmlns/" != attr.getNamespaceURI()) continue;
            String string2 = attr.getLocalName();
            String string3 = attr.getNodeValue();
            if (XML.equals(string2) && "http://www.w3.org/XML/1998/namespace".equals(string3)) continue;
            nameSpaceSymbTable.addMapping(string2, string3, attr);
        }
    }

    final void getParentNameSpaces(Element element2, NameSpaceSymbTable nameSpaceSymbTable) {
        Node node4;
        Object object;
        ArrayList<Element> arrayList = new ArrayList<Element>(10);
        Node node5 = element2.getParentNode();
        if (!(node5 instanceof Element)) {
            return;
        }
        Element element3 = (Element)node5;
        while (element3 != null) {
            arrayList.add(element3);
            object = element3.getParentNode();
            if (!(object instanceof Element)) break;
            element3 = (Element)object;
        }
        object = arrayList.listIterator(arrayList.size());
        while (object.hasPrevious()) {
            node4 = (Element)object.previous();
            this.handleParent((Element)node4, nameSpaceSymbTable);
        }
        node4 = nameSpaceSymbTable.getMappingWithoutRendered(XMLNS);
        if (node4 != null && "".equals(node4.getValue())) {
            nameSpaceSymbTable.addMappingAndRender(XMLNS, "", nullNode);
        }
    }

    abstract Iterator handleAttributes(Element var1, NameSpaceSymbTable var2) throws CanonicalizationException;

    abstract Iterator handleAttributesSubtree(Element var1, NameSpaceSymbTable var2) throws CanonicalizationException;

    abstract void circumventBugIfNeeded(XMLSignatureInput var1) throws CanonicalizationException, ParserConfigurationException, IOException, SAXException;

    static final void outputAttrToWriter(String string2, String string3, OutputStream outputStream, Map map3) throws IOException {
        outputStream.write(32);
        UtfHelpper.writeByte(string2, outputStream, map3);
        outputStream.write(equalsStr);
        int n = string3.length();
        int n2 = 0;
        block8: while (n2 < n) {
            byte[] byArray;
            char c2 = string3.charAt(n2++);
            switch (c2) {
                case '&': {
                    byArray = _AMP_;
                    break;
                }
                case '<': {
                    byArray = _LT_;
                    break;
                }
                case '\"': {
                    byArray = _QUOT_;
                    break;
                }
                case '\t': {
                    byArray = __X9_;
                    break;
                }
                case '\n': {
                    byArray = __XA_;
                    break;
                }
                case '\r': {
                    byArray = __XD_;
                    break;
                }
                default: {
                    if (c2 < '\u0080') {
                        outputStream.write(c2);
                        continue block8;
                    }
                    UtfHelpper.writeCharToUtf8(c2, outputStream);
                    continue block8;
                }
            }
            outputStream.write(byArray);
        }
        outputStream.write(34);
    }

    static final void outputPItoWriter(ProcessingInstruction processingInstruction, OutputStream outputStream, int n) throws IOException {
        int n2;
        if (n == 1) {
            outputStream.write(10);
        }
        outputStream.write(_BEGIN_PI);
        String string2 = processingInstruction.getTarget();
        int n3 = string2.length();
        for (int i = 0; i < n3; ++i) {
            n2 = string2.charAt(i);
            if (n2 == 13) {
                outputStream.write(__XD_);
                continue;
            }
            if (n2 < 128) {
                outputStream.write(n2);
                continue;
            }
            UtfHelpper.writeCharToUtf8((char)n2, outputStream);
        }
        String string3 = processingInstruction.getData();
        n3 = string3.length();
        if (n3 > 0) {
            outputStream.write(32);
            for (n2 = 0; n2 < n3; ++n2) {
                char c2 = string3.charAt(n2);
                if (c2 == '\r') {
                    outputStream.write(__XD_);
                    continue;
                }
                UtfHelpper.writeCharToUtf8(c2, outputStream);
            }
        }
        outputStream.write(_END_PI);
        if (n == -1) {
            outputStream.write(10);
        }
    }

    static final void outputCommentToWriter(Comment comment2, OutputStream outputStream, int n) throws IOException {
        if (n == 1) {
            outputStream.write(10);
        }
        outputStream.write(_BEGIN_COMM);
        String string2 = comment2.getData();
        int n2 = string2.length();
        for (int i = 0; i < n2; ++i) {
            char c2 = string2.charAt(i);
            if (c2 == '\r') {
                outputStream.write(__XD_);
                continue;
            }
            if (c2 < '\u0080') {
                outputStream.write(c2);
                continue;
            }
            UtfHelpper.writeCharToUtf8(c2, outputStream);
        }
        outputStream.write(_END_COMM);
        if (n == -1) {
            outputStream.write(10);
        }
    }

    static final void outputTextToWriter(String string2, OutputStream outputStream) throws IOException {
        int n = string2.length();
        block6: for (int i = 0; i < n; ++i) {
            byte[] byArray;
            char c2 = string2.charAt(i);
            switch (c2) {
                case '&': {
                    byArray = _AMP_;
                    break;
                }
                case '<': {
                    byArray = _LT_;
                    break;
                }
                case '>': {
                    byArray = _GT_;
                    break;
                }
                case '\r': {
                    byArray = __XD_;
                    break;
                }
                default: {
                    if (c2 < '\u0080') {
                        outputStream.write(c2);
                        continue block6;
                    }
                    UtfHelpper.writeCharToUtf8(c2, outputStream);
                    continue block6;
                }
            }
            outputStream.write(byArray);
        }
    }

    static {
        try {
            nullNode = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument().createAttributeNS("http://www.w3.org/2000/xmlns/", XMLNS);
            nullNode.setValue("");
        }
        catch (Exception exception) {
            throw new RuntimeException("Unable to create nullNode" + exception);
        }
    }
}

