/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.c14n.implementations;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;

public class UtfHelpper {
    static final void writeByte(String string2, OutputStream outputStream, Map map3) throws IOException {
        byte[] byArray = (byte[])map3.get(string2);
        if (byArray == null) {
            byArray = UtfHelpper.getStringInUtf8(string2);
            map3.put(string2, byArray);
        }
        outputStream.write(byArray);
    }

    static final void writeCharToUtf8(char c2, OutputStream outputStream) throws IOException {
        int n;
        int n2;
        char c3;
        if (c2 < '\u0080') {
            outputStream.write(c2);
            return;
        }
        if (c2 >= '\ud800' && c2 <= '\udbff' || c2 >= '\udc00' && c2 <= '\udfff') {
            outputStream.write(63);
            return;
        }
        if (c2 > '\u07ff') {
            c3 = (char)(c2 >>> 12);
            n2 = 224;
            if (c3 > '\u0000') {
                n2 |= c3 & 0xF;
            }
            outputStream.write(n2);
            n2 = 128;
            n = 63;
        } else {
            n2 = 192;
            n = 31;
        }
        c3 = (char)(c2 >>> 6);
        if (c3 > '\u0000') {
            n2 |= c3 & n;
        }
        outputStream.write(n2);
        outputStream.write(0x80 | c2 & 0x3F);
    }

    static final void writeStringToUtf8(String string2, OutputStream outputStream) throws IOException {
        int n = string2.length();
        int n2 = 0;
        while (n2 < n) {
            int n3;
            int n4;
            char c2;
            char c3;
            if ((c3 = string2.charAt(n2++)) < '\u0080') {
                outputStream.write(c3);
                continue;
            }
            if (c3 >= '\ud800' && c3 <= '\udbff' || c3 >= '\udc00' && c3 <= '\udfff') {
                outputStream.write(63);
                continue;
            }
            if (c3 > '\u07ff') {
                c2 = (char)(c3 >>> 12);
                n4 = 224;
                if (c2 > '\u0000') {
                    n4 |= c2 & 0xF;
                }
                outputStream.write(n4);
                n4 = 128;
                n3 = 63;
            } else {
                n4 = 192;
                n3 = 31;
            }
            c2 = (char)(c3 >>> 6);
            if (c2 > '\u0000') {
                n4 |= c2 & n3;
            }
            outputStream.write(n4);
            outputStream.write(0x80 | c3 & 0x3F);
        }
    }

    public static final byte[] getStringInUtf8(String string2) {
        int n = string2.length();
        boolean bl = false;
        byte[] byArray = new byte[n];
        int n2 = 0;
        int n3 = 0;
        while (n2 < n) {
            int n4;
            int n5;
            char c2;
            if ((c2 = string2.charAt(n2++)) < '\u0080') {
                byArray[n3++] = (byte)c2;
                continue;
            }
            if (c2 >= '\ud800' && c2 <= '\udbff' || c2 >= '\udc00' && c2 <= '\udfff') {
                byArray[n3++] = 63;
                continue;
            }
            if (!bl) {
                byte[] byArray2 = new byte[3 * n];
                System.arraycopy(byArray, 0, byArray2, 0, n3);
                byArray = byArray2;
                bl = true;
            }
            if (c2 > '\u07ff') {
                char c3 = (char)(c2 >>> 12);
                n5 = -32;
                if (c3 > '\u0000') {
                    n5 = (byte)(n5 | c3 & 0xF);
                }
                byArray[n3++] = n5;
                n5 = -128;
                n4 = 63;
            } else {
                n5 = -64;
                n4 = 31;
            }
            char c4 = (char)(c2 >>> 6);
            if (c4 > '\u0000') {
                n5 = (byte)(n5 | c4 & n4);
            }
            byArray[n3++] = n5;
            byArray[n3++] = (byte)(0x80 | c2 & 0x3F);
        }
        if (bl) {
            byte[] byArray3 = new byte[n3];
            System.arraycopy(byArray, 0, byArray3, 0, n3);
            byArray = byArray3;
        }
        return byArray;
    }
}

