/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.exceptions;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.text.MessageFormat;
import org.apache.xml.security.utils.I18n;

public class XMLSecurityRuntimeException
extends RuntimeException {
    private static final long serialVersionUID = 1L;
    protected Exception originalException = null;
    protected String msgID;

    public XMLSecurityRuntimeException() {
        super("Missing message string");
        this.msgID = null;
        this.originalException = null;
    }

    public XMLSecurityRuntimeException(String string2) {
        super(I18n.getExceptionMessage(string2));
        this.msgID = string2;
        this.originalException = null;
    }

    public XMLSecurityRuntimeException(String string2, Object[] objectArray) {
        super(MessageFormat.format(I18n.getExceptionMessage(string2), objectArray));
        this.msgID = string2;
        this.originalException = null;
    }

    public XMLSecurityRuntimeException(Exception exception) {
        super("Missing message ID to locate message string in resource bundle \"org/apache/xml/security/resource/xmlsecurity\". Original Exception was a " + exception.getClass().getName() + " and message " + exception.getMessage());
        this.originalException = exception;
    }

    public XMLSecurityRuntimeException(String string2, Exception exception) {
        super(I18n.getExceptionMessage(string2, exception));
        this.msgID = string2;
        this.originalException = exception;
    }

    public XMLSecurityRuntimeException(String string2, Object[] objectArray, Exception exception) {
        super(MessageFormat.format(I18n.getExceptionMessage(string2), objectArray));
        this.msgID = string2;
        this.originalException = exception;
    }

    public String getMsgID() {
        if (this.msgID == null) {
            return "Missing message ID";
        }
        return this.msgID;
    }

    public String toString() {
        String string2 = this.getClass().getName();
        String string3 = super.getLocalizedMessage();
        string3 = string3 != null ? string2 + ": " + string3 : string2;
        if (this.originalException != null) {
            string3 = string3 + "\nOriginal Exception was " + this.originalException.toString();
        }
        return string3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printStackTrace() {
        PrintStream printStream = System.err;
        synchronized (printStream) {
            super.printStackTrace(System.err);
            if (this.originalException != null) {
                this.originalException.printStackTrace(System.err);
            }
        }
    }

    public void printStackTrace(PrintWriter printWriter) {
        super.printStackTrace(printWriter);
        if (this.originalException != null) {
            this.originalException.printStackTrace(printWriter);
        }
    }

    public void printStackTrace(PrintStream printStream) {
        super.printStackTrace(printStream);
        if (this.originalException != null) {
            this.originalException.printStackTrace(printStream);
        }
    }

    public Exception getOriginalException() {
        return this.originalException;
    }
}

