/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.keys.content;

import java.security.PublicKey;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.RSAPublicKey;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.keys.content.KeyInfoContent;
import org.apache.xml.security.keys.content.keyvalues.DSAKeyValue;
import org.apache.xml.security.keys.content.keyvalues.RSAKeyValue;
import org.apache.xml.security.utils.SignatureElementProxy;
import org.apache.xml.security.utils.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class KeyValue
extends SignatureElementProxy
implements KeyInfoContent {
    public KeyValue(Document document2, DSAKeyValue dSAKeyValue) {
        super(document2);
        XMLUtils.addReturnToElement(this._constructionElement);
        this._constructionElement.appendChild(dSAKeyValue.getElement());
        XMLUtils.addReturnToElement(this._constructionElement);
    }

    public KeyValue(Document document2, RSAKeyValue rSAKeyValue) {
        super(document2);
        XMLUtils.addReturnToElement(this._constructionElement);
        this._constructionElement.appendChild(rSAKeyValue.getElement());
        XMLUtils.addReturnToElement(this._constructionElement);
    }

    public KeyValue(Document document2, Element element2) {
        super(document2);
        XMLUtils.addReturnToElement(this._constructionElement);
        this._constructionElement.appendChild(element2);
        XMLUtils.addReturnToElement(this._constructionElement);
    }

    public KeyValue(Document document2, PublicKey publicKey) {
        super(document2);
        XMLUtils.addReturnToElement(this._constructionElement);
        if (publicKey instanceof DSAPublicKey) {
            DSAKeyValue dSAKeyValue = new DSAKeyValue(this._doc, publicKey);
            this._constructionElement.appendChild(dSAKeyValue.getElement());
            XMLUtils.addReturnToElement(this._constructionElement);
        } else if (publicKey instanceof RSAPublicKey) {
            RSAKeyValue rSAKeyValue = new RSAKeyValue(this._doc, publicKey);
            this._constructionElement.appendChild(rSAKeyValue.getElement());
            XMLUtils.addReturnToElement(this._constructionElement);
        }
    }

    public KeyValue(Element element2, String string2) throws XMLSecurityException {
        super(element2, string2);
    }

    public PublicKey getPublicKey() throws XMLSecurityException {
        Element element2 = XMLUtils.selectDsNode(this._constructionElement.getFirstChild(), "RSAKeyValue", 0);
        if (element2 != null) {
            RSAKeyValue rSAKeyValue = new RSAKeyValue(element2, this._baseURI);
            return rSAKeyValue.getPublicKey();
        }
        Element element3 = XMLUtils.selectDsNode(this._constructionElement.getFirstChild(), "DSAKeyValue", 0);
        if (element3 != null) {
            DSAKeyValue dSAKeyValue = new DSAKeyValue(element3, this._baseURI);
            return dSAKeyValue.getPublicKey();
        }
        return null;
    }

    public String getBaseLocalName() {
        return "KeyValue";
    }
}

