/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.keys.content;

import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.keys.content.KeyInfoContent;
import org.apache.xml.security.signature.XMLSignatureException;
import org.apache.xml.security.transforms.Transforms;
import org.apache.xml.security.utils.SignatureElementProxy;
import org.apache.xml.security.utils.XMLUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class RetrievalMethod
extends SignatureElementProxy
implements KeyInfoContent {
    public static final String TYPE_DSA = "http://www.w3.org/2000/09/xmldsig#DSAKeyValue";
    public static final String TYPE_RSA = "http://www.w3.org/2000/09/xmldsig#RSAKeyValue";
    public static final String TYPE_PGP = "http://www.w3.org/2000/09/xmldsig#PGPData";
    public static final String TYPE_SPKI = "http://www.w3.org/2000/09/xmldsig#SPKIData";
    public static final String TYPE_MGMT = "http://www.w3.org/2000/09/xmldsig#MgmtData";
    public static final String TYPE_X509 = "http://www.w3.org/2000/09/xmldsig#X509Data";
    public static final String TYPE_RAWX509 = "http://www.w3.org/2000/09/xmldsig#rawX509Certificate";

    public RetrievalMethod(Element element2, String string2) throws XMLSecurityException {
        super(element2, string2);
    }

    public RetrievalMethod(Document document2, String string2, Transforms transforms, String string3) {
        super(document2);
        this._constructionElement.setAttributeNS(null, "URI", string2);
        if (string3 != null) {
            this._constructionElement.setAttributeNS(null, "Type", string3);
        }
        if (transforms != null) {
            this._constructionElement.appendChild(transforms.getElement());
            XMLUtils.addReturnToElement(this._constructionElement);
        }
    }

    public Attr getURIAttr() {
        return this._constructionElement.getAttributeNodeNS(null, "URI");
    }

    public String getURI() {
        return this.getURIAttr().getNodeValue();
    }

    public String getType() {
        return this._constructionElement.getAttributeNS(null, "Type");
    }

    public Transforms getTransforms() throws XMLSecurityException {
        try {
            Element element2 = XMLUtils.selectDsNode(this._constructionElement.getFirstChild(), "Transforms", 0);
            if (element2 != null) {
                return new Transforms(element2, this._baseURI);
            }
            return null;
        }
        catch (XMLSignatureException xMLSignatureException) {
            throw new XMLSecurityException("empty", xMLSignatureException);
        }
    }

    public String getBaseLocalName() {
        return "RetrievalMethod";
    }
}

