/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.keys.content.x509;

import java.math.BigInteger;
import java.security.cert.X509Certificate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.keys.content.x509.XMLX509DataContent;
import org.apache.xml.security.utils.RFC2253Parser;
import org.apache.xml.security.utils.SignatureElementProxy;
import org.apache.xml.security.utils.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XMLX509IssuerSerial
extends SignatureElementProxy
implements XMLX509DataContent {
    static Log log = LogFactory.getLog(XMLX509IssuerSerial.class.getName());

    public XMLX509IssuerSerial(Element element2, String string2) throws XMLSecurityException {
        super(element2, string2);
    }

    public XMLX509IssuerSerial(Document document2, String string2, BigInteger bigInteger) {
        super(document2);
        XMLUtils.addReturnToElement(this._constructionElement);
        this.addTextElement(string2, "X509IssuerName");
        this.addTextElement(bigInteger.toString(), "X509SerialNumber");
    }

    public XMLX509IssuerSerial(Document document2, String string2, String string3) {
        this(document2, string2, new BigInteger(string3));
    }

    public XMLX509IssuerSerial(Document document2, String string2, int n) {
        this(document2, string2, new BigInteger(Integer.toString(n)));
    }

    public XMLX509IssuerSerial(Document document2, X509Certificate x509Certificate) {
        this(document2, RFC2253Parser.normalize(x509Certificate.getIssuerDN().getName()), x509Certificate.getSerialNumber());
    }

    public BigInteger getSerialNumber() {
        String string2 = this.getTextFromChildElement("X509SerialNumber", "http://www.w3.org/2000/09/xmldsig#");
        if (log.isDebugEnabled()) {
            log.debug("X509SerialNumber text: " + string2);
        }
        return new BigInteger(string2);
    }

    public int getSerialNumberInteger() {
        return this.getSerialNumber().intValue();
    }

    public String getIssuerName() {
        return RFC2253Parser.normalize(this.getTextFromChildElement("X509IssuerName", "http://www.w3.org/2000/09/xmldsig#"));
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!this.getClass().getName().equals(object.getClass().getName())) {
            return false;
        }
        XMLX509IssuerSerial xMLX509IssuerSerial = (XMLX509IssuerSerial)object;
        return this.getSerialNumber().equals(xMLX509IssuerSerial.getSerialNumber()) && this.getIssuerName().equals(xMLX509IssuerSerial.getIssuerName());
    }

    public int hashCode() {
        return 82;
    }

    public String getBaseLocalName() {
        return "X509IssuerSerial";
    }
}

