/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.keys.keyresolver;

import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.crypto.SecretKey;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.security.keys.keyresolver.KeyResolverException;
import org.apache.xml.security.keys.keyresolver.KeyResolverSpi;
import org.apache.xml.security.keys.storage.StorageResolver;
import org.w3c.dom.Element;

public class KeyResolver {
    static Log log = LogFactory.getLog(KeyResolver.class.getName());
    static boolean _alreadyInitialized = false;
    static List _resolverVector = null;
    protected KeyResolverSpi _resolverSpi = null;
    protected StorageResolver _storage = null;

    private KeyResolver(String string2) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        this._resolverSpi = (KeyResolverSpi)Class.forName(string2).newInstance();
        this._resolverSpi.setGlobalResolver(true);
    }

    public static int length() {
        return _resolverVector.size();
    }

    public static void hit(Iterator iterator2) {
        ResolverIterator resolverIterator = (ResolverIterator)iterator2;
        int n = resolverIterator.i;
        if (n != 1 && resolverIterator.res == _resolverVector) {
            List list2 = (List)((ArrayList)_resolverVector).clone();
            Object e2 = list2.remove(n - 1);
            list2.add(0, e2);
            _resolverVector = list2;
        }
    }

    public static final X509Certificate getX509Certificate(Element element2, String string2, StorageResolver storageResolver) throws KeyResolverException {
        List list2 = _resolverVector;
        for (int i = 0; i < list2.size(); ++i) {
            Object[] objectArray;
            KeyResolver keyResolver = (KeyResolver)list2.get(i);
            if (keyResolver == null) {
                objectArray = new Object[]{element2 != null && element2.getNodeType() == 1 ? element2.getTagName() : "null"};
                throw new KeyResolverException("utils.resolver.noClass", objectArray);
            }
            if (log.isDebugEnabled()) {
                log.debug("check resolvability by class " + keyResolver.getClass());
            }
            if ((objectArray = keyResolver.resolveX509Certificate(element2, string2, storageResolver)) == null) continue;
            return objectArray;
        }
        Object[] objectArray = new Object[]{element2 != null && element2.getNodeType() == 1 ? element2.getTagName() : "null"};
        throw new KeyResolverException("utils.resolver.noClass", objectArray);
    }

    public static final PublicKey getPublicKey(Element element2, String string2, StorageResolver storageResolver) throws KeyResolverException {
        List list2 = _resolverVector;
        for (int i = 0; i < list2.size(); ++i) {
            Object[] objectArray;
            KeyResolver keyResolver = (KeyResolver)list2.get(i);
            if (keyResolver == null) {
                objectArray = new Object[]{element2 != null && element2.getNodeType() == 1 ? element2.getTagName() : "null"};
                throw new KeyResolverException("utils.resolver.noClass", objectArray);
            }
            if (log.isDebugEnabled()) {
                log.debug("check resolvability by class " + keyResolver.getClass());
            }
            if ((objectArray = keyResolver.resolvePublicKey(element2, string2, storageResolver)) == null) continue;
            if (i != 0 && list2 == _resolverVector) {
                list2 = (List)((ArrayList)_resolverVector).clone();
                Object e2 = list2.remove(i);
                list2.add(0, e2);
                _resolverVector = list2;
            }
            return objectArray;
        }
        Object[] objectArray = new Object[]{element2 != null && element2.getNodeType() == 1 ? element2.getTagName() : "null"};
        throw new KeyResolverException("utils.resolver.noClass", objectArray);
    }

    public static void init() {
        if (!_alreadyInitialized) {
            _resolverVector = new ArrayList(10);
            _alreadyInitialized = true;
        }
    }

    public static void register(String string2) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        _resolverVector.add(new KeyResolver(string2));
    }

    public static void registerAtStart(String string2) {
        _resolverVector.add(0, string2);
    }

    public PublicKey resolvePublicKey(Element element2, String string2, StorageResolver storageResolver) throws KeyResolverException {
        return this._resolverSpi.engineLookupAndResolvePublicKey(element2, string2, storageResolver);
    }

    public X509Certificate resolveX509Certificate(Element element2, String string2, StorageResolver storageResolver) throws KeyResolverException {
        return this._resolverSpi.engineLookupResolveX509Certificate(element2, string2, storageResolver);
    }

    public SecretKey resolveSecretKey(Element element2, String string2, StorageResolver storageResolver) throws KeyResolverException {
        return this._resolverSpi.engineLookupAndResolveSecretKey(element2, string2, storageResolver);
    }

    public void setProperty(String string2, String string3) {
        this._resolverSpi.engineSetProperty(string2, string3);
    }

    public String getProperty(String string2) {
        return this._resolverSpi.engineGetProperty(string2);
    }

    public boolean understandsProperty(String string2) {
        return this._resolverSpi.understandsProperty(string2);
    }

    public String resolverClassName() {
        return this._resolverSpi.getClass().getName();
    }

    public static Iterator iterator() {
        return new ResolverIterator(_resolverVector);
    }

    static class ResolverIterator
    implements Iterator {
        List res;
        Iterator it;
        int i;

        public ResolverIterator(List list2) {
            this.res = list2;
            this.it = this.res.iterator();
        }

        public boolean hasNext() {
            return this.it.hasNext();
        }

        public Object next() {
            ++this.i;
            KeyResolver keyResolver = (KeyResolver)this.it.next();
            if (keyResolver == null) {
                throw new RuntimeException("utils.resolver.noClass");
            }
            return keyResolver._resolverSpi;
        }

        public void remove() {
        }
    }
}

