/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.keys.keyresolver.implementations;

import java.security.Key;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import javax.crypto.SecretKey;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.security.encryption.EncryptedKey;
import org.apache.xml.security.encryption.XMLCipher;
import org.apache.xml.security.keys.keyresolver.KeyResolverSpi;
import org.apache.xml.security.keys.keyresolver.implementations.RSAKeyValueResolver;
import org.apache.xml.security.keys.storage.StorageResolver;
import org.apache.xml.security.utils.XMLUtils;
import org.w3c.dom.Element;

public class EncryptedKeyResolver
extends KeyResolverSpi {
    static Log log = LogFactory.getLog(RSAKeyValueResolver.class.getName());
    Key _kek;
    String _algorithm;

    public EncryptedKeyResolver(String string2) {
        this._kek = null;
        this._algorithm = string2;
    }

    public EncryptedKeyResolver(String string2, Key key) {
        this._algorithm = string2;
        this._kek = key;
    }

    public PublicKey engineLookupAndResolvePublicKey(Element element2, String string2, StorageResolver storageResolver) {
        return null;
    }

    public X509Certificate engineLookupResolveX509Certificate(Element element2, String string2, StorageResolver storageResolver) {
        return null;
    }

    public SecretKey engineLookupAndResolveSecretKey(Element element2, String string2, StorageResolver storageResolver) {
        SecretKey secretKey = null;
        if (log.isDebugEnabled()) {
            log.debug("EncryptedKeyResolver - Can I resolve " + element2.getTagName());
        }
        if (element2 == null) {
            return null;
        }
        boolean bl = XMLUtils.elementIsInEncryptionSpace(element2, "EncryptedKey");
        if (bl) {
            log.debug("Passed an Encrypted Key");
            try {
                XMLCipher xMLCipher = XMLCipher.getInstance();
                xMLCipher.init(4, this._kek);
                EncryptedKey encryptedKey = xMLCipher.loadEncryptedKey(element2);
                secretKey = (SecretKey)xMLCipher.decryptKey(encryptedKey, this._algorithm);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return secretKey;
    }
}

