/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.keys.keyresolver.implementations;

import java.security.PublicKey;
import java.security.cert.X509Certificate;
import javax.crypto.SecretKey;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.keys.content.keyvalues.RSAKeyValue;
import org.apache.xml.security.keys.keyresolver.KeyResolverSpi;
import org.apache.xml.security.keys.storage.StorageResolver;
import org.apache.xml.security.utils.XMLUtils;
import org.w3c.dom.Element;

public class RSAKeyValueResolver
extends KeyResolverSpi {
    static Log log = LogFactory.getLog(RSAKeyValueResolver.class.getName());

    public PublicKey engineLookupAndResolvePublicKey(Element element2, String string2, StorageResolver storageResolver) {
        if (log.isDebugEnabled()) {
            log.debug("Can I resolve " + element2.getTagName());
        }
        if (element2 == null) {
            return null;
        }
        boolean bl = XMLUtils.elementIsInSignatureSpace(element2, "KeyValue");
        Element element3 = null;
        if (bl) {
            element3 = XMLUtils.selectDsNode(element2.getFirstChild(), "RSAKeyValue", 0);
        } else if (XMLUtils.elementIsInSignatureSpace(element2, "RSAKeyValue")) {
            element3 = element2;
        }
        if (element3 == null) {
            return null;
        }
        try {
            RSAKeyValue rSAKeyValue = new RSAKeyValue(element3, string2);
            return rSAKeyValue.getPublicKey();
        }
        catch (XMLSecurityException xMLSecurityException) {
            log.debug("XMLSecurityException", xMLSecurityException);
            return null;
        }
    }

    public X509Certificate engineLookupResolveX509Certificate(Element element2, String string2, StorageResolver storageResolver) {
        return null;
    }

    public SecretKey engineLookupAndResolveSecretKey(Element element2, String string2, StorageResolver storageResolver) {
        return null;
    }
}

