/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.keys.keyresolver.implementations;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.PublicKey;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import javax.crypto.SecretKey;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.security.c14n.CanonicalizationException;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.keys.content.RetrievalMethod;
import org.apache.xml.security.keys.keyresolver.KeyResolver;
import org.apache.xml.security.keys.keyresolver.KeyResolverException;
import org.apache.xml.security.keys.keyresolver.KeyResolverSpi;
import org.apache.xml.security.keys.storage.StorageResolver;
import org.apache.xml.security.signature.XMLSignatureInput;
import org.apache.xml.security.transforms.Transforms;
import org.apache.xml.security.utils.XMLUtils;
import org.apache.xml.security.utils.resolver.ResourceResolver;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class RetrievalMethodResolver
extends KeyResolverSpi {
    static Log log = LogFactory.getLog(RetrievalMethodResolver.class.getName());

    public PublicKey engineLookupAndResolvePublicKey(Element element2, String string2, StorageResolver storageResolver) {
        if (!XMLUtils.elementIsInSignatureSpace(element2, "RetrievalMethod")) {
            return null;
        }
        try {
            RetrievalMethod retrievalMethod = new RetrievalMethod(element2, string2);
            String string3 = retrievalMethod.getType();
            XMLSignatureInput xMLSignatureInput = RetrievalMethodResolver.resolveInput(retrievalMethod, string2);
            if ("http://www.w3.org/2000/09/xmldsig#rawX509Certificate".equals(string3)) {
                X509Certificate x509Certificate = RetrievalMethodResolver.getRawCertificate(xMLSignatureInput);
                if (x509Certificate != null) {
                    return x509Certificate.getPublicKey();
                }
                return null;
            }
            Element element3 = RetrievalMethodResolver.obtainRefrenceElement(xMLSignatureInput);
            return RetrievalMethodResolver.resolveKey(element3, string2, storageResolver);
        }
        catch (XMLSecurityException xMLSecurityException) {
            log.debug("XMLSecurityException", xMLSecurityException);
        }
        catch (CertificateException certificateException) {
            log.debug("CertificateException", certificateException);
        }
        catch (IOException iOException) {
            log.debug("IOException", iOException);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            log.debug("ParserConfigurationException", parserConfigurationException);
        }
        catch (SAXException sAXException) {
            log.debug("SAXException", sAXException);
        }
        return null;
    }

    private static Element obtainRefrenceElement(XMLSignatureInput xMLSignatureInput) throws CanonicalizationException, ParserConfigurationException, IOException, SAXException, KeyResolverException {
        Element element2;
        if (xMLSignatureInput.isElement()) {
            element2 = (Element)xMLSignatureInput.getSubNode();
        } else if (xMLSignatureInput.isNodeSet()) {
            element2 = RetrievalMethodResolver.getDocumentElement(xMLSignatureInput.getNodeSet());
        } else {
            byte[] byArray = xMLSignatureInput.getBytes();
            element2 = RetrievalMethodResolver.getDocFromBytes(byArray);
            if (log.isDebugEnabled()) {
                log.debug("we have to parse " + byArray.length + " bytes");
            }
        }
        return element2;
    }

    public X509Certificate engineLookupResolveX509Certificate(Element element2, String string2, StorageResolver storageResolver) {
        if (!XMLUtils.elementIsInSignatureSpace(element2, "RetrievalMethod")) {
            return null;
        }
        try {
            RetrievalMethod retrievalMethod = new RetrievalMethod(element2, string2);
            String string3 = retrievalMethod.getType();
            XMLSignatureInput xMLSignatureInput = RetrievalMethodResolver.resolveInput(retrievalMethod, string2);
            if ("http://www.w3.org/2000/09/xmldsig#rawX509Certificate".equals(string3)) {
                X509Certificate x509Certificate = RetrievalMethodResolver.getRawCertificate(xMLSignatureInput);
                return x509Certificate;
            }
            Element element3 = RetrievalMethodResolver.obtainRefrenceElement(xMLSignatureInput);
            return RetrievalMethodResolver.resolveCertificate(element3, string2, storageResolver);
        }
        catch (XMLSecurityException xMLSecurityException) {
            log.debug("XMLSecurityException", xMLSecurityException);
        }
        catch (CertificateException certificateException) {
            log.debug("CertificateException", certificateException);
        }
        catch (IOException iOException) {
            log.debug("IOException", iOException);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            log.debug("ParserConfigurationException", parserConfigurationException);
        }
        catch (SAXException sAXException) {
            log.debug("SAXException", sAXException);
        }
        return null;
    }

    private static X509Certificate resolveCertificate(Element element2, String string2, StorageResolver storageResolver) throws KeyResolverException {
        if (log.isDebugEnabled()) {
            log.debug("Now we have a {" + element2.getNamespaceURI() + "}" + element2.getLocalName() + " Element");
        }
        if (element2 != null) {
            return KeyResolver.getX509Certificate(element2, string2, storageResolver);
        }
        return null;
    }

    private static PublicKey resolveKey(Element element2, String string2, StorageResolver storageResolver) throws KeyResolverException {
        if (log.isDebugEnabled()) {
            log.debug("Now we have a {" + element2.getNamespaceURI() + "}" + element2.getLocalName() + " Element");
        }
        if (element2 != null) {
            return KeyResolver.getPublicKey(element2, string2, storageResolver);
        }
        return null;
    }

    private static X509Certificate getRawCertificate(XMLSignatureInput xMLSignatureInput) throws CanonicalizationException, IOException, CertificateException {
        byte[] byArray = xMLSignatureInput.getBytes();
        CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
        X509Certificate x509Certificate = (X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(byArray));
        return x509Certificate;
    }

    private static XMLSignatureInput resolveInput(RetrievalMethod retrievalMethod, String string2) throws XMLSecurityException {
        Attr attr = retrievalMethod.getURIAttr();
        Transforms transforms = retrievalMethod.getTransforms();
        ResourceResolver resourceResolver = ResourceResolver.getInstance(attr, string2);
        if (resourceResolver != null) {
            XMLSignatureInput xMLSignatureInput = resourceResolver.resolve(attr, string2);
            if (transforms != null) {
                log.debug("We have Transforms");
                xMLSignatureInput = transforms.performTransforms(xMLSignatureInput);
            }
            return xMLSignatureInput;
        }
        return null;
    }

    static Element getDocFromBytes(byte[] byArray) throws KeyResolverException {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document2 = documentBuilder.parse(new ByteArrayInputStream(byArray));
            return document2.getDocumentElement();
        }
        catch (SAXException sAXException) {
            throw new KeyResolverException("empty", sAXException);
        }
        catch (IOException iOException) {
            throw new KeyResolverException("empty", iOException);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new KeyResolverException("empty", parserConfigurationException);
        }
    }

    public SecretKey engineLookupAndResolveSecretKey(Element element2, String string2, StorageResolver storageResolver) {
        return null;
    }

    static Element getDocumentElement(Set set2) {
        Object object;
        Object object2;
        Iterator iterator2 = set2.iterator();
        Element element2 = null;
        while (iterator2.hasNext()) {
            object2 = (Node)iterator2.next();
            if (!(object2 instanceof Element)) continue;
            element2 = (Element)object2;
            break;
        }
        object2 = new ArrayList(10);
        do {
            object2.add(element2);
        } while ((object = element2.getParentNode()) instanceof Element && (element2 = (Element)object) != null);
        object = object2.listIterator(object2.size() - 1);
        Element element3 = null;
        while (object.hasPrevious()) {
            element3 = (Element)object.previous();
            if (!set2.contains(element3)) continue;
            return element3;
        }
        return null;
    }
}

