/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.signature;

import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.signature.SignatureProperty;
import org.apache.xml.security.signature.XMLSignatureException;
import org.apache.xml.security.utils.IdResolver;
import org.apache.xml.security.utils.SignatureElementProxy;
import org.apache.xml.security.utils.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SignatureProperties
extends SignatureElementProxy {
    public SignatureProperties(Document document2) {
        super(document2);
        XMLUtils.addReturnToElement(this._constructionElement);
    }

    public SignatureProperties(Element element2, String string2) throws XMLSecurityException {
        super(element2, string2);
    }

    public int getLength() {
        Element[] elementArray = XMLUtils.selectDsNodes(this._constructionElement, "SignatureProperty");
        return elementArray.length;
    }

    public SignatureProperty item(int n) throws XMLSignatureException {
        try {
            Element element2 = XMLUtils.selectDsNode(this._constructionElement, "SignatureProperty", n);
            if (element2 == null) {
                return null;
            }
            return new SignatureProperty(element2, this._baseURI);
        }
        catch (XMLSecurityException xMLSecurityException) {
            throw new XMLSignatureException("empty", xMLSecurityException);
        }
    }

    public void setId(String string2) {
        if (string2 != null) {
            this._constructionElement.setAttributeNS(null, "Id", string2);
            IdResolver.registerElementById(this._constructionElement, string2);
        }
    }

    public String getId() {
        return this._constructionElement.getAttributeNS(null, "Id");
    }

    public void addSignatureProperty(SignatureProperty signatureProperty) {
        this._constructionElement.appendChild(signatureProperty.getElement());
        XMLUtils.addReturnToElement(this._constructionElement);
    }

    public String getBaseLocalName() {
        return "SignatureProperties";
    }
}

