/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.signature;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.xml.security.algorithms.SignatureAlgorithm;
import org.apache.xml.security.c14n.CanonicalizationException;
import org.apache.xml.security.c14n.Canonicalizer;
import org.apache.xml.security.c14n.InvalidCanonicalizerException;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.signature.Manifest;
import org.apache.xml.security.signature.MissingResourceFailureException;
import org.apache.xml.security.transforms.params.InclusiveNamespaces;
import org.apache.xml.security.utils.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class SignedInfo
extends Manifest {
    private SignatureAlgorithm _signatureAlgorithm = null;
    private byte[] _c14nizedBytes = null;
    private Element c14nMethod;
    private Element signatureMethod;

    public SignedInfo(Document document2) throws XMLSecurityException {
        this(document2, "http://www.w3.org/2000/09/xmldsig#dsa-sha1", "http://www.w3.org/TR/2001/REC-xml-c14n-20010315");
    }

    public SignedInfo(Document document2, String string2, String string3) throws XMLSecurityException {
        this(document2, string2, 0, string3);
    }

    public SignedInfo(Document document2, String string2, int n, String string3) throws XMLSecurityException {
        super(document2);
        this.c14nMethod = XMLUtils.createElementInSignatureSpace(this._doc, "CanonicalizationMethod");
        this.c14nMethod.setAttributeNS(null, "Algorithm", string3);
        this._constructionElement.appendChild(this.c14nMethod);
        XMLUtils.addReturnToElement(this._constructionElement);
        this._signatureAlgorithm = n > 0 ? new SignatureAlgorithm(this._doc, string2, n) : new SignatureAlgorithm(this._doc, string2);
        this.signatureMethod = this._signatureAlgorithm.getElement();
        this._constructionElement.appendChild(this.signatureMethod);
        XMLUtils.addReturnToElement(this._constructionElement);
    }

    public SignedInfo(Document document2, Element element2, Element element3) throws XMLSecurityException {
        super(document2);
        this.c14nMethod = element3;
        this._constructionElement.appendChild(this.c14nMethod);
        XMLUtils.addReturnToElement(this._constructionElement);
        this._signatureAlgorithm = new SignatureAlgorithm(element2, null);
        this.signatureMethod = this._signatureAlgorithm.getElement();
        this._constructionElement.appendChild(this.signatureMethod);
        XMLUtils.addReturnToElement(this._constructionElement);
    }

    public SignedInfo(Element element2, String string2) throws XMLSecurityException {
        super(element2, string2);
        this.c14nMethod = XMLUtils.getNextElement(element2.getFirstChild());
        String string3 = this.getCanonicalizationMethodURI();
        if (!(string3.equals("http://www.w3.org/TR/2001/REC-xml-c14n-20010315") || string3.equals("http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments") || string3.equals("http://www.w3.org/2001/10/xml-exc-c14n#") || string3.equals("http://www.w3.org/2001/10/xml-exc-c14n#WithComments"))) {
            try {
                Canonicalizer canonicalizer = Canonicalizer.getInstance(this.getCanonicalizationMethodURI());
                this._c14nizedBytes = canonicalizer.canonicalizeSubtree(this._constructionElement);
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                documentBuilderFactory.setNamespaceAware(true);
                DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                Document document2 = documentBuilder.parse(new ByteArrayInputStream(this._c14nizedBytes));
                Node node4 = this._doc.importNode(document2.getDocumentElement(), true);
                this._constructionElement.getParentNode().replaceChild(node4, this._constructionElement);
                this._constructionElement = (Element)node4;
            }
            catch (ParserConfigurationException parserConfigurationException) {
                throw new XMLSecurityException("empty", parserConfigurationException);
            }
            catch (IOException iOException) {
                throw new XMLSecurityException("empty", iOException);
            }
            catch (SAXException sAXException) {
                throw new XMLSecurityException("empty", sAXException);
            }
        }
        this.signatureMethod = XMLUtils.getNextElement(this.c14nMethod.getNextSibling());
        this._signatureAlgorithm = new SignatureAlgorithm(this.signatureMethod, this.getBaseURI());
    }

    public boolean verify() throws MissingResourceFailureException, XMLSecurityException {
        return super.verifyReferences(false);
    }

    public boolean verify(boolean bl) throws MissingResourceFailureException, XMLSecurityException {
        return super.verifyReferences(bl);
    }

    public byte[] getCanonicalizedOctetStream() throws CanonicalizationException, InvalidCanonicalizerException, XMLSecurityException {
        Object object;
        if (this._c14nizedBytes == null) {
            object = Canonicalizer.getInstance(this.getCanonicalizationMethodURI());
            this._c14nizedBytes = ((Canonicalizer)object).canonicalizeSubtree(this._constructionElement);
        }
        object = new byte[this._c14nizedBytes.length];
        System.arraycopy(this._c14nizedBytes, 0, object, 0, ((Object)object).length);
        return object;
    }

    public void signInOctectStream(OutputStream outputStream) throws CanonicalizationException, InvalidCanonicalizerException, XMLSecurityException {
        if (this._c14nizedBytes == null) {
            Canonicalizer canonicalizer = Canonicalizer.getInstance(this.getCanonicalizationMethodURI());
            canonicalizer.setWriter(outputStream);
            String string2 = this.getInclusiveNamespaces();
            if (string2 == null) {
                canonicalizer.canonicalizeSubtree(this._constructionElement);
            } else {
                canonicalizer.canonicalizeSubtree(this._constructionElement, string2);
            }
        } else {
            try {
                outputStream.write(this._c14nizedBytes);
            }
            catch (IOException iOException) {
                throw new RuntimeException("" + iOException);
            }
        }
    }

    public String getCanonicalizationMethodURI() {
        return this.c14nMethod.getAttributeNS(null, "Algorithm");
    }

    public String getSignatureMethodURI() {
        Element element2 = this.getSignatureMethodElement();
        if (element2 != null) {
            return element2.getAttributeNS(null, "Algorithm");
        }
        return null;
    }

    public Element getSignatureMethodElement() {
        return this.signatureMethod;
    }

    public SecretKey createSecretKey(byte[] byArray) {
        return new SecretKeySpec(byArray, this._signatureAlgorithm.getJCEAlgorithmString());
    }

    protected SignatureAlgorithm getSignatureAlgorithm() {
        return this._signatureAlgorithm;
    }

    public String getBaseLocalName() {
        return "SignedInfo";
    }

    public String getInclusiveNamespaces() {
        String string2 = this.c14nMethod.getAttributeNS(null, "Algorithm");
        if (!string2.equals("http://www.w3.org/2001/10/xml-exc-c14n#") && !string2.equals("http://www.w3.org/2001/10/xml-exc-c14n#WithComments")) {
            return null;
        }
        Element element2 = XMLUtils.getNextElement(this.c14nMethod.getFirstChild());
        if (element2 != null) {
            try {
                String string3 = new InclusiveNamespaces(element2, "http://www.w3.org/2001/10/xml-exc-c14n#").getInclusiveNamespaces();
                return string3;
            }
            catch (XMLSecurityException xMLSecurityException) {
                return null;
            }
        }
        return null;
    }
}

