/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.signature;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.Set;
import org.apache.xml.security.c14n.helper.AttrCompare;
import org.apache.xml.security.signature.XMLSignatureException;
import org.apache.xml.security.signature.XMLSignatureInput;
import org.apache.xml.security.utils.XMLUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;

public class XMLSignatureInputDebugger {
    private Set _xpathNodeSet;
    private Set _inclusiveNamespaces;
    private Document _doc = null;
    private Writer _writer = null;
    static final String HTMLPrefix = "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\">\n<html>\n<head>\n<title>Caninical XML node set</title>\n<style type=\"text/css\">\n<!-- \n.INCLUDED { \n   color: #000000; \n   background-color: \n   #FFFFFF; \n   font-weight: bold; } \n.EXCLUDED { \n   color: #666666; \n   background-color: \n   #999999; } \n.INCLUDEDINCLUSIVENAMESPACE { \n   color: #0000FF; \n   background-color: #FFFFFF; \n   font-weight: bold; \n   font-style: italic; } \n.EXCLUDEDINCLUSIVENAMESPACE { \n   color: #0000FF; \n   background-color: #999999; \n   font-style: italic; } \n--> \n</style> \n</head>\n<body bgcolor=\"#999999\">\n<h1>Explanation of the output</h1>\n<p>The following text contains the nodeset of the given Reference before it is canonicalized. There exist four different styles to indicate how a given node is treated.</p>\n<ul>\n<li class=\"INCLUDED\">A node which is in the node set is labeled using the INCLUDED style.</li>\n<li class=\"EXCLUDED\">A node which is <em>NOT</em> in the node set is labeled EXCLUDED style.</li>\n<li class=\"INCLUDEDINCLUSIVENAMESPACE\">A namespace which is in the node set AND in the InclusiveNamespaces PrefixList is labeled using the INCLUDEDINCLUSIVENAMESPACE style.</li>\n<li class=\"EXCLUDEDINCLUSIVENAMESPACE\">A namespace which is in NOT the node set AND in the InclusiveNamespaces PrefixList is labeled using the INCLUDEDINCLUSIVENAMESPACE style.</li>\n</ul>\n<h1>Output</h1>\n<pre>\n";
    static final String HTMLSuffix = "</pre></body></html>";
    static final String HTMLExcludePrefix = "<span class=\"EXCLUDED\">";
    static final String HTMLExcludeSuffix = "</span>";
    static final String HTMLIncludePrefix = "<span class=\"INCLUDED\">";
    static final String HTMLIncludeSuffix = "</span>";
    static final String HTMLIncludedInclusiveNamespacePrefix = "<span class=\"INCLUDEDINCLUSIVENAMESPACE\">";
    static final String HTMLIncludedInclusiveNamespaceSuffix = "</span>";
    static final String HTMLExcludedInclusiveNamespacePrefix = "<span class=\"EXCLUDEDINCLUSIVENAMESPACE\">";
    static final String HTMLExcludedInclusiveNamespaceSuffix = "</span>";
    private static final int NODE_BEFORE_DOCUMENT_ELEMENT = -1;
    private static final int NODE_NOT_BEFORE_OR_AFTER_DOCUMENT_ELEMENT = 0;
    private static final int NODE_AFTER_DOCUMENT_ELEMENT = 1;
    static final AttrCompare ATTR_COMPARE = new AttrCompare();

    private XMLSignatureInputDebugger() {
    }

    public XMLSignatureInputDebugger(XMLSignatureInput xMLSignatureInput) {
        this._xpathNodeSet = !xMLSignatureInput.isNodeSet() ? null : xMLSignatureInput._inputNodeSet;
    }

    public XMLSignatureInputDebugger(XMLSignatureInput xMLSignatureInput, Set set2) {
        this(xMLSignatureInput);
        this._inclusiveNamespaces = set2;
    }

    public String getHTMLRepresentation() throws XMLSignatureException {
        if (this._xpathNodeSet == null || this._xpathNodeSet.size() == 0) {
            return "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\">\n<html>\n<head>\n<title>Caninical XML node set</title>\n<style type=\"text/css\">\n<!-- \n.INCLUDED { \n   color: #000000; \n   background-color: \n   #FFFFFF; \n   font-weight: bold; } \n.EXCLUDED { \n   color: #666666; \n   background-color: \n   #999999; } \n.INCLUDEDINCLUSIVENAMESPACE { \n   color: #0000FF; \n   background-color: #FFFFFF; \n   font-weight: bold; \n   font-style: italic; } \n.EXCLUDEDINCLUSIVENAMESPACE { \n   color: #0000FF; \n   background-color: #999999; \n   font-style: italic; } \n--> \n</style> \n</head>\n<body bgcolor=\"#999999\">\n<h1>Explanation of the output</h1>\n<p>The following text contains the nodeset of the given Reference before it is canonicalized. There exist four different styles to indicate how a given node is treated.</p>\n<ul>\n<li class=\"INCLUDED\">A node which is in the node set is labeled using the INCLUDED style.</li>\n<li class=\"EXCLUDED\">A node which is <em>NOT</em> in the node set is labeled EXCLUDED style.</li>\n<li class=\"INCLUDEDINCLUSIVENAMESPACE\">A namespace which is in the node set AND in the InclusiveNamespaces PrefixList is labeled using the INCLUDEDINCLUSIVENAMESPACE style.</li>\n<li class=\"EXCLUDEDINCLUSIVENAMESPACE\">A namespace which is in NOT the node set AND in the InclusiveNamespaces PrefixList is labeled using the INCLUDEDINCLUSIVENAMESPACE style.</li>\n</ul>\n<h1>Output</h1>\n<pre>\n<blink>no node set, sorry</blink></pre></body></html>";
        }
        Object object = (Node)this._xpathNodeSet.iterator().next();
        this._doc = XMLUtils.getOwnerDocument((Node)object);
        try {
            this._writer = new StringWriter();
            this.canonicalizeXPathNodeSet(this._doc);
            this._writer.close();
            object = this._writer.toString();
            Object var3_3 = null;
            this._xpathNodeSet = null;
            this._doc = null;
            this._writer = null;
            return object;
        }
        catch (IOException iOException) {
            try {
                throw new XMLSignatureException("empty", iOException);
            }
            catch (Throwable throwable2) {
                Object var3_4 = null;
                this._xpathNodeSet = null;
                this._doc = null;
                this._writer = null;
                throw throwable2;
            }
        }
    }

    private void canonicalizeXPathNodeSet(Node node4) throws XMLSignatureException, IOException {
        short s2 = node4.getNodeType();
        switch (s2) {
            default: {
                break;
            }
            case 2: 
            case 6: 
            case 11: 
            case 12: {
                throw new XMLSignatureException("empty");
            }
            case 9: {
                this._writer.write(HTMLPrefix);
                for (Node node5 = node4.getFirstChild(); node5 != null; node5 = node5.getNextSibling()) {
                    this.canonicalizeXPathNodeSet(node5);
                }
                this._writer.write(HTMLSuffix);
                break;
            }
            case 8: {
                if (this._xpathNodeSet.contains(node4)) {
                    this._writer.write(HTMLIncludePrefix);
                } else {
                    this._writer.write(HTMLExcludePrefix);
                }
                int n = this.getPositionRelativeToDocumentElement(node4);
                if (n == 1) {
                    this._writer.write("\n");
                }
                this.outputCommentToWriter((Comment)node4);
                if (n == -1) {
                    this._writer.write("\n");
                }
                if (this._xpathNodeSet.contains(node4)) {
                    this._writer.write("</span>");
                    break;
                }
                this._writer.write("</span>");
                break;
            }
            case 7: {
                if (this._xpathNodeSet.contains(node4)) {
                    this._writer.write(HTMLIncludePrefix);
                } else {
                    this._writer.write(HTMLExcludePrefix);
                }
                int n = this.getPositionRelativeToDocumentElement(node4);
                if (n == 1) {
                    this._writer.write("\n");
                }
                this.outputPItoWriter((ProcessingInstruction)node4);
                if (n == -1) {
                    this._writer.write("\n");
                }
                if (this._xpathNodeSet.contains(node4)) {
                    this._writer.write("</span>");
                    break;
                }
                this._writer.write("</span>");
                break;
            }
            case 3: 
            case 4: {
                if (this._xpathNodeSet.contains(node4)) {
                    this._writer.write(HTMLIncludePrefix);
                } else {
                    this._writer.write(HTMLExcludePrefix);
                }
                this.outputTextToWriter(node4.getNodeValue());
                for (Node node6 = node4.getNextSibling(); node6 != null && (node6.getNodeType() == 3 || node6.getNodeType() == 4); node6 = node6.getNextSibling()) {
                    this.outputTextToWriter(node6.getNodeValue());
                }
                if (this._xpathNodeSet.contains(node4)) {
                    this._writer.write("</span>");
                    break;
                }
                this._writer.write("</span>");
                break;
            }
            case 1: {
                Element element2 = (Element)node4;
                if (this._xpathNodeSet.contains(node4)) {
                    this._writer.write(HTMLIncludePrefix);
                } else {
                    this._writer.write(HTMLExcludePrefix);
                }
                this._writer.write("&lt;");
                this._writer.write(element2.getTagName());
                if (this._xpathNodeSet.contains(node4)) {
                    this._writer.write("</span>");
                } else {
                    this._writer.write("</span>");
                }
                NamedNodeMap namedNodeMap = element2.getAttributes();
                int n = namedNodeMap.getLength();
                Object[] objectArray = new Object[n];
                for (int i = 0; i < n; ++i) {
                    objectArray[i] = namedNodeMap.item(i);
                }
                Arrays.sort(objectArray, ATTR_COMPARE);
                Object[] objectArray2 = objectArray;
                for (int i = 0; i < n; ++i) {
                    Attr attr = (Attr)objectArray2[i];
                    boolean bl = this._xpathNodeSet.contains(attr);
                    boolean bl2 = this._inclusiveNamespaces.contains(attr.getName());
                    if (bl) {
                        if (bl2) {
                            this._writer.write(HTMLIncludedInclusiveNamespacePrefix);
                        } else {
                            this._writer.write(HTMLIncludePrefix);
                        }
                    } else if (bl2) {
                        this._writer.write(HTMLExcludedInclusiveNamespacePrefix);
                    } else {
                        this._writer.write(HTMLExcludePrefix);
                    }
                    this.outputAttrToWriter(attr.getNodeName(), attr.getNodeValue());
                    if (bl) {
                        if (bl2) {
                            this._writer.write("</span>");
                            continue;
                        }
                        this._writer.write("</span>");
                        continue;
                    }
                    if (bl2) {
                        this._writer.write("</span>");
                        continue;
                    }
                    this._writer.write("</span>");
                }
                if (this._xpathNodeSet.contains(node4)) {
                    this._writer.write(HTMLIncludePrefix);
                } else {
                    this._writer.write(HTMLExcludePrefix);
                }
                this._writer.write("&gt;");
                if (this._xpathNodeSet.contains(node4)) {
                    this._writer.write("</span>");
                } else {
                    this._writer.write("</span>");
                }
                for (Node node7 = node4.getFirstChild(); node7 != null; node7 = node7.getNextSibling()) {
                    this.canonicalizeXPathNodeSet(node7);
                }
                if (this._xpathNodeSet.contains(node4)) {
                    this._writer.write(HTMLIncludePrefix);
                } else {
                    this._writer.write(HTMLExcludePrefix);
                }
                this._writer.write("&lt;/");
                this._writer.write(element2.getTagName());
                this._writer.write("&gt;");
                if (this._xpathNodeSet.contains(node4)) {
                    this._writer.write("</span>");
                    break;
                }
                this._writer.write("</span>");
            }
        }
    }

    private int getPositionRelativeToDocumentElement(Node node4) {
        if (node4 == null) {
            return 0;
        }
        Document document2 = node4.getOwnerDocument();
        if (node4.getParentNode() != document2) {
            return 0;
        }
        Element element2 = document2.getDocumentElement();
        if (element2 == null) {
            return 0;
        }
        if (element2 == node4) {
            return 0;
        }
        for (Node node5 = node4; node5 != null; node5 = node5.getNextSibling()) {
            if (node5 != element2) continue;
            return -1;
        }
        return 1;
    }

    private void outputAttrToWriter(String string2, String string3) throws IOException {
        this._writer.write(" ");
        this._writer.write(string2);
        this._writer.write("=\"");
        int n = string3.length();
        block8: for (int i = 0; i < n; ++i) {
            char c2 = string3.charAt(i);
            switch (c2) {
                case '&': {
                    this._writer.write("&amp;amp;");
                    continue block8;
                }
                case '<': {
                    this._writer.write("&amp;lt;");
                    continue block8;
                }
                case '\"': {
                    this._writer.write("&amp;quot;");
                    continue block8;
                }
                case '\t': {
                    this._writer.write("&amp;#x9;");
                    continue block8;
                }
                case '\n': {
                    this._writer.write("&amp;#xA;");
                    continue block8;
                }
                case '\r': {
                    this._writer.write("&amp;#xD;");
                    continue block8;
                }
                default: {
                    this._writer.write(c2);
                }
            }
        }
        this._writer.write("\"");
    }

    private void outputPItoWriter(ProcessingInstruction processingInstruction) throws IOException {
        int n;
        if (processingInstruction == null) {
            return;
        }
        this._writer.write("&lt;?");
        String string2 = processingInstruction.getTarget();
        int n2 = string2.length();
        block8: for (int i = 0; i < n2; ++i) {
            n = string2.charAt(i);
            switch (n) {
                case 13: {
                    this._writer.write("&amp;#xD;");
                    continue block8;
                }
                case 32: {
                    this._writer.write("&middot;");
                    continue block8;
                }
                case 10: {
                    this._writer.write("&para;\n");
                    continue block8;
                }
                default: {
                    this._writer.write(n);
                }
            }
        }
        String string3 = processingInstruction.getData();
        n2 = string3.length();
        if (n2 > 0) {
            this._writer.write(" ");
            block9: for (n = 0; n < n2; ++n) {
                char c2 = string3.charAt(n);
                switch (c2) {
                    case '\r': {
                        this._writer.write("&amp;#xD;");
                        continue block9;
                    }
                    default: {
                        this._writer.write(c2);
                    }
                }
            }
        }
        this._writer.write("?&gt;");
    }

    private void outputCommentToWriter(Comment comment2) throws IOException {
        if (comment2 == null) {
            return;
        }
        this._writer.write("&lt;!--");
        String string2 = comment2.getData();
        int n = string2.length();
        block5: for (int i = 0; i < n; ++i) {
            char c2 = string2.charAt(i);
            switch (c2) {
                case '\r': {
                    this._writer.write("&amp;#xD;");
                    continue block5;
                }
                case ' ': {
                    this._writer.write("&middot;");
                    continue block5;
                }
                case '\n': {
                    this._writer.write("&para;\n");
                    continue block5;
                }
                default: {
                    this._writer.write(c2);
                }
            }
        }
        this._writer.write("--&gt;");
    }

    private void outputTextToWriter(String string2) throws IOException {
        if (string2 == null) {
            return;
        }
        int n = string2.length();
        block8: for (int i = 0; i < n; ++i) {
            char c2 = string2.charAt(i);
            switch (c2) {
                case '&': {
                    this._writer.write("&amp;amp;");
                    continue block8;
                }
                case '<': {
                    this._writer.write("&amp;lt;");
                    continue block8;
                }
                case '>': {
                    this._writer.write("&amp;gt;");
                    continue block8;
                }
                case '\r': {
                    this._writer.write("&amp;#xD;");
                    continue block8;
                }
                case ' ': {
                    this._writer.write("&middot;");
                    continue block8;
                }
                case '\n': {
                    this._writer.write("&para;\n");
                    continue block8;
                }
                default: {
                    this._writer.write(c2);
                }
            }
        }
    }
}

