/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.transforms.implementations;

import org.apache.xml.security.signature.NodeFilter;
import org.apache.xml.security.signature.XMLSignatureInput;
import org.apache.xml.security.transforms.Transform;
import org.apache.xml.security.transforms.TransformSpi;
import org.apache.xml.security.transforms.TransformationException;
import org.apache.xml.security.utils.XMLUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class TransformEnvelopedSignature
extends TransformSpi {
    public static final String implementedTransformURI = "http://www.w3.org/2000/09/xmldsig#enveloped-signature";

    protected String engineGetURI() {
        return implementedTransformURI;
    }

    protected XMLSignatureInput enginePerformTransform(XMLSignatureInput xMLSignatureInput, Transform transform2) throws TransformationException {
        Node node4 = transform2.getElement();
        node4 = TransformEnvelopedSignature.searchSignatureElement(node4);
        xMLSignatureInput.setExcludeNode(node4);
        xMLSignatureInput.addNodeFilter(new EnvelopedNodeFilter(node4));
        return xMLSignatureInput;
    }

    private static Node searchSignatureElement(Node node4) throws TransformationException {
        boolean bl = false;
        while (node4 != null && node4.getNodeType() != 9) {
            Element element2 = (Element)node4;
            if (element2.getNamespaceURI().equals("http://www.w3.org/2000/09/xmldsig#") && element2.getLocalName().equals("Signature")) {
                bl = true;
                break;
            }
            node4 = node4.getParentNode();
        }
        if (!bl) {
            throw new TransformationException("envelopedSignatureTransformNotInSignatureElement");
        }
        return node4;
    }

    static class EnvelopedNodeFilter
    implements NodeFilter {
        Node exclude;

        EnvelopedNodeFilter(Node node4) {
            this.exclude = node4;
        }

        public int isNodeIncludeDO(Node node4, int n) {
            if (node4 == this.exclude) {
                return -1;
            }
            return 1;
        }

        public int isNodeInclude(Node node4) {
            if (node4 == this.exclude || XMLUtils.isDescendantOrSelf(this.exclude, node4)) {
                return -1;
            }
            return 1;
        }
    }
}

