/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.transforms.implementations;

import javax.xml.transform.TransformerException;
import org.apache.xml.security.exceptions.XMLSecurityRuntimeException;
import org.apache.xml.security.signature.NodeFilter;
import org.apache.xml.security.signature.XMLSignatureInput;
import org.apache.xml.security.transforms.Transform;
import org.apache.xml.security.transforms.TransformSpi;
import org.apache.xml.security.transforms.TransformationException;
import org.apache.xml.security.utils.CachedXPathAPIHolder;
import org.apache.xml.security.utils.CachedXPathFuncHereAPI;
import org.apache.xml.security.utils.XMLUtils;
import org.apache.xml.utils.PrefixResolver;
import org.apache.xml.utils.PrefixResolverDefault;
import org.apache.xpath.objects.XObject;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class TransformXPath
extends TransformSpi {
    public static final String implementedTransformURI = "http://www.w3.org/TR/1999/REC-xpath-19991116";

    protected String engineGetURI() {
        return implementedTransformURI;
    }

    protected XMLSignatureInput enginePerformTransform(XMLSignatureInput xMLSignatureInput, Transform transform2) throws TransformationException {
        try {
            CachedXPathAPIHolder.setDoc(transform2.getElement().getOwnerDocument());
            Element element2 = XMLUtils.selectDsNode(transform2.getElement().getFirstChild(), "XPath", 0);
            if (element2 == null) {
                Object[] objectArray = new Object[]{"ds:XPath", "Transform"};
                throw new TransformationException("xml.WrongContent", objectArray);
            }
            Node node4 = element2.getChildNodes().item(0);
            String string2 = CachedXPathFuncHereAPI.getStrFromNode(node4);
            xMLSignatureInput.setNeedsToBeExpanded(this.needsCircunvent(string2));
            if (node4 == null) {
                throw new DOMException(3, "Text must be in ds:Xpath");
            }
            xMLSignatureInput.addNodeFilter(new XPathNodeFilter(element2, node4, string2));
            xMLSignatureInput.setNodeSet(true);
            return xMLSignatureInput;
        }
        catch (DOMException dOMException) {
            throw new TransformationException("empty", dOMException);
        }
    }

    private boolean needsCircunvent(String string2) {
        return string2.indexOf("namespace") != -1 || string2.indexOf("name()") != -1;
    }

    static class XPathNodeFilter
    implements NodeFilter {
        PrefixResolverDefault prefixResolver;
        CachedXPathFuncHereAPI xPathFuncHereAPI = new CachedXPathFuncHereAPI(CachedXPathAPIHolder.getCachedXPathAPI());
        Node xpathnode;
        String str;

        XPathNodeFilter(Element element2, Node node4, String string2) {
            this.xpathnode = node4;
            this.str = string2;
            this.prefixResolver = new PrefixResolverDefault((Node)element2);
        }

        public int isNodeInclude(Node node4) {
            try {
                XObject xObject = this.xPathFuncHereAPI.eval(node4, this.xpathnode, this.str, (PrefixResolver)this.prefixResolver);
                if (xObject.bool()) {
                    return 1;
                }
                return 0;
            }
            catch (TransformerException transformerException) {
                Object[] objectArray = new Object[]{node4};
                throw new XMLSecurityRuntimeException("signature.Transform.node", objectArray, transformerException);
            }
            catch (Exception exception) {
                Object[] objectArray = new Object[]{node4, new Short(node4.getNodeType())};
                throw new XMLSecurityRuntimeException("signature.Transform.nodeAndType", objectArray, exception);
            }
        }

        public int isNodeIncludeDO(Node node4, int n) {
            return this.isNodeInclude(node4);
        }
    }
}

