/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.transforms.implementations;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.xml.security.c14n.CanonicalizationException;
import org.apache.xml.security.c14n.InvalidCanonicalizerException;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.signature.XMLSignatureInput;
import org.apache.xml.security.transforms.Transform;
import org.apache.xml.security.transforms.TransformSpi;
import org.apache.xml.security.transforms.TransformationException;
import org.apache.xml.security.transforms.implementations.XPath2NodeFilter;
import org.apache.xml.security.transforms.params.XPath2FilterContainer;
import org.apache.xml.security.utils.CachedXPathAPIHolder;
import org.apache.xml.security.utils.CachedXPathFuncHereAPI;
import org.apache.xml.security.utils.XMLUtils;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class TransformXPath2Filter
extends TransformSpi {
    public static final String implementedTransformURI = "http://www.w3.org/2002/06/xmldsig-filter2";

    protected String engineGetURI() {
        return implementedTransformURI;
    }

    protected XMLSignatureInput enginePerformTransform(XMLSignatureInput xMLSignatureInput, Transform transform2) throws TransformationException {
        CachedXPathAPIHolder.setDoc(transform2.getElement().getOwnerDocument());
        try {
            ArrayList<NodeList> arrayList = new ArrayList<NodeList>();
            ArrayList<NodeList> arrayList2 = new ArrayList<NodeList>();
            ArrayList<NodeList> arrayList3 = new ArrayList<NodeList>();
            CachedXPathFuncHereAPI cachedXPathFuncHereAPI = new CachedXPathFuncHereAPI(CachedXPathAPIHolder.getCachedXPathAPI());
            Element[] elementArray = XMLUtils.selectNodes(transform2.getElement().getFirstChild(), implementedTransformURI, "XPath");
            int n = elementArray.length;
            if (n == 0) {
                Object[] objectArray = new Object[]{implementedTransformURI, "XPath"};
                throw new TransformationException("xml.WrongContent", objectArray);
            }
            Document document2 = null;
            document2 = xMLSignatureInput.getSubNode() != null ? XMLUtils.getOwnerDocument(xMLSignatureInput.getSubNode()) : XMLUtils.getOwnerDocument(xMLSignatureInput.getNodeSet());
            for (int i = 0; i < n; ++i) {
                Element element2 = XMLUtils.selectNode(transform2.getElement().getFirstChild(), implementedTransformURI, "XPath", i);
                XPath2FilterContainer xPath2FilterContainer = XPath2FilterContainer.newInstance(element2, xMLSignatureInput.getSourceURI());
                NodeList nodeList = cachedXPathFuncHereAPI.selectNodeList(document2, xPath2FilterContainer.getXPathFilterTextNode(), CachedXPathFuncHereAPI.getStrFromNode(xPath2FilterContainer.getXPathFilterTextNode()), xPath2FilterContainer.getElement());
                if (xPath2FilterContainer.isIntersect()) {
                    arrayList3.add(nodeList);
                    continue;
                }
                if (xPath2FilterContainer.isSubtract()) {
                    arrayList2.add(nodeList);
                    continue;
                }
                if (!xPath2FilterContainer.isUnion()) continue;
                arrayList.add(nodeList);
            }
            xMLSignatureInput.addNodeFilter(new XPath2NodeFilter(TransformXPath2Filter.convertNodeListToSet(arrayList), TransformXPath2Filter.convertNodeListToSet(arrayList2), TransformXPath2Filter.convertNodeListToSet(arrayList3)));
            xMLSignatureInput.setNodeSet(true);
            return xMLSignatureInput;
        }
        catch (TransformerException transformerException) {
            throw new TransformationException("empty", transformerException);
        }
        catch (DOMException dOMException) {
            throw new TransformationException("empty", dOMException);
        }
        catch (CanonicalizationException canonicalizationException) {
            throw new TransformationException("empty", canonicalizationException);
        }
        catch (InvalidCanonicalizerException invalidCanonicalizerException) {
            throw new TransformationException("empty", invalidCanonicalizerException);
        }
        catch (XMLSecurityException xMLSecurityException) {
            throw new TransformationException("empty", xMLSecurityException);
        }
        catch (SAXException sAXException) {
            throw new TransformationException("empty", sAXException);
        }
        catch (IOException iOException) {
            throw new TransformationException("empty", iOException);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new TransformationException("empty", parserConfigurationException);
        }
    }

    static Set convertNodeListToSet(List list2) {
        HashSet<Node> hashSet = new HashSet<Node>();
        for (int i = 0; i < list2.size(); ++i) {
            NodeList nodeList = (NodeList)list2.get(i);
            int n = nodeList.getLength();
            for (int j = 0; j < n; ++j) {
                Node node4 = nodeList.item(j);
                hashSet.add(node4);
            }
        }
        return hashSet;
    }
}

