/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.transforms.implementations;

import java.util.Iterator;
import java.util.Set;
import org.apache.xml.security.signature.NodeFilter;
import org.apache.xml.security.utils.XMLUtils;
import org.w3c.dom.Node;

class XPath2NodeFilter
implements NodeFilter {
    boolean hasUnionNodes;
    boolean hasSubstractNodes;
    boolean hasIntersectNodes;
    Set unionNodes;
    Set substractNodes;
    Set intersectNodes;
    int inSubstract = -1;
    int inIntersect = -1;
    int inUnion = -1;

    XPath2NodeFilter(Set set2, Set set3, Set set4) {
        this.unionNodes = set2;
        this.hasUnionNodes = !set2.isEmpty();
        this.substractNodes = set3;
        this.hasSubstractNodes = !set3.isEmpty();
        this.intersectNodes = set4;
        this.hasIntersectNodes = !set4.isEmpty();
    }

    public int isNodeInclude(Node node4) {
        int n = 1;
        if (this.hasSubstractNodes && XPath2NodeFilter.rooted(node4, this.substractNodes)) {
            n = -1;
        } else if (this.hasIntersectNodes && !XPath2NodeFilter.rooted(node4, this.intersectNodes)) {
            n = 0;
        }
        if (n == 1) {
            return 1;
        }
        if (this.hasUnionNodes) {
            if (XPath2NodeFilter.rooted(node4, this.unionNodes)) {
                return 1;
            }
            n = 0;
        }
        return n;
    }

    public int isNodeIncludeDO(Node node4, int n) {
        int n2 = 1;
        if (this.hasSubstractNodes) {
            if (this.inSubstract == -1 || n <= this.inSubstract) {
                this.inSubstract = XPath2NodeFilter.inList(node4, this.substractNodes) ? n : -1;
            }
            if (this.inSubstract != -1) {
                n2 = -1;
            }
        }
        if (n2 != -1 && this.hasIntersectNodes && (this.inIntersect == -1 || n <= this.inIntersect)) {
            if (!XPath2NodeFilter.inList(node4, this.intersectNodes)) {
                this.inIntersect = -1;
                n2 = 0;
            } else {
                this.inIntersect = n;
            }
        }
        if (n <= this.inUnion) {
            this.inUnion = -1;
        }
        if (n2 == 1) {
            return 1;
        }
        if (this.hasUnionNodes) {
            if (this.inUnion == -1 && XPath2NodeFilter.inList(node4, this.unionNodes)) {
                this.inUnion = n;
            }
            if (this.inUnion != -1) {
                return 1;
            }
            n2 = 0;
        }
        return n2;
    }

    static boolean rooted(Node node4, Set set2) {
        if (set2.contains(node4)) {
            return true;
        }
        Iterator iterator2 = set2.iterator();
        while (iterator2.hasNext()) {
            Node node5 = (Node)iterator2.next();
            if (!XMLUtils.isDescendantOrSelf(node5, node4)) continue;
            return true;
        }
        return false;
    }

    static boolean inList(Node node4, Set set2) {
        return set2.contains(node4);
    }
}

