/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.transforms.params;

import java.util.Iterator;
import java.util.Set;
import java.util.SortedSet;
import java.util.StringTokenizer;
import java.util.TreeSet;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.transforms.TransformParam;
import org.apache.xml.security.utils.ElementProxy;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class InclusiveNamespaces
extends ElementProxy
implements TransformParam {
    public static final String _TAG_EC_INCLUSIVENAMESPACES = "InclusiveNamespaces";
    public static final String _ATT_EC_PREFIXLIST = "PrefixList";
    public static final String ExclusiveCanonicalizationNamespace = "http://www.w3.org/2001/10/xml-exc-c14n#";

    public InclusiveNamespaces(Document document2, String string2) {
        this(document2, InclusiveNamespaces.prefixStr2Set(string2));
    }

    public InclusiveNamespaces(Document document2, Set set2) {
        super(document2);
        StringBuffer stringBuffer = new StringBuffer();
        TreeSet treeSet = new TreeSet(set2);
        Iterator iterator2 = treeSet.iterator();
        while (iterator2.hasNext()) {
            String string2 = (String)iterator2.next();
            if (string2.equals("xmlns")) {
                stringBuffer.append("#default ");
                continue;
            }
            stringBuffer.append(string2 + " ");
        }
        this._constructionElement.setAttributeNS(null, _ATT_EC_PREFIXLIST, stringBuffer.toString().trim());
    }

    public String getInclusiveNamespaces() {
        return this._constructionElement.getAttributeNS(null, _ATT_EC_PREFIXLIST);
    }

    public InclusiveNamespaces(Element element2, String string2) throws XMLSecurityException {
        super(element2, string2);
    }

    public static SortedSet prefixStr2Set(String string2) {
        TreeSet<String> treeSet = new TreeSet<String>();
        if (string2 == null || string2.length() == 0) {
            return treeSet;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2, " \t\r\n");
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            if (string3.equals("#default")) {
                treeSet.add("xmlns");
                continue;
            }
            treeSet.add(string3);
        }
        return treeSet;
    }

    public String getBaseNamespace() {
        return ExclusiveCanonicalizationNamespace;
    }

    public String getBaseLocalName() {
        return _TAG_EC_INCLUSIVENAMESPACES;
    }
}

