/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.transforms.params;

import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.transforms.TransformParam;
import org.apache.xml.security.utils.ElementProxy;
import org.apache.xml.security.utils.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XPathFilterCHGPContainer
extends ElementProxy
implements TransformParam {
    private static final String _TAG_INCLUDE_BUT_SEARCH = "IncludeButSearch";
    private static final String _TAG_EXCLUDE_BUT_SEARCH = "ExcludeButSearch";
    private static final String _TAG_EXCLUDE = "Exclude";
    public static final String _TAG_XPATHCHGP = "XPathAlternative";
    public static final String _ATT_INCLUDESLASH = "IncludeSlashPolicy";
    public static final boolean IncludeSlash = true;
    public static final boolean ExcludeSlash = false;

    private XPathFilterCHGPContainer() {
    }

    private XPathFilterCHGPContainer(Document document2, boolean bl, String string2, String string3, String string4) {
        super(document2);
        Element element2;
        if (bl) {
            this._constructionElement.setAttributeNS(null, _ATT_INCLUDESLASH, "true");
        } else {
            this._constructionElement.setAttributeNS(null, _ATT_INCLUDESLASH, "false");
        }
        if (string2 != null && string2.trim().length() > 0) {
            element2 = ElementProxy.createElementForFamily(document2, this.getBaseNamespace(), _TAG_INCLUDE_BUT_SEARCH);
            element2.appendChild(this._doc.createTextNode(XPathFilterCHGPContainer.indentXPathText(string2)));
            XMLUtils.addReturnToElement(this._constructionElement);
            this._constructionElement.appendChild(element2);
        }
        if (string3 != null && string3.trim().length() > 0) {
            element2 = ElementProxy.createElementForFamily(document2, this.getBaseNamespace(), _TAG_EXCLUDE_BUT_SEARCH);
            element2.appendChild(this._doc.createTextNode(XPathFilterCHGPContainer.indentXPathText(string3)));
            XMLUtils.addReturnToElement(this._constructionElement);
            this._constructionElement.appendChild(element2);
        }
        if (string4 != null && string4.trim().length() > 0) {
            element2 = ElementProxy.createElementForFamily(document2, this.getBaseNamespace(), _TAG_EXCLUDE);
            element2.appendChild(this._doc.createTextNode(XPathFilterCHGPContainer.indentXPathText(string4)));
            XMLUtils.addReturnToElement(this._constructionElement);
            this._constructionElement.appendChild(element2);
        }
        XMLUtils.addReturnToElement(this._constructionElement);
    }

    static String indentXPathText(String string2) {
        if (string2.length() > 2 && !Character.isWhitespace(string2.charAt(0))) {
            return "\n" + string2 + "\n";
        }
        return string2;
    }

    private XPathFilterCHGPContainer(Element element2, String string2) throws XMLSecurityException {
        super(element2, string2);
    }

    public static XPathFilterCHGPContainer getInstance(Document document2, boolean bl, String string2, String string3, String string4) {
        return new XPathFilterCHGPContainer(document2, bl, string2, string3, string4);
    }

    public static XPathFilterCHGPContainer getInstance(Element element2, String string2) throws XMLSecurityException {
        return new XPathFilterCHGPContainer(element2, string2);
    }

    private String getXStr(String string2) {
        if (this.length(this.getBaseNamespace(), string2) != 1) {
            return "";
        }
        Element element2 = XMLUtils.selectNode(this._constructionElement.getFirstChild(), this.getBaseNamespace(), string2, 0);
        return XMLUtils.getFullTextChildrenFromElement(element2);
    }

    public String getIncludeButSearch() {
        return this.getXStr(_TAG_INCLUDE_BUT_SEARCH);
    }

    public String getExcludeButSearch() {
        return this.getXStr(_TAG_EXCLUDE_BUT_SEARCH);
    }

    public String getExclude() {
        return this.getXStr(_TAG_EXCLUDE);
    }

    public boolean getIncludeSlashPolicy() {
        return this._constructionElement.getAttributeNS(null, _ATT_INCLUDESLASH).equals("true");
    }

    private Node getHereContextNode(String string2) {
        if (this.length(this.getBaseNamespace(), string2) != 1) {
            return null;
        }
        return XMLUtils.selectNodeText(this._constructionElement.getFirstChild(), this.getBaseNamespace(), string2, 0);
    }

    public Node getHereContextNodeIncludeButSearch() {
        return this.getHereContextNode(_TAG_INCLUDE_BUT_SEARCH);
    }

    public Node getHereContextNodeExcludeButSearch() {
        return this.getHereContextNode(_TAG_EXCLUDE_BUT_SEARCH);
    }

    public Node getHereContextNodeExclude() {
        return this.getHereContextNode(_TAG_EXCLUDE);
    }

    public final String getBaseLocalName() {
        return _TAG_XPATHCHGP;
    }

    public final String getBaseNamespace() {
        return "http://www.nue.et-inf.uni-siegen.de/~geuer-pollmann/#xpathFilter";
    }
}

