/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.utils;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import org.apache.xml.security.exceptions.Base64DecodingException;
import org.apache.xml.security.utils.I18n;
import org.apache.xml.security.utils.UnsyncByteArrayOutputStream;
import org.apache.xml.security.utils.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class Base64 {
    public static final int BASE64DEFAULTLENGTH = 76;
    private static final int BASELENGTH = 255;
    private static final int LOOKUPLENGTH = 64;
    private static final int TWENTYFOURBITGROUP = 24;
    private static final int EIGHTBIT = 8;
    private static final int SIXTEENBIT = 16;
    private static final int FOURBYTE = 4;
    private static final int SIGN = -128;
    private static final char PAD = '=';
    private static final byte[] base64Alphabet;
    private static final char[] lookUpBase64Alphabet;

    private Base64() {
    }

    static final byte[] getBytes(BigInteger bigInteger, int n) {
        if ((n = n + 7 >> 3 << 3) < bigInteger.bitLength()) {
            throw new IllegalArgumentException(I18n.translate("utils.Base64.IllegalBitlength"));
        }
        byte[] byArray = bigInteger.toByteArray();
        if (bigInteger.bitLength() % 8 != 0 && bigInteger.bitLength() / 8 + 1 == n / 8) {
            return byArray;
        }
        int n2 = 0;
        int n3 = byArray.length;
        if (bigInteger.bitLength() % 8 == 0) {
            n2 = 1;
            --n3;
        }
        int n4 = n / 8 - n3;
        byte[] byArray2 = new byte[n / 8];
        System.arraycopy(byArray, n2, byArray2, n4, n3);
        return byArray2;
    }

    public static final String encode(BigInteger bigInteger) {
        return Base64.encode(Base64.getBytes(bigInteger, bigInteger.bitLength()));
    }

    public static final byte[] encode(BigInteger bigInteger, int n) {
        if ((n = n + 7 >> 3 << 3) < bigInteger.bitLength()) {
            throw new IllegalArgumentException(I18n.translate("utils.Base64.IllegalBitlength"));
        }
        byte[] byArray = bigInteger.toByteArray();
        if (bigInteger.bitLength() % 8 != 0 && bigInteger.bitLength() / 8 + 1 == n / 8) {
            return byArray;
        }
        int n2 = 0;
        int n3 = byArray.length;
        if (bigInteger.bitLength() % 8 == 0) {
            n2 = 1;
            --n3;
        }
        int n4 = n / 8 - n3;
        byte[] byArray2 = new byte[n / 8];
        System.arraycopy(byArray, n2, byArray2, n4, n3);
        return byArray2;
    }

    public static final BigInteger decodeBigIntegerFromElement(Element element2) throws Base64DecodingException {
        return new BigInteger(1, Base64.decode(element2));
    }

    public static final BigInteger decodeBigIntegerFromText(Text text2) throws Base64DecodingException {
        return new BigInteger(1, Base64.decode(text2.getData()));
    }

    public static final void fillElementWithBigInteger(Element element2, BigInteger bigInteger) {
        String string2 = Base64.encode(bigInteger);
        if (string2.length() > 76) {
            string2 = "\n" + string2 + "\n";
        }
        Document document2 = element2.getOwnerDocument();
        Text text2 = document2.createTextNode(string2);
        element2.appendChild(text2);
    }

    public static final byte[] decode(Element element2) throws Base64DecodingException {
        StringBuffer stringBuffer = new StringBuffer();
        for (Node node4 = element2.getFirstChild(); node4 != null; node4 = node4.getNextSibling()) {
            if (node4.getNodeType() != 3) continue;
            Text text2 = (Text)node4;
            stringBuffer.append(text2.getData());
        }
        return Base64.decode(stringBuffer.toString());
    }

    public static final Element encodeToElement(Document document2, String string2, byte[] byArray) {
        Element element2 = XMLUtils.createElementInSignatureSpace(document2, string2);
        Text text2 = document2.createTextNode(Base64.encode(byArray));
        element2.appendChild(text2);
        return element2;
    }

    public static final byte[] decode(byte[] byArray) throws Base64DecodingException {
        return Base64.decodeInternal(byArray, -1);
    }

    public static final String encode(byte[] byArray) {
        return XMLUtils.ignoreLineBreaks() ? Base64.encode(byArray, Integer.MAX_VALUE) : Base64.encode(byArray, 76);
    }

    public static final byte[] decode(BufferedReader bufferedReader) throws IOException, Base64DecodingException {
        String string2;
        UnsyncByteArrayOutputStream unsyncByteArrayOutputStream = new UnsyncByteArrayOutputStream();
        while (null != (string2 = bufferedReader.readLine())) {
            byte[] byArray = Base64.decode(string2);
            unsyncByteArrayOutputStream.write(byArray);
        }
        return unsyncByteArrayOutputStream.toByteArray();
    }

    protected static final boolean isWhiteSpace(byte by2) {
        return by2 == 32 || by2 == 13 || by2 == 10 || by2 == 9;
    }

    protected static final boolean isPad(byte by2) {
        return by2 == 61;
    }

    public static final String encode(byte[] byArray, int n) {
        byte by2;
        int n2;
        int n3;
        if (n < 4) {
            n = Integer.MAX_VALUE;
        }
        if (byArray == null) {
            return null;
        }
        int n4 = byArray.length * 8;
        if (n4 == 0) {
            return "";
        }
        int n5 = n4 % 24;
        int n6 = n4 / 24;
        int n7 = n5 != 0 ? n6 + 1 : n6;
        int n8 = n / 4;
        int n9 = (n7 - 1) / n8;
        char[] cArray = null;
        cArray = new char[n7 * 4 + n9];
        byte by3 = 0;
        byte by4 = 0;
        byte by5 = 0;
        byte by6 = 0;
        byte by7 = 0;
        int n10 = 0;
        int n11 = 0;
        int n12 = 0;
        for (n3 = 0; n3 < n9; ++n3) {
            for (n2 = 0; n2 < 19; ++n2) {
                by5 = byArray[n11++];
                by6 = byArray[n11++];
                by7 = byArray[n11++];
                by4 = (byte)(by6 & 0xF);
                by3 = (byte)(by5 & 3);
                by2 = (by5 & 0xFFFFFF80) == 0 ? (byte)(by5 >> 2) : (byte)(by5 >> 2 ^ 0xC0);
                byte by8 = (by6 & 0xFFFFFF80) == 0 ? (byte)(by6 >> 4) : (byte)(by6 >> 4 ^ 0xF0);
                byte by9 = (by7 & 0xFFFFFF80) == 0 ? (byte)(by7 >> 6) : (byte)(by7 >> 6 ^ 0xFC);
                cArray[n10++] = lookUpBase64Alphabet[by2];
                cArray[n10++] = lookUpBase64Alphabet[by8 | by3 << 4];
                cArray[n10++] = lookUpBase64Alphabet[by4 << 2 | by9];
                cArray[n10++] = lookUpBase64Alphabet[by7 & 0x3F];
                ++n12;
            }
            cArray[n10++] = 10;
        }
        while (n12 < n6) {
            by5 = byArray[n11++];
            by6 = byArray[n11++];
            by7 = byArray[n11++];
            by4 = (byte)(by6 & 0xF);
            by3 = (byte)(by5 & 3);
            n3 = (by5 & 0xFFFFFF80) == 0 ? (byte)(by5 >> 2) : (byte)(by5 >> 2 ^ 0xC0);
            n2 = (by6 & 0xFFFFFF80) == 0 ? (byte)(by6 >> 4) : (byte)(by6 >> 4 ^ 0xF0);
            by2 = (by7 & 0xFFFFFF80) == 0 ? (byte)(by7 >> 6) : (byte)(by7 >> 6 ^ 0xFC);
            cArray[n10++] = lookUpBase64Alphabet[n3];
            cArray[n10++] = lookUpBase64Alphabet[n2 | by3 << 4];
            cArray[n10++] = lookUpBase64Alphabet[by4 << 2 | by2];
            cArray[n10++] = lookUpBase64Alphabet[by7 & 0x3F];
            ++n12;
        }
        if (n5 == 8) {
            by5 = byArray[n11];
            by3 = (byte)(by5 & 3);
            n3 = (by5 & 0xFFFFFF80) == 0 ? (byte)(by5 >> 2) : (byte)(by5 >> 2 ^ 0xC0);
            cArray[n10++] = lookUpBase64Alphabet[n3];
            cArray[n10++] = lookUpBase64Alphabet[by3 << 4];
            cArray[n10++] = 61;
            cArray[n10++] = 61;
        } else if (n5 == 16) {
            by5 = byArray[n11];
            by6 = byArray[n11 + 1];
            by4 = (byte)(by6 & 0xF);
            by3 = (byte)(by5 & 3);
            n3 = (by5 & 0xFFFFFF80) == 0 ? (byte)(by5 >> 2) : (byte)(by5 >> 2 ^ 0xC0);
            n2 = (by6 & 0xFFFFFF80) == 0 ? (byte)(by6 >> 4) : (byte)(by6 >> 4 ^ 0xF0);
            cArray[n10++] = lookUpBase64Alphabet[n3];
            cArray[n10++] = lookUpBase64Alphabet[n2 | by3 << 4];
            cArray[n10++] = lookUpBase64Alphabet[by4 << 2];
            cArray[n10++] = 61;
        }
        return new String(cArray);
    }

    public static final byte[] decode(String string2) throws Base64DecodingException {
        if (string2 == null) {
            return null;
        }
        byte[] byArray = new byte[string2.length()];
        int n = Base64.getBytesInternal(string2, byArray);
        return Base64.decodeInternal(byArray, n);
    }

    protected static final int getBytesInternal(String string2, byte[] byArray) {
        int n = string2.length();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            byte by2 = (byte)string2.charAt(i);
            if (Base64.isWhiteSpace(by2)) continue;
            byArray[n2++] = by2;
        }
        return n2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static final byte[] decodeInternal(byte[] byArray, int n) throws Base64DecodingException {
        if (n == -1) {
            n = Base64.removeWhiteSpace(byArray);
        }
        if (n % 4 != 0) {
            throw new Base64DecodingException("decoding.divisible.four");
        }
        int n2 = n / 4;
        if (n2 == 0) {
            return new byte[0];
        }
        byte[] byArray2 = null;
        byte by2 = 0;
        byte by3 = 0;
        byte by4 = 0;
        byte by5 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        n5 = (n2 - 1) * 4;
        n4 = (n2 - 1) * 3;
        by2 = base64Alphabet[byArray[n5++]];
        by3 = base64Alphabet[byArray[n5++]];
        if (by2 == -1 || by3 == -1) {
            throw new Base64DecodingException("decoding.general");
        }
        byte by6 = byArray[n5++];
        by4 = base64Alphabet[by6];
        byte by7 = byArray[n5++];
        by5 = base64Alphabet[by7];
        if (by4 == -1 || by5 == -1) {
            if (Base64.isPad(by6) && Base64.isPad(by7)) {
                if ((by3 & 0xF) != 0) {
                    throw new Base64DecodingException("decoding.general");
                }
                byArray2 = new byte[n4 + 1];
                byArray2[n4] = (byte)(by2 << 2 | by3 >> 4);
            } else {
                if (Base64.isPad(by6) || !Base64.isPad(by7)) throw new Base64DecodingException("decoding.general");
                if ((by4 & 3) != 0) {
                    throw new Base64DecodingException("decoding.general");
                }
                byArray2 = new byte[n4 + 2];
                byArray2[n4++] = (byte)(by2 << 2 | by3 >> 4);
                byArray2[n4] = (byte)((by3 & 0xF) << 4 | by4 >> 2 & 0xF);
            }
        } else {
            byArray2 = new byte[n4 + 3];
            byArray2[n4++] = (byte)(by2 << 2 | by3 >> 4);
            byArray2[n4++] = (byte)((by3 & 0xF) << 4 | by4 >> 2 & 0xF);
            byArray2[n4++] = (byte)(by4 << 6 | by5);
        }
        n4 = 0;
        n5 = 0;
        for (n3 = n2 - 1; n3 > 0; --n3) {
            by2 = base64Alphabet[byArray[n5++]];
            by3 = base64Alphabet[byArray[n5++]];
            by4 = base64Alphabet[byArray[n5++]];
            by5 = base64Alphabet[byArray[n5++]];
            if (by2 == -1 || by3 == -1 || by4 == -1 || by5 == -1) {
                throw new Base64DecodingException("decoding.general");
            }
            byArray2[n4++] = (byte)(by2 << 2 | by3 >> 4);
            byArray2[n4++] = (byte)((by3 & 0xF) << 4 | by4 >> 2 & 0xF);
            byArray2[n4++] = (byte)(by4 << 6 | by5);
        }
        return byArray2;
    }

    public static final void decode(String string2, OutputStream outputStream) throws Base64DecodingException, IOException {
        byte[] byArray = new byte[string2.length()];
        int n = Base64.getBytesInternal(string2, byArray);
        Base64.decode(byArray, outputStream, n);
    }

    public static final void decode(byte[] byArray, OutputStream outputStream) throws Base64DecodingException, IOException {
        Base64.decode(byArray, outputStream, -1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static final void decode(byte[] byArray, OutputStream outputStream, int n) throws Base64DecodingException, IOException {
        if (n == -1) {
            n = Base64.removeWhiteSpace(byArray);
        }
        if (n % 4 != 0) {
            throw new Base64DecodingException("decoding.divisible.four");
        }
        int n2 = n / 4;
        if (n2 == 0) {
            return;
        }
        byte by2 = 0;
        byte by3 = 0;
        byte by4 = 0;
        byte by5 = 0;
        int n3 = 0;
        int n4 = 0;
        for (n3 = n2 - 1; n3 > 0; --n3) {
            by2 = base64Alphabet[byArray[n4++]];
            by3 = base64Alphabet[byArray[n4++]];
            by4 = base64Alphabet[byArray[n4++]];
            by5 = base64Alphabet[byArray[n4++]];
            if (by2 == -1 || by3 == -1 || by4 == -1 || by5 == -1) {
                throw new Base64DecodingException("decoding.general");
            }
            outputStream.write((byte)(by2 << 2 | by3 >> 4));
            outputStream.write((byte)((by3 & 0xF) << 4 | by4 >> 2 & 0xF));
            outputStream.write((byte)(by4 << 6 | by5));
        }
        by2 = base64Alphabet[byArray[n4++]];
        by3 = base64Alphabet[byArray[n4++]];
        if (by2 == -1 || by3 == -1) {
            throw new Base64DecodingException("decoding.general");
        }
        byte by6 = byArray[n4++];
        by4 = base64Alphabet[by6];
        byte by7 = byArray[n4++];
        by5 = base64Alphabet[by7];
        if (by4 == -1 || by5 == -1) {
            if (Base64.isPad(by6) && Base64.isPad(by7)) {
                if ((by3 & 0xF) != 0) {
                    throw new Base64DecodingException("decoding.general");
                }
                outputStream.write((byte)(by2 << 2 | by3 >> 4));
                return;
            } else {
                if (Base64.isPad(by6) || !Base64.isPad(by7)) throw new Base64DecodingException("decoding.general");
                if ((by4 & 3) != 0) {
                    throw new Base64DecodingException("decoding.general");
                }
                outputStream.write((byte)(by2 << 2 | by3 >> 4));
                outputStream.write((byte)((by3 & 0xF) << 4 | by4 >> 2 & 0xF));
            }
            return;
        } else {
            outputStream.write((byte)(by2 << 2 | by3 >> 4));
            outputStream.write((byte)((by3 & 0xF) << 4 | by4 >> 2 & 0xF));
            outputStream.write((byte)(by4 << 6 | by5));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final void decode(InputStream inputStream, OutputStream outputStream) throws Base64DecodingException, IOException {
        byte by2;
        int n;
        byte by3 = 0;
        byte by4 = 0;
        byte by5 = 0;
        byte by6 = 0;
        int n2 = 0;
        byte[] byArray = new byte[4];
        while ((n = inputStream.read()) > 0) {
            by2 = (byte)n;
            if (Base64.isWhiteSpace(by2)) continue;
            if (Base64.isPad(by2)) {
                byArray[n2++] = by2;
                if (n2 != 3) break;
                byArray[n2++] = (byte)inputStream.read();
                break;
            }
            byArray[n2++] = by2;
            if (byArray[n2++] == -1) {
                throw new Base64DecodingException("decoding.general");
            }
            if (n2 != 4) continue;
            n2 = 0;
            by3 = base64Alphabet[byArray[0]];
            by4 = base64Alphabet[byArray[1]];
            by5 = base64Alphabet[byArray[2]];
            by6 = base64Alphabet[byArray[3]];
            outputStream.write((byte)(by3 << 2 | by4 >> 4));
            outputStream.write((byte)((by4 & 0xF) << 4 | by5 >> 2 & 0xF));
            outputStream.write((byte)(by5 << 6 | by6));
        }
        by2 = byArray[0];
        byte by7 = byArray[1];
        byte by8 = byArray[2];
        byte by9 = byArray[3];
        by3 = base64Alphabet[by2];
        by4 = base64Alphabet[by7];
        by5 = base64Alphabet[by8];
        by6 = base64Alphabet[by9];
        if (by5 == -1 || by6 == -1) {
            if (Base64.isPad(by8) && Base64.isPad(by9)) {
                if ((by4 & 0xF) != 0) {
                    throw new Base64DecodingException("decoding.general");
                }
                outputStream.write((byte)(by3 << 2 | by4 >> 4));
                return;
            } else {
                if (Base64.isPad(by8) || !Base64.isPad(by9)) throw new Base64DecodingException("decoding.general");
                by5 = base64Alphabet[by8];
                if ((by5 & 3) != 0) {
                    throw new Base64DecodingException("decoding.general");
                }
                outputStream.write((byte)(by3 << 2 | by4 >> 4));
                outputStream.write((byte)((by4 & 0xF) << 4 | by5 >> 2 & 0xF));
            }
            return;
        } else {
            outputStream.write((byte)(by3 << 2 | by4 >> 4));
            outputStream.write((byte)((by4 & 0xF) << 4 | by5 >> 2 & 0xF));
            outputStream.write((byte)(by5 << 6 | by6));
        }
    }

    protected static final int removeWhiteSpace(byte[] byArray) {
        if (byArray == null) {
            return 0;
        }
        int n = 0;
        int n2 = byArray.length;
        for (int i = 0; i < n2; ++i) {
            byte by2 = byArray[i];
            if (Base64.isWhiteSpace(by2)) continue;
            byArray[n++] = by2;
        }
        return n;
    }

    static {
        int n;
        base64Alphabet = new byte[255];
        lookUpBase64Alphabet = new char[64];
        for (n = 0; n < 255; ++n) {
            Base64.base64Alphabet[n] = -1;
        }
        for (n = 90; n >= 65; --n) {
            Base64.base64Alphabet[n] = (byte)(n - 65);
        }
        for (n = 122; n >= 97; --n) {
            Base64.base64Alphabet[n] = (byte)(n - 97 + 26);
        }
        for (n = 57; n >= 48; --n) {
            Base64.base64Alphabet[n] = (byte)(n - 48 + 52);
        }
        Base64.base64Alphabet[43] = 62;
        Base64.base64Alphabet[47] = 63;
        for (n = 0; n <= 25; ++n) {
            Base64.lookUpBase64Alphabet[n] = (char)(65 + n);
        }
        n = 26;
        int n2 = 0;
        while (n <= 51) {
            Base64.lookUpBase64Alphabet[n] = (char)(97 + n2);
            ++n;
            ++n2;
        }
        n = 52;
        n2 = 0;
        while (n <= 61) {
            Base64.lookUpBase64Alphabet[n] = (char)(48 + n2);
            ++n;
            ++n2;
        }
        Base64.lookUpBase64Alphabet[62] = 43;
        Base64.lookUpBase64Alphabet[63] = 47;
    }
}

