/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.utils;

import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.utils.ElementChecker;
import org.apache.xml.security.utils.ElementProxy;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class ElementCheckerImpl
implements ElementChecker {
    public boolean isNamespaceElement(Node node4, String string2, String string3) {
        return node4 != null && string3 == node4.getNamespaceURI() && node4.getLocalName().equals(string2);
    }

    public static class EmptyChecker
    extends ElementCheckerImpl {
        public void guaranteeThatElementInCorrectSpace(ElementProxy elementProxy, Element element2) throws XMLSecurityException {
        }
    }

    public static class FullChecker
    extends ElementCheckerImpl {
        public void guaranteeThatElementInCorrectSpace(ElementProxy elementProxy, Element element2) throws XMLSecurityException {
            String string2 = elementProxy.getBaseLocalName();
            String string3 = elementProxy.getBaseNamespace();
            String string4 = element2.getLocalName();
            String string5 = element2.getNamespaceURI();
            if (!string3.equals(string5) || !string2.equals(string4)) {
                Object[] objectArray = new Object[]{string5 + ":" + string4, string3 + ":" + string2};
                throw new XMLSecurityException("xml.WrongElement", objectArray);
            }
        }
    }

    public static class InternedNsChecker
    extends ElementCheckerImpl {
        public void guaranteeThatElementInCorrectSpace(ElementProxy elementProxy, Element element2) throws XMLSecurityException {
            String string2 = elementProxy.getBaseLocalName();
            String string3 = elementProxy.getBaseNamespace();
            String string4 = element2.getLocalName();
            String string5 = element2.getNamespaceURI();
            if (string3 != string5 || !string2.equals(string4)) {
                Object[] objectArray = new Object[]{string5 + ":" + string4, string3 + ":" + string2};
                throw new XMLSecurityException("xml.WrongElement", objectArray);
            }
        }
    }
}

