/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.utils;

import java.math.BigInteger;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.security.exceptions.Base64DecodingException;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.utils.Base64;
import org.apache.xml.security.utils.ElementChecker;
import org.apache.xml.security.utils.ElementCheckerImpl;
import org.apache.xml.security.utils.HelperNodeList;
import org.apache.xml.security.utils.XMLUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public abstract class ElementProxy {
    static Log log = LogFactory.getLog(ElementProxy.class.getName());
    protected Element _constructionElement = null;
    protected String _baseURI = null;
    protected Document _doc = null;
    static ElementChecker checker = new ElementCheckerImpl.InternedNsChecker();
    static HashMap _prefixMappings = new HashMap();
    static HashMap _prefixMappingsBindings = new HashMap();

    public abstract String getBaseNamespace();

    public abstract String getBaseLocalName();

    public ElementProxy() {
    }

    public ElementProxy(Document document2) {
        if (document2 == null) {
            throw new RuntimeException("Document is null");
        }
        this._doc = document2;
        this._constructionElement = this.createElementForFamilyLocal(this._doc, this.getBaseNamespace(), this.getBaseLocalName());
    }

    protected Element createElementForFamilyLocal(Document document2, String string2, String string3) {
        Element element2 = null;
        if (string2 == null) {
            element2 = document2.createElementNS(null, string3);
        } else {
            String string4 = this.getBaseNamespace();
            String string5 = ElementProxy.getDefaultPrefix(string4);
            if (string5 == null || string5.length() == 0) {
                element2 = document2.createElementNS(string2, string3);
                element2.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", string2);
            } else {
                String string6 = null;
                String string7 = ElementProxy.getDefaultPrefixBindings(string4);
                StringBuffer stringBuffer = new StringBuffer(string5);
                stringBuffer.append(':');
                stringBuffer.append(string3);
                string6 = stringBuffer.toString();
                element2 = document2.createElementNS(string2, string6);
                element2.setAttributeNS("http://www.w3.org/2000/xmlns/", string7, string2);
            }
        }
        return element2;
    }

    public static Element createElementForFamily(Document document2, String string2, String string3) {
        Element element2 = null;
        String string4 = ElementProxy.getDefaultPrefix(string2);
        if (string2 == null) {
            element2 = document2.createElementNS(null, string3);
        } else if (string4 == null || string4.length() == 0) {
            element2 = document2.createElementNS(string2, string3);
            element2.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", string2);
        } else {
            element2 = document2.createElementNS(string2, string4 + ":" + string3);
            element2.setAttributeNS("http://www.w3.org/2000/xmlns/", ElementProxy.getDefaultPrefixBindings(string2), string2);
        }
        return element2;
    }

    public void setElement(Element element2, String string2) throws XMLSecurityException {
        if (element2 == null) {
            throw new XMLSecurityException("ElementProxy.nullElement");
        }
        if (log.isDebugEnabled()) {
            log.debug("setElement(" + element2.getTagName() + ", \"" + string2 + "\"");
        }
        this._doc = element2.getOwnerDocument();
        this._constructionElement = element2;
        this._baseURI = string2;
    }

    public ElementProxy(Element element2, String string2) throws XMLSecurityException {
        if (element2 == null) {
            throw new XMLSecurityException("ElementProxy.nullElement");
        }
        if (log.isDebugEnabled()) {
            log.debug("setElement(\"" + element2.getTagName() + "\", \"" + string2 + "\")");
        }
        this._doc = element2.getOwnerDocument();
        this._constructionElement = element2;
        this._baseURI = string2;
        this.guaranteeThatElementInCorrectSpace();
    }

    public final Element getElement() {
        return this._constructionElement;
    }

    public final NodeList getElementPlusReturns() {
        HelperNodeList helperNodeList = new HelperNodeList();
        helperNodeList.appendChild(this._doc.createTextNode("\n"));
        helperNodeList.appendChild(this.getElement());
        helperNodeList.appendChild(this._doc.createTextNode("\n"));
        return helperNodeList;
    }

    public Document getDocument() {
        return this._doc;
    }

    public String getBaseURI() {
        return this._baseURI;
    }

    void guaranteeThatElementInCorrectSpace() throws XMLSecurityException {
        checker.guaranteeThatElementInCorrectSpace(this, this._constructionElement);
    }

    public void addBigIntegerElement(BigInteger bigInteger, String string2) {
        if (bigInteger != null) {
            Element element2 = XMLUtils.createElementInSignatureSpace(this._doc, string2);
            Base64.fillElementWithBigInteger(element2, bigInteger);
            this._constructionElement.appendChild(element2);
            XMLUtils.addReturnToElement(this._constructionElement);
        }
    }

    public void addBase64Element(byte[] byArray, String string2) {
        if (byArray != null) {
            Element element2 = Base64.encodeToElement(this._doc, string2, byArray);
            this._constructionElement.appendChild(element2);
            if (!XMLUtils.ignoreLineBreaks()) {
                this._constructionElement.appendChild(this._doc.createTextNode("\n"));
            }
        }
    }

    public void addTextElement(String string2, String string3) {
        Element element2 = XMLUtils.createElementInSignatureSpace(this._doc, string3);
        Text text2 = this._doc.createTextNode(string2);
        element2.appendChild(text2);
        this._constructionElement.appendChild(element2);
        XMLUtils.addReturnToElement(this._constructionElement);
    }

    public void addBase64Text(byte[] byArray) {
        if (byArray != null) {
            Text text2 = XMLUtils.ignoreLineBreaks() ? this._doc.createTextNode(Base64.encode(byArray)) : this._doc.createTextNode("\n" + Base64.encode(byArray) + "\n");
            this._constructionElement.appendChild(text2);
        }
    }

    public void addText(String string2) {
        if (string2 != null) {
            Text text2 = this._doc.createTextNode(string2);
            this._constructionElement.appendChild(text2);
        }
    }

    public BigInteger getBigIntegerFromChildElement(String string2, String string3) throws Base64DecodingException {
        return Base64.decodeBigIntegerFromText(XMLUtils.selectNodeText(this._constructionElement.getFirstChild(), string3, string2, 0));
    }

    public byte[] getBytesFromChildElement(String string2, String string3) throws XMLSecurityException {
        Element element2 = XMLUtils.selectNode(this._constructionElement.getFirstChild(), string3, string2, 0);
        return Base64.decode(element2);
    }

    public String getTextFromChildElement(String string2, String string3) {
        Text text2 = (Text)XMLUtils.selectNode(this._constructionElement.getFirstChild(), string3, string2, 0).getFirstChild();
        return text2.getData();
    }

    public byte[] getBytesFromTextChild() throws XMLSecurityException {
        return Base64.decode(XMLUtils.getFullTextChildrenFromElement(this._constructionElement));
    }

    public String getTextFromTextChild() {
        return XMLUtils.getFullTextChildrenFromElement(this._constructionElement);
    }

    public int length(String string2, String string3) {
        int n = 0;
        for (Node node4 = this._constructionElement.getFirstChild(); node4 != null; node4 = node4.getNextSibling()) {
            if (!string3.equals(node4.getLocalName()) || string2 != node4.getNamespaceURI()) continue;
            ++n;
        }
        return n;
    }

    public void setXPathNamespaceContext(String string2, String string3) throws XMLSecurityException {
        if (string2 == null || string2.length() == 0) {
            throw new XMLSecurityException("defaultNamespaceCannotBeSetHere");
        }
        if (string2.equals("xmlns")) {
            throw new XMLSecurityException("defaultNamespaceCannotBeSetHere");
        }
        String string4 = string2.startsWith("xmlns:") ? string2 : "xmlns:" + string2;
        Attr attr = this._constructionElement.getAttributeNodeNS("http://www.w3.org/2000/xmlns/", string4);
        if (attr != null) {
            if (!attr.getNodeValue().equals(string3)) {
                Object[] objectArray = new Object[]{string4, this._constructionElement.getAttributeNS(null, string4)};
                throw new XMLSecurityException("namespacePrefixAlreadyUsedByOtherURI", objectArray);
            }
            return;
        }
        this._constructionElement.setAttributeNS("http://www.w3.org/2000/xmlns/", string4, string3);
    }

    public static void setDefaultPrefix(String string2, String string3) throws XMLSecurityException {
        Object v;
        if (_prefixMappings.containsValue(string3) && !(v = _prefixMappings.get(string2)).equals(string3)) {
            Object[] objectArray = new Object[]{string3, string2, v};
            throw new XMLSecurityException("prefix.AlreadyAssigned", objectArray);
        }
        if ("http://www.w3.org/2000/09/xmldsig#".equals(string2)) {
            XMLUtils.dsPrefix = string3;
        }
        _prefixMappings.put(string2, string3.intern());
        if (string3.length() == 0) {
            _prefixMappingsBindings.put(string2, "xmlns");
        } else {
            _prefixMappingsBindings.put(string2, ("xmlns:" + string3).intern());
        }
    }

    public static String getDefaultPrefix(String string2) {
        return (String)_prefixMappings.get(string2);
    }

    public static String getDefaultPrefixBindings(String string2) {
        return (String)_prefixMappingsBindings.get(string2);
    }
}

