/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.utils;

import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.List;
import java.util.WeakHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class IdResolver {
    private static Log log = LogFactory.getLog(IdResolver.class.getName());
    private static WeakHashMap docMap = new WeakHashMap();
    private static List names;
    private static int namesLength;

    private IdResolver() {
    }

    public static void registerElementById(Element element2, String string2) {
        Document document2 = element2.getOwnerDocument();
        WeakHashMap<String, WeakReference<Element>> weakHashMap = (WeakHashMap<String, WeakReference<Element>>)docMap.get(document2);
        if (weakHashMap == null) {
            weakHashMap = new WeakHashMap<String, WeakReference<Element>>();
            docMap.put(document2, weakHashMap);
        }
        weakHashMap.put(string2, new WeakReference<Element>(element2));
    }

    public static void registerElementById(Element element2, Attr attr) {
        IdResolver.registerElementById(element2, attr.getNodeValue());
    }

    public static Element getElementById(Document document2, String string2) {
        Element element2 = IdResolver.getElementByIdType(document2, string2);
        if (element2 != null) {
            log.debug("I could find an Element using the simple getElementByIdType method: " + element2.getTagName());
            return element2;
        }
        element2 = IdResolver.getElementByIdUsingDOM(document2, string2);
        if (element2 != null) {
            log.debug("I could find an Element using the simple getElementByIdUsingDOM method: " + element2.getTagName());
            return element2;
        }
        element2 = IdResolver.getElementBySearching(document2, string2);
        if (element2 != null) {
            IdResolver.registerElementById(element2, string2);
            return element2;
        }
        return null;
    }

    private static Element getElementByIdUsingDOM(Document document2, String string2) {
        if (log.isDebugEnabled()) {
            log.debug("getElementByIdUsingDOM() Search for ID " + string2);
        }
        return document2.getElementById(string2);
    }

    private static Element getElementByIdType(Document document2, String string2) {
        WeakReference weakReference;
        WeakHashMap weakHashMap;
        if (log.isDebugEnabled()) {
            log.debug("getElementByIdType() Search for ID " + string2);
        }
        if ((weakHashMap = (WeakHashMap)docMap.get(document2)) != null && (weakReference = (WeakReference)weakHashMap.get(string2)) != null) {
            return (Element)weakReference.get();
        }
        return null;
    }

    private static Element getElementBySearching(Node node4, String string2) {
        Element[] elementArray = new Element[namesLength + 1];
        IdResolver.getEl(node4, string2, elementArray);
        for (int i = 0; i < elementArray.length; ++i) {
            if (elementArray[i] == null) continue;
            return elementArray[i];
        }
        return null;
    }

    private static int getEl(Node node4, String string2, Element[] elementArray) {
        Node node5 = null;
        Node node6 = null;
        while (true) {
            switch (node4.getNodeType()) {
                case 9: 
                case 11: {
                    node5 = node4.getFirstChild();
                    break;
                }
                case 1: {
                    Element element2 = (Element)node4;
                    if (IdResolver.isElement(element2, string2, elementArray) == 1) {
                        return 1;
                    }
                    node5 = node4.getFirstChild();
                    if (node5 == null) {
                        if (node6 == null) break;
                        node5 = node4.getNextSibling();
                        break;
                    }
                    node6 = element2;
                }
            }
            while (node5 == null && node6 != null) {
                node5 = node6.getNextSibling();
                if ((node6 = node6.getParentNode()) instanceof Element) continue;
                node6 = null;
            }
            if (node5 == null) {
                return 1;
            }
            node4 = node5;
            node5 = node4.getNextSibling();
        }
    }

    public static int isElement(Element element2, String string2, Element[] elementArray) {
        if (!element2.hasAttributes()) {
            return 0;
        }
        NamedNodeMap namedNodeMap = element2.getAttributes();
        int n = names.indexOf(element2.getNamespaceURI());
        n = n < 0 ? namesLength : n;
        int n2 = namedNodeMap.getLength();
        for (int i = 0; i < n2; ++i) {
            Attr attr = (Attr)namedNodeMap.item(i);
            String string3 = attr.getNamespaceURI();
            int n3 = string3 == null ? n : names.indexOf(attr.getNamespaceURI());
            n3 = n3 < 0 ? namesLength : n3;
            String string4 = attr.getLocalName();
            if (string4.length() > 2) continue;
            String string5 = attr.getNodeValue();
            if (string4.charAt(0) == 'I') {
                char c2 = string4.charAt(1);
                if (c2 == 'd' && string5.equals(string2)) {
                    elementArray[n3] = element2;
                    if (n3 != 0) continue;
                    return 1;
                }
                if (c2 != 'D' || !string5.endsWith(string2)) continue;
                if (n3 != 3) {
                    n3 = namesLength;
                }
                elementArray[n3] = element2;
                continue;
            }
            if (!"id".equals(string4) || !string5.equals(string2)) continue;
            if (n3 != 2) {
                n3 = namesLength;
            }
            elementArray[n3] = element2;
        }
        if (n == 3 && (element2.getAttribute("OriginalRequestID").equals(string2) || element2.getAttribute("RequestID").equals(string2) || element2.getAttribute("ResponseID").equals(string2))) {
            elementArray[3] = element2;
        } else if (n == 4 && element2.getAttribute("AssertionID").equals(string2)) {
            elementArray[4] = element2;
        } else if (n == 5 && (element2.getAttribute("RequestID").equals(string2) || element2.getAttribute("ResponseID").equals(string2))) {
            elementArray[5] = element2;
        }
        return 0;
    }

    static {
        String[] stringArray = new String[]{"http://www.w3.org/2000/09/xmldsig#", "http://www.w3.org/2001/04/xmlenc#", "http://schemas.xmlsoap.org/soap/security/2000-12", "http://www.w3.org/2002/03/xkms#", "urn:oasis:names:tc:SAML:1.0:assertion", "urn:oasis:names:tc:SAML:1.0:protocol"};
        names = Arrays.asList(stringArray);
        namesLength = names.size();
    }
}

