/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.utils;

import java.io.IOException;
import java.io.StringReader;

public class RFC2253Parser {
    static boolean _TOXML = true;
    static int counter = 0;

    public static String rfc2253toXMLdsig(String string2) {
        _TOXML = true;
        String string3 = RFC2253Parser.normalize(string2);
        return RFC2253Parser.rfctoXML(string3);
    }

    public static String xmldsigtoRFC2253(String string2) {
        _TOXML = false;
        String string3 = RFC2253Parser.normalize(string2);
        return RFC2253Parser.xmltoRFC(string3);
    }

    public static String normalize(String string2) {
        if (string2 == null || string2.equals("")) {
            return "";
        }
        try {
            int n;
            String string3 = RFC2253Parser.semicolonToComma(string2);
            StringBuffer stringBuffer = new StringBuffer();
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            while ((n = string3.indexOf(",", n4)) >= 0) {
                if (n > 0 && string3.charAt(n - 1) != '\\' && (n3 += RFC2253Parser.countQuotes(string3, n4, n)) % 2 != 1) {
                    stringBuffer.append(RFC2253Parser.parseRDN(string3.substring(n2, n).trim()) + ",");
                    n2 = n + 1;
                    n3 = 0;
                }
                n4 = n + 1;
            }
            stringBuffer.append(RFC2253Parser.parseRDN(RFC2253Parser.trim(string3.substring(n2))));
            return stringBuffer.toString();
        }
        catch (IOException iOException) {
            return string2;
        }
    }

    static String parseRDN(String string2) throws IOException {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        while ((n = string2.indexOf("+", n4)) >= 0) {
            if (n > 0 && string2.charAt(n - 1) != '\\' && (n3 += RFC2253Parser.countQuotes(string2, n4, n)) % 2 != 1) {
                stringBuffer.append(RFC2253Parser.parseATAV(RFC2253Parser.trim(string2.substring(n2, n))) + "+");
                n2 = n + 1;
                n3 = 0;
            }
            n4 = n + 1;
        }
        stringBuffer.append(RFC2253Parser.parseATAV(RFC2253Parser.trim(string2.substring(n2))));
        return stringBuffer.toString();
    }

    static String parseATAV(String string2) throws IOException {
        int n = string2.indexOf("=");
        if (n == -1 || n > 0 && string2.charAt(n - 1) == '\\') {
            return string2;
        }
        String string3 = RFC2253Parser.normalizeAT(string2.substring(0, n));
        String string4 = null;
        string4 = string3.charAt(0) >= '0' && string3.charAt(0) <= '9' ? string2.substring(n + 1) : RFC2253Parser.normalizeV(string2.substring(n + 1));
        return string3 + "=" + string4;
    }

    static String normalizeAT(String string2) {
        String string3 = string2.toUpperCase().trim();
        if (string3.startsWith("OID")) {
            string3 = string3.substring(3);
        }
        return string3;
    }

    static String normalizeV(String string2) throws IOException {
        String string3 = RFC2253Parser.trim(string2);
        if (string3.startsWith("\"")) {
            StringBuffer stringBuffer = new StringBuffer();
            StringReader stringReader = new StringReader(string3.substring(1, string3.length() - 1));
            int n = 0;
            while ((n = stringReader.read()) > -1) {
                char c2 = (char)n;
                if (c2 == ',' || c2 == '=' || c2 == '+' || c2 == '<' || c2 == '>' || c2 == '#' || c2 == ';') {
                    stringBuffer.append('\\');
                }
                stringBuffer.append(c2);
            }
            string3 = RFC2253Parser.trim(stringBuffer.toString());
        }
        if (_TOXML) {
            if (string3.startsWith("#")) {
                string3 = '\\' + string3;
            }
        } else if (string3.startsWith("\\#")) {
            string3 = string3.substring(1);
        }
        return string3;
    }

    static String rfctoXML(String string2) {
        try {
            String string3 = RFC2253Parser.changeLess32toXML(string2);
            return RFC2253Parser.changeWStoXML(string3);
        }
        catch (Exception exception) {
            return string2;
        }
    }

    static String xmltoRFC(String string2) {
        try {
            String string3 = RFC2253Parser.changeLess32toRFC(string2);
            return RFC2253Parser.changeWStoRFC(string3);
        }
        catch (Exception exception) {
            return string2;
        }
    }

    static String changeLess32toRFC(String string2) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        StringReader stringReader = new StringReader(string2);
        int n = 0;
        while ((n = stringReader.read()) > -1) {
            char c2 = (char)n;
            if (c2 == '\\') {
                stringBuffer.append(c2);
                char c3 = (char)stringReader.read();
                char c4 = (char)stringReader.read();
                if ((c3 >= '0' && c3 <= '9' || c3 >= 'A' && c3 <= 'F' || c3 >= 'a' && c3 <= 'f') && (c4 >= '0' && c4 <= '9' || c4 >= 'A' && c4 <= 'F' || c4 >= 'a' && c4 <= 'f')) {
                    char c5 = (char)Byte.parseByte("" + c3 + c4, 16);
                    stringBuffer.append(c5);
                    continue;
                }
                stringBuffer.append(c3);
                stringBuffer.append(c4);
                continue;
            }
            stringBuffer.append(c2);
        }
        return stringBuffer.toString();
    }

    static String changeLess32toXML(String string2) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        StringReader stringReader = new StringReader(string2);
        int n = 0;
        while ((n = stringReader.read()) > -1) {
            if (n < 32) {
                stringBuffer.append('\\');
                stringBuffer.append(Integer.toHexString(n));
                continue;
            }
            stringBuffer.append((char)n);
        }
        return stringBuffer.toString();
    }

    static String changeWStoXML(String string2) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        StringReader stringReader = new StringReader(string2);
        int n = 0;
        while ((n = stringReader.read()) > -1) {
            char c2 = (char)n;
            if (c2 == '\\') {
                char c3 = (char)stringReader.read();
                if (c3 == ' ') {
                    stringBuffer.append('\\');
                    String string3 = "20";
                    stringBuffer.append(string3);
                    continue;
                }
                stringBuffer.append('\\');
                stringBuffer.append(c3);
                continue;
            }
            stringBuffer.append(c2);
        }
        return stringBuffer.toString();
    }

    static String changeWStoRFC(String string2) {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        int n3 = 0;
        while ((n = string2.indexOf("\\20", n3)) >= 0) {
            stringBuffer.append(RFC2253Parser.trim(string2.substring(n2, n)) + "\\ ");
            n2 = n + 3;
            n3 = n + 3;
        }
        stringBuffer.append(string2.substring(n2));
        return stringBuffer.toString();
    }

    static String semicolonToComma(String string2) {
        return RFC2253Parser.removeWSandReplace(string2, ";", ",");
    }

    static String removeWhiteSpace(String string2, String string3) {
        return RFC2253Parser.removeWSandReplace(string2, string3, string3);
    }

    static String removeWSandReplace(String string2, String string3, String string4) {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        while ((n = string2.indexOf(string3, n4)) >= 0) {
            if (n > 0 && string2.charAt(n - 1) != '\\' && (n3 += RFC2253Parser.countQuotes(string2, n4, n)) % 2 != 1) {
                stringBuffer.append(RFC2253Parser.trim(string2.substring(n2, n)) + string4);
                n2 = n + 1;
                n3 = 0;
            }
            n4 = n + 1;
        }
        stringBuffer.append(RFC2253Parser.trim(string2.substring(n2)));
        return stringBuffer.toString();
    }

    private static int countQuotes(String string2, int n, int n2) {
        int n3 = 0;
        for (int i = n; i < n2; ++i) {
            if (string2.charAt(i) != '\"') continue;
            ++n3;
        }
        return n3;
    }

    static String trim(String string2) {
        String string3 = string2.trim();
        int n = string2.indexOf(string3) + string3.length();
        if (string2.length() > n && string3.endsWith("\\") && !string3.endsWith("\\\\") && string2.charAt(n) == ' ') {
            string3 = string3 + " ";
        }
        return string3;
    }

    public static void main(String[] stringArray) throws Exception {
        RFC2253Parser.testToXML("CN=\"Steve, Kille\",  O=Isode Limited, C=GB");
        RFC2253Parser.testToXML("CN=Steve Kille    ,   O=Isode Limited,C=GB");
        RFC2253Parser.testToXML("\\ OU=Sales+CN=J. Smith,O=Widget Inc.,C=US\\ \\ ");
        RFC2253Parser.testToXML("CN=L. Eagle,O=Sue\\, Grabbit and Runn,C=GB");
        RFC2253Parser.testToXML("CN=Before\\0DAfter,O=Test,C=GB");
        RFC2253Parser.testToXML("CN=\"L. Eagle,O=Sue, = + < > # ;Grabbit and Runn\",C=GB");
        RFC2253Parser.testToXML("1.3.6.1.4.1.1466.0=#04024869,O=Test,C=GB");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('L');
        stringBuffer.append('u');
        stringBuffer.append('\uc48d');
        stringBuffer.append('i');
        stringBuffer.append('\uc487');
        String string2 = "SN=" + stringBuffer.toString();
        RFC2253Parser.testToXML(string2);
        RFC2253Parser.testToRFC("CN=\"Steve, Kille\",  O=Isode Limited, C=GB");
        RFC2253Parser.testToRFC("CN=Steve Kille    ,   O=Isode Limited,C=GB");
        RFC2253Parser.testToRFC("\\20OU=Sales+CN=J. Smith,O=Widget Inc.,C=US\\20\\20 ");
        RFC2253Parser.testToRFC("CN=L. Eagle,O=Sue\\, Grabbit and Runn,C=GB");
        RFC2253Parser.testToRFC("CN=Before\\12After,O=Test,C=GB");
        RFC2253Parser.testToRFC("CN=\"L. Eagle,O=Sue, = + < > # ;Grabbit and Runn\",C=GB");
        RFC2253Parser.testToRFC("1.3.6.1.4.1.1466.0=\\#04024869,O=Test,C=GB");
        stringBuffer = new StringBuffer();
        stringBuffer.append('L');
        stringBuffer.append('u');
        stringBuffer.append('\uc48d');
        stringBuffer.append('i');
        stringBuffer.append('\uc487');
        string2 = "SN=" + stringBuffer.toString();
        RFC2253Parser.testToRFC(string2);
    }

    static void testToXML(String string2) {
        System.out.println("start " + counter++ + ": " + string2);
        System.out.println("         " + RFC2253Parser.rfc2253toXMLdsig(string2));
        System.out.println("");
    }

    static void testToRFC(String string2) {
        System.out.println("start " + counter++ + ": " + string2);
        System.out.println("         " + RFC2253Parser.xmldsigtoRFC2253(string2));
        System.out.println("");
    }
}

