/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.utils;

import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.xml.security.c14n.CanonicalizationException;
import org.apache.xml.security.c14n.Canonicalizer;
import org.apache.xml.security.c14n.InvalidCanonicalizerException;
import org.apache.xml.security.utils.ElementProxy;
import org.apache.xml.security.utils.HelperNodeList;
import org.apache.xml.security.utils.I18n;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class XMLUtils {
    private static boolean ignoreLineBreaks = false;
    static String dsPrefix;
    static Map namePrefixes;

    private XMLUtils() {
    }

    public static Element getNextElement(Node node4) {
        while (node4 != null && node4.getNodeType() != 1) {
            node4 = node4.getNextSibling();
        }
        return (Element)node4;
    }

    public static void getSet(Node node4, Set set2, Node node5, boolean bl) {
        if (node5 != null && XMLUtils.isDescendantOrSelf(node5, node4)) {
            return;
        }
        XMLUtils.getSetRec(node4, set2, node5, bl);
    }

    static final void getSetRec(Node node4, Set set2, Node node5, boolean bl) {
        if (node4 == node5) {
            return;
        }
        switch (node4.getNodeType()) {
            case 1: {
                Object object;
                set2.add(node4);
                Element element2 = (Element)node4;
                if (element2.hasAttributes()) {
                    object = ((Element)node4).getAttributes();
                    for (int i = 0; i < object.getLength(); ++i) {
                        set2.add(object.item(i));
                    }
                }
            }
            case 9: {
                Object object;
                for (object = node4.getFirstChild(); object != null; object = object.getNextSibling()) {
                    if (object.getNodeType() == 3) {
                        set2.add(object);
                        while (object != null && object.getNodeType() == 3) {
                            object = object.getNextSibling();
                        }
                        if (object == null) {
                            return;
                        }
                    }
                    XMLUtils.getSetRec((Node)object, set2, node5, bl);
                }
                return;
            }
            case 8: {
                if (bl) {
                    set2.add(node4);
                }
                return;
            }
            case 10: {
                return;
            }
        }
        set2.add(node4);
    }

    public static void outputDOM(Node node4, OutputStream outputStream) {
        XMLUtils.outputDOM(node4, outputStream, false);
    }

    public static void outputDOM(Node node4, OutputStream outputStream, boolean bl) {
        try {
            if (bl) {
                outputStream.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n".getBytes());
            }
            outputStream.write(Canonicalizer.getInstance("http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments").canonicalizeSubtree(node4));
        }
        catch (IOException iOException) {
        }
        catch (InvalidCanonicalizerException invalidCanonicalizerException) {
            invalidCanonicalizerException.printStackTrace();
        }
        catch (CanonicalizationException canonicalizationException) {
            canonicalizationException.printStackTrace();
        }
    }

    public static void outputDOMc14nWithComments(Node node4, OutputStream outputStream) {
        try {
            outputStream.write(Canonicalizer.getInstance("http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments").canonicalizeSubtree(node4));
        }
        catch (IOException iOException) {
        }
        catch (InvalidCanonicalizerException invalidCanonicalizerException) {
        }
        catch (CanonicalizationException canonicalizationException) {
            // empty catch block
        }
    }

    public static String getFullTextChildrenFromElement(Element element2) {
        StringBuffer stringBuffer = new StringBuffer();
        NodeList nodeList = element2.getChildNodes();
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Node node4 = nodeList.item(i);
            if (node4.getNodeType() != 3) continue;
            stringBuffer.append(((Text)node4).getData());
        }
        return stringBuffer.toString();
    }

    public static Element createElementInSignatureSpace(Document document2, String string2) {
        if (document2 == null) {
            throw new RuntimeException("Document is null");
        }
        if (dsPrefix == null || dsPrefix.length() == 0) {
            return document2.createElementNS("http://www.w3.org/2000/09/xmldsig#", string2);
        }
        String string3 = (String)namePrefixes.get(string2);
        if (string3 == null) {
            StringBuffer stringBuffer = new StringBuffer(dsPrefix);
            stringBuffer.append(':');
            stringBuffer.append(string2);
            string3 = stringBuffer.toString();
            namePrefixes.put(string2, string3);
        }
        return document2.createElementNS("http://www.w3.org/2000/09/xmldsig#", string3);
    }

    public static boolean elementIsInSignatureSpace(Element element2, String string2) {
        return ElementProxy.checker.isNamespaceElement(element2, string2, "http://www.w3.org/2000/09/xmldsig#");
    }

    public static boolean elementIsInEncryptionSpace(Element element2, String string2) {
        return ElementProxy.checker.isNamespaceElement(element2, string2, "http://www.w3.org/2001/04/xmlenc#");
    }

    public static Document getOwnerDocument(Node node4) {
        if (node4.getNodeType() == 9) {
            return (Document)node4;
        }
        try {
            return node4.getOwnerDocument();
        }
        catch (NullPointerException nullPointerException) {
            throw new NullPointerException(I18n.translate("endorsed.jdk1.4.0") + " Original message was \"" + nullPointerException.getMessage() + "\"");
        }
    }

    public static Document getOwnerDocument(Set set2) {
        NullPointerException nullPointerException = null;
        Iterator iterator2 = set2.iterator();
        while (iterator2.hasNext()) {
            Node node4 = (Node)iterator2.next();
            short s2 = node4.getNodeType();
            if (s2 == 9) {
                return (Document)node4;
            }
            try {
                if (s2 == 2) {
                    return ((Attr)node4).getOwnerElement().getOwnerDocument();
                }
                return node4.getOwnerDocument();
            }
            catch (NullPointerException nullPointerException2) {
                nullPointerException = nullPointerException2;
            }
        }
        throw new NullPointerException(I18n.translate("endorsed.jdk1.4.0") + " Original message was \"" + (nullPointerException == null ? "" : nullPointerException.getMessage()) + "\"");
    }

    public static void addReturnToElement(Element element2) {
        if (!ignoreLineBreaks) {
            Document document2 = element2.getOwnerDocument();
            element2.appendChild(document2.createTextNode("\n"));
        }
    }

    public static void addReturnToElement(Document document2, HelperNodeList helperNodeList) {
        if (!ignoreLineBreaks) {
            helperNodeList.appendChild(document2.createTextNode("\n"));
        }
    }

    public static void addReturnBeforeChild(Element element2, Node node4) {
        if (!ignoreLineBreaks) {
            Document document2 = element2.getOwnerDocument();
            element2.insertBefore(document2.createTextNode("\n"), node4);
        }
    }

    public static Set convertNodelistToSet(NodeList nodeList) {
        if (nodeList == null) {
            return new HashSet();
        }
        int n = nodeList.getLength();
        HashSet<Node> hashSet = new HashSet<Node>(n);
        for (int i = 0; i < n; ++i) {
            hashSet.add(nodeList.item(i));
        }
        return hashSet;
    }

    public static void circumventBug2650(Document document2) {
        Element element2 = document2.getDocumentElement();
        Attr attr = element2.getAttributeNodeNS("http://www.w3.org/2000/xmlns/", "xmlns");
        if (attr == null) {
            element2.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "");
        }
        XMLUtils.circumventBug2650internal(document2);
    }

    private static void circumventBug2650internal(Node node4) {
        Node node5 = null;
        Node node6 = null;
        while (true) {
            switch (node4.getNodeType()) {
                case 1: {
                    Element element2 = (Element)node4;
                    if (!element2.hasChildNodes()) break;
                    if (element2.hasAttributes()) {
                        NamedNodeMap namedNodeMap = element2.getAttributes();
                        int n = namedNodeMap.getLength();
                        for (Node node7 = element2.getFirstChild(); node7 != null; node7 = node7.getNextSibling()) {
                            if (node7.getNodeType() != 1) continue;
                            Element element3 = (Element)node7;
                            for (int i = 0; i < n; ++i) {
                                Attr attr = (Attr)namedNodeMap.item(i);
                                if ("http://www.w3.org/2000/xmlns/" != attr.getNamespaceURI() || element3.hasAttributeNS("http://www.w3.org/2000/xmlns/", attr.getLocalName())) continue;
                                element3.setAttributeNS("http://www.w3.org/2000/xmlns/", attr.getName(), attr.getNodeValue());
                            }
                        }
                    }
                }
                case 5: 
                case 9: {
                    node5 = node4;
                    node6 = node4.getFirstChild();
                }
            }
            while (node6 == null && node5 != null) {
                node6 = node5.getNextSibling();
                node5 = node5.getParentNode();
            }
            if (node6 == null) {
                return;
            }
            node4 = node6;
            node6 = node4.getNextSibling();
        }
    }

    public static Element selectDsNode(Node node4, String string2, int n) {
        while (node4 != null) {
            if (ElementProxy.checker.isNamespaceElement(node4, string2, "http://www.w3.org/2000/09/xmldsig#")) {
                if (n == 0) {
                    return (Element)node4;
                }
                --n;
            }
            node4 = node4.getNextSibling();
        }
        return null;
    }

    public static Element selectXencNode(Node node4, String string2, int n) {
        while (node4 != null) {
            if (ElementProxy.checker.isNamespaceElement(node4, string2, "http://www.w3.org/2001/04/xmlenc#")) {
                if (n == 0) {
                    return (Element)node4;
                }
                --n;
            }
            node4 = node4.getNextSibling();
        }
        return null;
    }

    public static Text selectDsNodeText(Node node4, String string2, int n) {
        Node node5 = XMLUtils.selectDsNode(node4, string2, n);
        if (node5 == null) {
            return null;
        }
        for (node5 = node5.getFirstChild(); node5 != null && node5.getNodeType() != 3; node5 = node5.getNextSibling()) {
        }
        return (Text)node5;
    }

    public static Text selectNodeText(Node node4, String string2, String string3, int n) {
        Node node5 = XMLUtils.selectNode(node4, string2, string3, n);
        if (node5 == null) {
            return null;
        }
        for (node5 = node5.getFirstChild(); node5 != null && node5.getNodeType() != 3; node5 = node5.getNextSibling()) {
        }
        return (Text)node5;
    }

    public static Element selectNode(Node node4, String string2, String string3, int n) {
        while (node4 != null) {
            if (ElementProxy.checker.isNamespaceElement(node4, string3, string2)) {
                if (n == 0) {
                    return (Element)node4;
                }
                --n;
            }
            node4 = node4.getNextSibling();
        }
        return null;
    }

    public static Element[] selectDsNodes(Node node4, String string2) {
        return XMLUtils.selectNodes(node4, "http://www.w3.org/2000/09/xmldsig#", string2);
    }

    public static Element[] selectNodes(Node node4, String string2, String string3) {
        int n = 20;
        Element[] elementArray = new Element[n];
        int n2 = 0;
        while (node4 != null) {
            if (ElementProxy.checker.isNamespaceElement(node4, string3, string2)) {
                elementArray[n2++] = (Element)node4;
                if (n <= n2) {
                    int n3 = n << 2;
                    Element[] elementArray2 = new Element[n3];
                    System.arraycopy(elementArray, 0, elementArray2, 0, n);
                    elementArray = elementArray2;
                    n = n3;
                }
            }
            node4 = node4.getNextSibling();
        }
        Element[] elementArray3 = new Element[n2];
        System.arraycopy(elementArray, 0, elementArray3, 0, n2);
        return elementArray3;
    }

    public static Set excludeNodeFromSet(Node node4, Set set2) {
        HashSet<Node> hashSet = new HashSet<Node>();
        Iterator iterator2 = set2.iterator();
        while (iterator2.hasNext()) {
            Node node5 = (Node)iterator2.next();
            if (XMLUtils.isDescendantOrSelf(node4, node5)) continue;
            hashSet.add(node5);
        }
        return hashSet;
    }

    public static boolean isDescendantOrSelf(Node node4, Node node5) {
        if (node4 == node5) {
            return true;
        }
        Node node6 = node5;
        while (node6 != null) {
            if (node6 == node4) {
                return true;
            }
            if (node6.getNodeType() == 2) {
                node6 = ((Attr)node6).getOwnerElement();
                continue;
            }
            node6 = node6.getParentNode();
        }
        return false;
    }

    public static boolean ignoreLineBreaks() {
        return ignoreLineBreaks;
    }

    static {
        try {
            ignoreLineBreaks = Boolean.getBoolean("org.apache.xml.security.ignoreLineBreaks");
        }
        catch (Exception exception) {
            // empty catch block
        }
        dsPrefix = null;
        namePrefixes = new HashMap();
    }
}

