/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.utils.resolver;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.security.signature.XMLSignatureInput;
import org.apache.xml.security.utils.resolver.ResourceResolverException;
import org.apache.xml.security.utils.resolver.ResourceResolverSpi;
import org.w3c.dom.Attr;

public class ResourceResolver {
    static Log log = LogFactory.getLog(ResourceResolver.class.getName());
    static boolean _alreadyInitialized = false;
    static List _resolverVector = null;
    static boolean allThreadSafeInList = true;
    protected ResourceResolverSpi _resolverSpi = null;

    private ResourceResolver(String string2) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        this._resolverSpi = (ResourceResolverSpi)Class.forName(string2).newInstance();
    }

    public ResourceResolver(ResourceResolverSpi resourceResolverSpi) {
        this._resolverSpi = resourceResolverSpi;
    }

    public static final ResourceResolver getInstance(Attr attr, String string2) throws ResourceResolverException {
        int n = _resolverVector.size();
        for (int i = 0; i < n; ++i) {
            ResourceResolver resourceResolver = (ResourceResolver)_resolverVector.get(i);
            ResourceResolver resourceResolver2 = null;
            try {
                resourceResolver2 = allThreadSafeInList || resourceResolver._resolverSpi.engineIsThreadSafe() ? resourceResolver : new ResourceResolver((ResourceResolverSpi)resourceResolver._resolverSpi.getClass().newInstance());
            }
            catch (InstantiationException instantiationException) {
                throw new ResourceResolverException("", instantiationException, attr, string2);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new ResourceResolverException("", illegalAccessException, attr, string2);
            }
            if (log.isDebugEnabled()) {
                log.debug("check resolvability by class " + resourceResolver._resolverSpi.getClass().getName());
            }
            if (resourceResolver == null || !resourceResolver2.canResolve(attr, string2)) continue;
            if (i != 0) {
                List list2 = (List)((ArrayList)_resolverVector).clone();
                list2.remove(i);
                list2.add(0, resourceResolver);
                _resolverVector = list2;
            }
            return resourceResolver2;
        }
        Object[] objectArray = new Object[]{attr != null ? attr.getNodeValue() : "null", string2};
        throw new ResourceResolverException("utils.resolver.noClass", objectArray, attr, string2);
    }

    public static final ResourceResolver getInstance(Attr attr, String string2, List list2) throws ResourceResolverException {
        if (log.isDebugEnabled()) {
            log.debug("I was asked to create a ResourceResolver and got " + (list2 == null ? 0 : list2.size()));
            log.debug(" extra resolvers to my existing " + _resolverVector.size() + " system-wide resolvers");
        }
        int n = 0;
        if (list2 != null && (n = list2.size()) > 0) {
            for (int i = 0; i < n; ++i) {
                ResourceResolver resourceResolver = (ResourceResolver)list2.get(i);
                if (resourceResolver == null) continue;
                String string3 = resourceResolver._resolverSpi.getClass().getName();
                if (log.isDebugEnabled()) {
                    log.debug("check resolvability by class " + string3);
                }
                if (!resourceResolver.canResolve(attr, string2)) continue;
                return resourceResolver;
            }
        }
        return ResourceResolver.getInstance(attr, string2);
    }

    public static void init() {
        if (!_alreadyInitialized) {
            _resolverVector = new ArrayList(10);
            _alreadyInitialized = true;
        }
    }

    public static void register(String string2) {
        ResourceResolver.register(string2, false);
    }

    public static void registerAtStart(String string2) {
        ResourceResolver.register(string2, true);
    }

    private static void register(String string2, boolean bl) {
        try {
            ResourceResolver resourceResolver = new ResourceResolver(string2);
            if (bl) {
                _resolverVector.add(0, resourceResolver);
                log.debug("registered resolver");
            } else {
                _resolverVector.add(resourceResolver);
            }
            if (!resourceResolver._resolverSpi.engineIsThreadSafe()) {
                allThreadSafeInList = false;
            }
        }
        catch (Exception exception) {
            log.warn("Error loading resolver " + string2 + " disabling it");
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            log.warn("Error loading resolver " + string2 + " disabling it");
        }
    }

    public static XMLSignatureInput resolveStatic(Attr attr, String string2) throws ResourceResolverException {
        ResourceResolver resourceResolver = ResourceResolver.getInstance(attr, string2);
        return resourceResolver.resolve(attr, string2);
    }

    public XMLSignatureInput resolve(Attr attr, String string2) throws ResourceResolverException {
        return this._resolverSpi.engineResolve(attr, string2);
    }

    public void setProperty(String string2, String string3) {
        this._resolverSpi.engineSetProperty(string2, string3);
    }

    public String getProperty(String string2) {
        return this._resolverSpi.engineGetProperty(string2);
    }

    public void addProperties(Map map3) {
        this._resolverSpi.engineAddProperies(map3);
    }

    public String[] getPropertyKeys() {
        return this._resolverSpi.engineGetPropertyKeys();
    }

    public boolean understandsProperty(String string2) {
        return this._resolverSpi.understandsProperty(string2);
    }

    private boolean canResolve(Attr attr, String string2) {
        return this._resolverSpi.engineCanResolve(attr, string2);
    }
}

