/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.utils.resolver.implementations;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.security.signature.XMLSignatureInput;
import org.apache.xml.security.utils.IdResolver;
import org.apache.xml.security.utils.resolver.ResourceResolverException;
import org.apache.xml.security.utils.resolver.ResourceResolverSpi;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class ResolverFragment
extends ResourceResolverSpi {
    static Log log = LogFactory.getLog(ResolverFragment.class.getName());

    public boolean engineIsThreadSafe() {
        return true;
    }

    public XMLSignatureInput engineResolve(Attr attr, String string2) throws ResourceResolverException {
        Object object;
        String string3 = attr.getNodeValue();
        Document document2 = attr.getOwnerElement().getOwnerDocument();
        Node node4 = null;
        if (string3.equals("")) {
            log.debug("ResolverFragment with empty URI (means complete document)");
            node4 = document2;
        } else {
            object = string3.substring(1);
            node4 = IdResolver.getElementById(document2, (String)object);
            if (node4 == null) {
                Object[] objectArray = new Object[]{object};
                throw new ResourceResolverException("signature.Verification.MissingID", objectArray, attr, string2);
            }
            if (log.isDebugEnabled()) {
                log.debug("Try to catch an Element with ID " + (String)object + " and Element was " + node4);
            }
        }
        object = new XMLSignatureInput(node4);
        ((XMLSignatureInput)object).setExcludeComments(true);
        ((XMLSignatureInput)object).setMIMEType("text/xml");
        ((XMLSignatureInput)object).setSourceURI(string2 != null ? string2.concat(attr.getNodeValue()) : attr.getNodeValue());
        return object;
    }

    public boolean engineCanResolve(Attr attr, String string2) {
        if (attr == null) {
            log.debug("Quick fail for null uri");
            return false;
        }
        String string3 = attr.getNodeValue();
        if (string3.equals("") || string3.charAt(0) == '#' && (string3.charAt(1) != 'x' || !string3.startsWith("#xpointer("))) {
            if (log.isDebugEnabled()) {
                log.debug("State I can resolve reference: \"" + string3 + "\"");
            }
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug("Do not seem to be able to resolve reference: \"" + string3 + "\"");
        }
        return false;
    }
}

