/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.utils.resolver.implementations;

import java.io.FileInputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.security.signature.XMLSignatureInput;
import org.apache.xml.security.utils.resolver.ResourceResolverException;
import org.apache.xml.security.utils.resolver.ResourceResolverSpi;
import org.apache.xml.utils.URI;
import org.w3c.dom.Attr;

public class ResolverLocalFilesystem
extends ResourceResolverSpi {
    static Log log = LogFactory.getLog(ResolverLocalFilesystem.class.getName());
    private static int FILE_URI_LENGTH = "file:/".length();

    public boolean engineIsThreadSafe() {
        return true;
    }

    public XMLSignatureInput engineResolve(Attr attr, String string2) throws ResourceResolverException {
        try {
            URI uRI = ResolverLocalFilesystem.getNewURI(attr.getNodeValue(), string2);
            URI uRI2 = new URI(uRI);
            uRI2.setFragment(null);
            String string3 = ResolverLocalFilesystem.translateUriToFilename(uRI2.toString());
            FileInputStream fileInputStream = new FileInputStream(string3);
            XMLSignatureInput xMLSignatureInput = new XMLSignatureInput(fileInputStream);
            xMLSignatureInput.setSourceURI(uRI.toString());
            return xMLSignatureInput;
        }
        catch (Exception exception) {
            throw new ResourceResolverException("generic.EmptyMessage", exception, attr, string2);
        }
    }

    private static String translateUriToFilename(String string2) {
        String string3 = string2.substring(FILE_URI_LENGTH);
        if (string3.indexOf("%20") > -1) {
            int n = 0;
            int n2 = 0;
            StringBuffer stringBuffer = new StringBuffer(string3.length());
            do {
                if ((n2 = string3.indexOf("%20", n)) == -1) {
                    stringBuffer.append(string3.substring(n));
                    continue;
                }
                stringBuffer.append(string3.substring(n, n2));
                stringBuffer.append(' ');
                n = n2 + 3;
            } while (n2 != -1);
            string3 = stringBuffer.toString();
        }
        if (string3.charAt(1) == ':') {
            return string3;
        }
        return "/" + string3;
    }

    public boolean engineCanResolve(Attr attr, String string2) {
        if (attr == null) {
            return false;
        }
        String string3 = attr.getNodeValue();
        if (string3.equals("") || string3.charAt(0) == '#' || string3.startsWith("http:")) {
            return false;
        }
        try {
            if (log.isDebugEnabled()) {
                log.debug("I was asked whether I can resolve " + string3);
            }
            if (string3.startsWith("file:") || string2.startsWith("file:")) {
                if (log.isDebugEnabled()) {
                    log.debug("I state that I can resolve " + string3);
                }
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        log.debug("But I can't");
        return false;
    }

    private static URI getNewURI(String string2, String string3) throws URI.MalformedURIException {
        if (string3 == null || "".equals(string3)) {
            return new URI(string2);
        }
        return new URI(new URI(string3), string2);
    }
}

