/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.utils.resolver.implementations;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.security.signature.XMLSignatureInput;
import org.apache.xml.security.utils.IdResolver;
import org.apache.xml.security.utils.resolver.ResourceResolverException;
import org.apache.xml.security.utils.resolver.ResourceResolverSpi;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class ResolverXPointer
extends ResourceResolverSpi {
    static Log log = LogFactory.getLog(ResolverXPointer.class.getName());
    private static final String XP = "#xpointer(id(";
    private static final int XP_LENGTH = "#xpointer(id(".length();

    public boolean engineIsThreadSafe() {
        return true;
    }

    public XMLSignatureInput engineResolve(Attr attr, String string2) throws ResourceResolverException {
        Object object;
        Node node4 = null;
        Document document2 = attr.getOwnerElement().getOwnerDocument();
        String string3 = attr.getNodeValue();
        if (ResolverXPointer.isXPointerSlash(string3)) {
            node4 = document2;
        } else if (ResolverXPointer.isXPointerId(string3) && (node4 = IdResolver.getElementById(document2, (String)(object = ResolverXPointer.getXPointerId(string3)))) == null) {
            Object[] objectArray = new Object[]{object};
            throw new ResourceResolverException("signature.Verification.MissingID", objectArray, attr, string2);
        }
        object = new XMLSignatureInput(node4);
        ((XMLSignatureInput)object).setMIMEType("text/xml");
        if (string2 != null && string2.length() > 0) {
            ((XMLSignatureInput)object).setSourceURI(string2.concat(attr.getNodeValue()));
        } else {
            ((XMLSignatureInput)object).setSourceURI(attr.getNodeValue());
        }
        return object;
    }

    public boolean engineCanResolve(Attr attr, String string2) {
        if (attr == null) {
            return false;
        }
        String string3 = attr.getNodeValue();
        return ResolverXPointer.isXPointerSlash(string3) || ResolverXPointer.isXPointerId(string3);
    }

    private static boolean isXPointerSlash(String string2) {
        return string2.equals("#xpointer(/)");
    }

    private static boolean isXPointerId(String string2) {
        if (string2.startsWith(XP) && string2.endsWith("))")) {
            String string3 = string2.substring(XP_LENGTH, string2.length() - 2);
            int n = string3.length() - 1;
            if (string3.charAt(0) == '\"' && string3.charAt(n) == '\"' || string3.charAt(0) == '\'' && string3.charAt(n) == '\'') {
                if (log.isDebugEnabled()) {
                    log.debug("Id=" + string3.substring(1, n));
                }
                return true;
            }
        }
        return false;
    }

    private static String getXPointerId(String string2) {
        if (string2.startsWith(XP) && string2.endsWith("))")) {
            String string3 = string2.substring(XP_LENGTH, string2.length() - 2);
            int n = string3.length() - 1;
            if (string3.charAt(0) == '\"' && string3.charAt(n) == '\"' || string3.charAt(0) == '\'' && string3.charAt(n) == '\'') {
                return string3.substring(1, n);
            }
        }
        return null;
    }
}

