/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jce;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CRL;
import java.security.cert.CRLException;
import java.security.cert.Certificate;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DEREncodableVector;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DEROutputStream;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.pkcs.ContentInfo;
import org.bouncycastle.asn1.pkcs.IssuerAndSerialNumber;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.SignedData;
import org.bouncycastle.asn1.pkcs.SignerInfo;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.CertificateList;
import org.bouncycastle.asn1.x509.X509CertificateStructure;
import org.bouncycastle.asn1.x509.X509Name;
import org.bouncycastle.jce.X509Principal;
import org.bouncycastle.jce.provider.X509CRLObject;
import org.bouncycastle.jce.provider.X509CertificateObject;

public class PKCS7SignedData
implements PKCSObjectIdentifiers {
    private int version;
    private int signerversion;
    private Set digestalgos;
    private Collection certs;
    private Collection crls;
    private X509Certificate signCert;
    private byte[] digest;
    private String digestAlgorithm;
    private String digestEncryptionAlgorithm;
    private Signature sig;
    private transient PrivateKey privKey;
    private final String ID_PKCS7_DATA = "1.2.840.113549.1.7.1";
    private final String ID_PKCS7_SIGNED_DATA = "1.2.840.113549.1.7.2";
    private final String ID_MD5 = "1.2.840.113549.2.5";
    private final String ID_MD2 = "1.2.840.113549.2.2";
    private final String ID_SHA1 = "1.3.14.3.2.26";
    private final String ID_RSA = "1.2.840.113549.1.1.1";
    private final String ID_DSA = "1.2.840.10040.4.1";

    public PKCS7SignedData(byte[] byArray) throws SecurityException, CRLException, InvalidKeyException, NoSuchProviderException, NoSuchAlgorithmException {
        this(byArray, "BC");
    }

    public PKCS7SignedData(byte[] byArray, String string2) throws SecurityException, CRLException, InvalidKeyException, NoSuchProviderException, NoSuchAlgorithmException {
        ASN1Encodable aSN1Encodable;
        ASN1Object aSN1Object;
        Enumeration enumeration;
        DERObject dERObject;
        ASN1InputStream aSN1InputStream = new ASN1InputStream(new ByteArrayInputStream(byArray));
        try {
            dERObject = aSN1InputStream.readObject();
        }
        catch (IOException iOException) {
            throw new SecurityException("can't decode PKCS7SignedData object");
        }
        if (!(dERObject instanceof ASN1Sequence)) {
            throw new SecurityException("Not a valid PKCS#7 object - not a sequence");
        }
        ContentInfo contentInfo = ContentInfo.getInstance(dERObject);
        if (!contentInfo.getContentType().equals(signedData)) {
            throw new SecurityException("Not a valid PKCS#7 signed-data object - wrong header " + contentInfo.getContentType().getId());
        }
        SignedData signedData = SignedData.getInstance(contentInfo.getContent());
        this.certs = new ArrayList();
        if (signedData.getCertificates() != null) {
            enumeration = ASN1Set.getInstance(signedData.getCertificates()).getObjects();
            while (enumeration.hasMoreElements()) {
                try {
                    this.certs.add(new X509CertificateObject(X509CertificateStructure.getInstance(enumeration.nextElement())));
                }
                catch (CertificateParsingException certificateParsingException) {
                    throw new SecurityException(certificateParsingException.toString());
                }
            }
        }
        this.crls = new ArrayList();
        if (signedData.getCRLs() != null) {
            enumeration = ASN1Set.getInstance(signedData.getCRLs()).getObjects();
            while (enumeration.hasMoreElements()) {
                this.crls.add(new X509CRLObject(CertificateList.getInstance(enumeration.nextElement())));
            }
        }
        this.version = signedData.getVersion().getValue().intValue();
        this.digestalgos = new HashSet();
        enumeration = signedData.getDigestAlgorithms().getObjects();
        while (enumeration.hasMoreElements()) {
            aSN1Object = (ASN1Sequence)enumeration.nextElement();
            aSN1Encodable = (DERObjectIdentifier)((ASN1Sequence)aSN1Object).getObjectAt(0);
            this.digestalgos.add(((DERObjectIdentifier)aSN1Encodable).getId());
        }
        aSN1Object = signedData.getSignerInfos();
        if (((ASN1Set)aSN1Object).size() != 1) {
            throw new SecurityException("This PKCS#7 object has multiple SignerInfos - only one is supported at this time");
        }
        aSN1Encodable = SignerInfo.getInstance(((ASN1Set)aSN1Object).getObjectAt(0));
        this.signerversion = ((SignerInfo)aSN1Encodable).getVersion().getValue().intValue();
        IssuerAndSerialNumber issuerAndSerialNumber = ((SignerInfo)aSN1Encodable).getIssuerAndSerialNumber();
        BigInteger bigInteger = issuerAndSerialNumber.getCertificateSerialNumber().getValue();
        X509Principal x509Principal = new X509Principal(issuerAndSerialNumber.getName());
        for (X509Certificate x509Certificate : this.certs) {
            if (!bigInteger.equals(x509Certificate.getSerialNumber()) || !x509Principal.equals(x509Certificate.getIssuerDN())) continue;
            this.signCert = x509Certificate;
            break;
        }
        if (this.signCert == null) {
            throw new SecurityException("Can't find signing certificate with serial " + bigInteger.toString(16));
        }
        this.digestAlgorithm = ((SignerInfo)aSN1Encodable).getDigestAlgorithm().getObjectId().getId();
        this.digest = ((SignerInfo)aSN1Encodable).getEncryptedDigest().getOctets();
        this.digestEncryptionAlgorithm = ((SignerInfo)aSN1Encodable).getDigestEncryptionAlgorithm().getObjectId().getId();
        this.sig = Signature.getInstance(this.getDigestAlgorithm(), string2);
        this.sig.initVerify(this.signCert.getPublicKey());
    }

    public PKCS7SignedData(PrivateKey privateKey, Certificate[] certificateArray, String string2) throws SecurityException, InvalidKeyException, NoSuchProviderException, NoSuchAlgorithmException {
        this(privateKey, certificateArray, string2, "BC");
    }

    public PKCS7SignedData(PrivateKey privateKey, Certificate[] certificateArray, String string2, String string3) throws SecurityException, InvalidKeyException, NoSuchProviderException, NoSuchAlgorithmException {
        this(privateKey, certificateArray, null, string2, string3);
    }

    public PKCS7SignedData(PrivateKey privateKey, Certificate[] certificateArray, CRL[] cRLArray, String string2, String string3) throws SecurityException, InvalidKeyException, NoSuchProviderException, NoSuchAlgorithmException {
        int n;
        this.privKey = privateKey;
        if (string2.equals("MD5")) {
            this.digestAlgorithm = "1.2.840.113549.2.5";
        } else if (string2.equals("MD2")) {
            this.digestAlgorithm = "1.2.840.113549.2.2";
        } else if (string2.equals("SHA")) {
            this.digestAlgorithm = "1.3.14.3.2.26";
        } else if (string2.equals("SHA1")) {
            this.digestAlgorithm = "1.3.14.3.2.26";
        } else {
            throw new NoSuchAlgorithmException("Unknown Hash Algorithm " + string2);
        }
        this.signerversion = 1;
        this.version = 1;
        this.certs = new ArrayList();
        this.crls = new ArrayList();
        this.digestalgos = new HashSet();
        this.digestalgos.add(this.digestAlgorithm);
        this.signCert = (X509Certificate)certificateArray[0];
        for (n = 0; n < certificateArray.length; ++n) {
            this.certs.add(certificateArray[n]);
        }
        if (cRLArray != null) {
            for (n = 0; n < cRLArray.length; ++n) {
                this.crls.add(cRLArray[n]);
            }
        }
        this.digestEncryptionAlgorithm = privateKey.getAlgorithm();
        if (this.digestEncryptionAlgorithm.equals("RSA")) {
            this.digestEncryptionAlgorithm = "1.2.840.113549.1.1.1";
        } else if (this.digestEncryptionAlgorithm.equals("DSA")) {
            this.digestEncryptionAlgorithm = "1.2.840.10040.4.1";
        } else {
            throw new NoSuchAlgorithmException("Unknown Key Algorithm " + this.digestEncryptionAlgorithm);
        }
        this.sig = Signature.getInstance(this.getDigestAlgorithm(), string3);
        this.sig.initSign(privateKey);
    }

    public String getDigestAlgorithm() {
        String string2 = this.digestAlgorithm;
        String string3 = this.digestEncryptionAlgorithm;
        if (this.digestAlgorithm.equals("1.2.840.113549.2.5")) {
            string2 = "MD5";
        } else if (this.digestAlgorithm.equals("1.2.840.113549.2.2")) {
            string2 = "MD2";
        } else if (this.digestAlgorithm.equals("1.3.14.3.2.26")) {
            string2 = "SHA1";
        }
        if (this.digestEncryptionAlgorithm.equals("1.2.840.113549.1.1.1")) {
            string3 = "RSA";
        } else if (this.digestEncryptionAlgorithm.equals("1.2.840.10040.4.1")) {
            string3 = "DSA";
        }
        return string2 + "with" + string3;
    }

    public void reset() {
        try {
            if (this.privKey == null) {
                this.sig.initVerify(this.signCert.getPublicKey());
            } else {
                this.sig.initSign(this.privKey);
            }
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.toString());
        }
    }

    public Certificate[] getCertificates() {
        return this.certs.toArray(new X509Certificate[this.certs.size()]);
    }

    public Collection getCRLs() {
        return this.crls;
    }

    public X509Certificate getSigningCertificate() {
        return this.signCert;
    }

    public int getVersion() {
        return this.version;
    }

    public int getSigningInfoVersion() {
        return this.signerversion;
    }

    public void update(byte by2) throws SignatureException {
        this.sig.update(by2);
    }

    public void update(byte[] byArray, int n, int n2) throws SignatureException {
        this.sig.update(byArray, n, n2);
    }

    public boolean verify() throws SignatureException {
        return this.sig.verify(this.digest);
    }

    private DERObject getIssuer(byte[] byArray) {
        try {
            ASN1InputStream aSN1InputStream = new ASN1InputStream(new ByteArrayInputStream(byArray));
            ASN1Sequence aSN1Sequence = (ASN1Sequence)aSN1InputStream.readObject();
            return (DERObject)aSN1Sequence.getObjectAt(aSN1Sequence.getObjectAt(0) instanceof DERTaggedObject ? 3 : 2);
        }
        catch (IOException iOException) {
            throw new Error("IOException reading from ByteArray: " + iOException);
        }
    }

    public byte[] getEncoded() {
        try {
            Closeable closeable;
            Object object;
            Object object2;
            ASN1Encodable aSN1Encodable;
            this.digest = this.sig.sign();
            ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
            Object object3 = this.digestalgos.iterator();
            while (object3.hasNext()) {
                aSN1Encodable = new AlgorithmIdentifier(new DERObjectIdentifier((String)object3.next()), null);
                aSN1EncodableVector.add(aSN1Encodable);
            }
            object3 = new DERSet(aSN1EncodableVector);
            aSN1Encodable = new DERSequence(new DERObjectIdentifier("1.2.840.113549.1.7.1"));
            aSN1EncodableVector = new ASN1EncodableVector();
            Object object4 = this.certs.iterator();
            while (object4.hasNext()) {
                object2 = new ASN1InputStream(new ByteArrayInputStream(((X509Certificate)object4.next()).getEncoded()));
                aSN1EncodableVector.add(((ASN1InputStream)object2).readObject());
            }
            object4 = new DERSet(aSN1EncodableVector);
            object2 = new ASN1EncodableVector();
            ((DEREncodableVector)object2).add(new DERInteger(this.signerversion));
            IssuerAndSerialNumber issuerAndSerialNumber = new IssuerAndSerialNumber(new X509Name((ASN1Sequence)this.getIssuer(this.signCert.getTBSCertificate())), new DERInteger(this.signCert.getSerialNumber()));
            ((DEREncodableVector)object2).add(issuerAndSerialNumber);
            ((DEREncodableVector)object2).add(new AlgorithmIdentifier(new DERObjectIdentifier(this.digestAlgorithm), new DERNull()));
            ((DEREncodableVector)object2).add(new AlgorithmIdentifier(new DERObjectIdentifier(this.digestEncryptionAlgorithm), new DERNull()));
            ((DEREncodableVector)object2).add(new DEROctetString(this.digest));
            ASN1EncodableVector aSN1EncodableVector2 = new ASN1EncodableVector();
            aSN1EncodableVector2.add(new DERInteger(this.version));
            aSN1EncodableVector2.add((DEREncodable)object3);
            aSN1EncodableVector2.add(aSN1Encodable);
            aSN1EncodableVector2.add(new DERTaggedObject(false, 0, (DEREncodable)object4));
            if (this.crls.size() > 0) {
                aSN1EncodableVector = new ASN1EncodableVector();
                object = this.crls.iterator();
                while (object.hasNext()) {
                    closeable = new ASN1InputStream(new ByteArrayInputStream(((X509CRL)object.next()).getEncoded()));
                    aSN1EncodableVector.add(((ASN1InputStream)closeable).readObject());
                }
                object = new DERSet(aSN1EncodableVector);
                aSN1EncodableVector2.add(new DERTaggedObject(false, 1, (DEREncodable)object));
            }
            aSN1EncodableVector2.add(new DERSet(new DERSequence((DEREncodableVector)object2)));
            object = new ASN1EncodableVector();
            ((DEREncodableVector)object).add(new DERObjectIdentifier("1.2.840.113549.1.7.2"));
            ((DEREncodableVector)object).add(new DERTaggedObject(0, new DERSequence(aSN1EncodableVector2)));
            closeable = new ByteArrayOutputStream();
            DEROutputStream dEROutputStream = new DEROutputStream((OutputStream)closeable);
            dEROutputStream.writeObject(new DERSequence((DEREncodableVector)object));
            dEROutputStream.close();
            return ((ByteArrayOutputStream)closeable).toByteArray();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.toString());
        }
    }
}

