/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jce.provider.asymmetric.ec;

import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidParameterException;
import java.security.KeyPair;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.ECParameterSpec;
import java.util.Hashtable;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.cryptopro.ECGOST3410NamedCurves;
import org.bouncycastle.asn1.nist.NISTNamedCurves;
import org.bouncycastle.asn1.sec.SECNamedCurves;
import org.bouncycastle.asn1.teletrust.TeleTrusTNamedCurves;
import org.bouncycastle.asn1.x9.X962NamedCurves;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.generators.ECKeyPairGenerator;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.crypto.params.ECKeyGenerationParameters;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.jce.provider.JCEECPrivateKey;
import org.bouncycastle.jce.provider.JCEECPublicKey;
import org.bouncycastle.jce.provider.JDKKeyPairGenerator;
import org.bouncycastle.jce.provider.ProviderUtil;
import org.bouncycastle.jce.provider.asymmetric.ec.EC5Util;
import org.bouncycastle.jce.spec.ECNamedCurveSpec;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.math.ec.ECPoint;

public abstract class KeyPairGenerator
extends JDKKeyPairGenerator {
    public KeyPairGenerator(String string2) {
        super(string2);
    }

    public static class EC
    extends KeyPairGenerator {
        ECKeyGenerationParameters param;
        ECKeyPairGenerator engine = new ECKeyPairGenerator();
        Object ecParams = null;
        int strength = 239;
        int certainty = 50;
        SecureRandom random = new SecureRandom();
        boolean initialised = false;
        String algorithm;
        private static Hashtable ecParameters = new Hashtable();

        public EC() {
            super("EC");
            this.algorithm = "EC";
        }

        public EC(String string2) {
            super(string2);
            this.algorithm = string2;
        }

        @Override
        public void initialize(int n, SecureRandom secureRandom) {
            this.strength = n;
            this.random = secureRandom;
            this.ecParams = ecParameters.get(new Integer(n));
            if (this.ecParams != null) {
                try {
                    this.initialize((ECGenParameterSpec)this.ecParams, secureRandom);
                }
                catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                    throw new InvalidParameterException("key size not configurable.");
                }
            } else {
                throw new InvalidParameterException("unknown key size.");
            }
        }

        @Override
        public void initialize(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
            if (algorithmParameterSpec instanceof org.bouncycastle.jce.spec.ECParameterSpec) {
                org.bouncycastle.jce.spec.ECParameterSpec eCParameterSpec = (org.bouncycastle.jce.spec.ECParameterSpec)algorithmParameterSpec;
                this.ecParams = algorithmParameterSpec;
                this.param = new ECKeyGenerationParameters(new ECDomainParameters(eCParameterSpec.getCurve(), eCParameterSpec.getG(), eCParameterSpec.getN()), secureRandom);
                this.engine.init(this.param);
                this.initialised = true;
            } else if (algorithmParameterSpec instanceof ECParameterSpec) {
                ECParameterSpec eCParameterSpec = (ECParameterSpec)algorithmParameterSpec;
                this.ecParams = algorithmParameterSpec;
                ECCurve eCCurve = EC5Util.convertCurve(eCParameterSpec.getCurve());
                ECPoint eCPoint = EC5Util.convertPoint(eCCurve, eCParameterSpec.getGenerator(), false);
                this.param = new ECKeyGenerationParameters(new ECDomainParameters(eCCurve, eCPoint, eCParameterSpec.getOrder(), BigInteger.valueOf(eCParameterSpec.getCofactor())), secureRandom);
                this.engine.init(this.param);
                this.initialised = true;
            } else if (algorithmParameterSpec instanceof ECGenParameterSpec) {
                Object object;
                Object object2;
                String string2 = ((ECGenParameterSpec)algorithmParameterSpec).getName();
                if (this.algorithm.equals("ECGOST3410")) {
                    object2 = ECGOST3410NamedCurves.getByName(string2);
                    if (object2 == null) {
                        throw new InvalidAlgorithmParameterException("unknown curve name: " + string2);
                    }
                    this.ecParams = new ECNamedCurveSpec(string2, ((ECDomainParameters)object2).getCurve(), ((ECDomainParameters)object2).getG(), ((ECDomainParameters)object2).getN(), ((ECDomainParameters)object2).getH(), ((ECDomainParameters)object2).getSeed());
                } else {
                    object2 = X962NamedCurves.getByName(string2);
                    if (object2 == null) {
                        object2 = SECNamedCurves.getByName(string2);
                        if (object2 == null) {
                            object2 = NISTNamedCurves.getByName(string2);
                        }
                        if (object2 == null) {
                            object2 = TeleTrusTNamedCurves.getByName(string2);
                        }
                        if (object2 == null) {
                            try {
                                object = new DERObjectIdentifier(string2);
                                object2 = X962NamedCurves.getByOID((DERObjectIdentifier)object);
                                if (object2 == null) {
                                    object2 = SECNamedCurves.getByOID((DERObjectIdentifier)object);
                                }
                                if (object2 == null) {
                                    object2 = NISTNamedCurves.getByOID((DERObjectIdentifier)object);
                                }
                                if (object2 == null) {
                                    object2 = TeleTrusTNamedCurves.getByOID((DERObjectIdentifier)object);
                                }
                                if (object2 == null) {
                                    throw new InvalidAlgorithmParameterException("unknown curve OID: " + string2);
                                }
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw new InvalidAlgorithmParameterException("unknown curve name: " + string2);
                            }
                        }
                    }
                    this.ecParams = new ECNamedCurveSpec(string2, ((X9ECParameters)object2).getCurve(), ((X9ECParameters)object2).getG(), ((X9ECParameters)object2).getN(), ((X9ECParameters)object2).getH(), null);
                }
                object2 = (ECParameterSpec)this.ecParams;
                object = EC5Util.convertCurve(((ECParameterSpec)object2).getCurve());
                ECPoint eCPoint = EC5Util.convertPoint((ECCurve)object, ((ECParameterSpec)object2).getGenerator(), false);
                this.param = new ECKeyGenerationParameters(new ECDomainParameters((ECCurve)object, eCPoint, ((ECParameterSpec)object2).getOrder(), BigInteger.valueOf(((ECParameterSpec)object2).getCofactor())), secureRandom);
                this.engine.init(this.param);
                this.initialised = true;
            } else if (algorithmParameterSpec == null && ProviderUtil.getEcImplicitlyCa() != null) {
                org.bouncycastle.jce.spec.ECParameterSpec eCParameterSpec = ProviderUtil.getEcImplicitlyCa();
                this.ecParams = algorithmParameterSpec;
                this.param = new ECKeyGenerationParameters(new ECDomainParameters(eCParameterSpec.getCurve(), eCParameterSpec.getG(), eCParameterSpec.getN()), secureRandom);
                this.engine.init(this.param);
                this.initialised = true;
            } else {
                if (algorithmParameterSpec == null && ProviderUtil.getEcImplicitlyCa() == null) {
                    throw new InvalidAlgorithmParameterException("null parameter passed but no implicitCA set");
                }
                throw new InvalidAlgorithmParameterException("parameter object not a ECParameterSpec");
            }
        }

        @Override
        public KeyPair generateKeyPair() {
            if (!this.initialised) {
                throw new IllegalStateException("EC Key Pair Generator not initialised");
            }
            AsymmetricCipherKeyPair asymmetricCipherKeyPair = this.engine.generateKeyPair();
            ECPublicKeyParameters eCPublicKeyParameters = (ECPublicKeyParameters)asymmetricCipherKeyPair.getPublic();
            ECPrivateKeyParameters eCPrivateKeyParameters = (ECPrivateKeyParameters)asymmetricCipherKeyPair.getPrivate();
            if (this.ecParams instanceof org.bouncycastle.jce.spec.ECParameterSpec) {
                org.bouncycastle.jce.spec.ECParameterSpec eCParameterSpec = (org.bouncycastle.jce.spec.ECParameterSpec)this.ecParams;
                JCEECPublicKey jCEECPublicKey = new JCEECPublicKey(this.algorithm, eCPublicKeyParameters, eCParameterSpec);
                return new KeyPair(jCEECPublicKey, new JCEECPrivateKey(this.algorithm, eCPrivateKeyParameters, jCEECPublicKey, eCParameterSpec));
            }
            if (this.ecParams == null) {
                return new KeyPair(new JCEECPublicKey(this.algorithm, eCPublicKeyParameters), new JCEECPrivateKey(this.algorithm, eCPrivateKeyParameters));
            }
            ECParameterSpec eCParameterSpec = (ECParameterSpec)this.ecParams;
            JCEECPublicKey jCEECPublicKey = new JCEECPublicKey(this.algorithm, eCPublicKeyParameters, eCParameterSpec);
            return new KeyPair(jCEECPublicKey, new JCEECPrivateKey(this.algorithm, eCPrivateKeyParameters, jCEECPublicKey, eCParameterSpec));
        }

        static {
            ecParameters.put(new Integer(192), new ECGenParameterSpec("prime192v1"));
            ecParameters.put(new Integer(239), new ECGenParameterSpec("prime239v1"));
            ecParameters.put(new Integer(256), new ECGenParameterSpec("prime256v1"));
            ecParameters.put(new Integer(224), new ECGenParameterSpec("P-224"));
            ecParameters.put(new Integer(384), new ECGenParameterSpec("P-384"));
            ecParameters.put(new Integer(521), new ECGenParameterSpec("P-521"));
        }
    }

    public static class ECDH
    extends EC {
        public ECDH() {
            super("ECDH");
        }
    }

    public static class ECDHC
    extends EC {
        public ECDHC() {
            super("ECDHC");
        }
    }

    public static class ECDSA
    extends EC {
        public ECDSA() {
            super("ECDSA");
        }
    }

    public static class ECGOST3410
    extends EC {
        public ECGOST3410() {
            super("ECGOST3410");
        }
    }

    public static class ECMQV
    extends EC {
        public ECMQV() {
            super("ECMQV");
        }
    }
}

