/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openssl;

import java.io.IOException;
import java.security.Key;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.RC2ParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.crypto.PBEParametersGenerator;
import org.bouncycastle.crypto.generators.OpenSSLPBEParametersGenerator;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.openssl.EncryptionException;

final class PEMUtilities {
    PEMUtilities() {
    }

    static byte[] crypt(boolean bl, String string2, byte[] byArray, char[] cArray, String string3, byte[] byArray2) throws IOException {
        SecretKey secretKey;
        String string4;
        AlgorithmParameterSpec algorithmParameterSpec = new IvParameterSpec(byArray2);
        String string5 = "CBC";
        String string6 = "PKCS5Padding";
        if (string3.endsWith("-CFB")) {
            string5 = "CFB";
            string6 = "NoPadding";
        }
        if (string3.endsWith("-ECB") || "DES-EDE".equals(string3) || "DES-EDE3".equals(string3)) {
            string5 = "ECB";
            algorithmParameterSpec = null;
        }
        if (string3.endsWith("-OFB")) {
            string5 = "OFB";
            string6 = "NoPadding";
        }
        if (string3.startsWith("DES-EDE")) {
            string4 = "DESede";
            boolean bl2 = !string3.startsWith("DES-EDE3");
            secretKey = PEMUtilities.getKey(cArray, string4, 24, byArray2, bl2);
        } else if (string3.startsWith("DES-")) {
            string4 = "DES";
            secretKey = PEMUtilities.getKey(cArray, string4, 8, byArray2);
        } else if (string3.startsWith("BF-")) {
            string4 = "Blowfish";
            secretKey = PEMUtilities.getKey(cArray, string4, 16, byArray2);
        } else if (string3.startsWith("RC2-")) {
            string4 = "RC2";
            int n = 128;
            if (string3.startsWith("RC2-40-")) {
                n = 40;
            } else if (string3.startsWith("RC2-64-")) {
                n = 64;
            }
            secretKey = PEMUtilities.getKey(cArray, string4, n / 8, byArray2);
            algorithmParameterSpec = algorithmParameterSpec == null ? new RC2ParameterSpec(n) : new RC2ParameterSpec(n, byArray2);
        } else if (string3.startsWith("AES-")) {
            int n;
            string4 = "AES";
            byte[] byArray3 = byArray2;
            if (byArray3.length > 8) {
                byArray3 = new byte[8];
                System.arraycopy(byArray2, 0, byArray3, 0, 8);
            }
            if (string3.startsWith("AES-128-")) {
                n = 128;
            } else if (string3.startsWith("AES-192-")) {
                n = 192;
            } else if (string3.startsWith("AES-256-")) {
                n = 256;
            } else {
                throw new EncryptionException("unknown AES encryption with private key");
            }
            secretKey = PEMUtilities.getKey(cArray, "AES", n / 8, byArray3);
        } else {
            throw new EncryptionException("unknown encryption with private key");
        }
        String string7 = string4 + "/" + string5 + "/" + string6;
        try {
            int n;
            Cipher cipher = Cipher.getInstance(string7, string2);
            int n2 = n = bl ? 1 : 2;
            if (algorithmParameterSpec == null) {
                cipher.init(n, secretKey);
            } else {
                cipher.init(n, (Key)secretKey, algorithmParameterSpec);
            }
            return cipher.doFinal(byArray);
        }
        catch (Exception exception) {
            throw new EncryptionException("exception using cipher - please check password and data.", exception);
        }
    }

    private static SecretKey getKey(char[] cArray, String string2, int n, byte[] byArray) {
        return PEMUtilities.getKey(cArray, string2, n, byArray, false);
    }

    private static SecretKey getKey(char[] cArray, String string2, int n, byte[] byArray, boolean bl) {
        OpenSSLPBEParametersGenerator openSSLPBEParametersGenerator = new OpenSSLPBEParametersGenerator();
        openSSLPBEParametersGenerator.init(PBEParametersGenerator.PKCS5PasswordToBytes(cArray), byArray);
        KeyParameter keyParameter = (KeyParameter)openSSLPBEParametersGenerator.generateDerivedParameters(n * 8);
        byte[] byArray2 = keyParameter.getKey();
        if (bl && byArray2.length >= 24) {
            System.arraycopy(byArray2, 0, byArray2, 16, 8);
        }
        return new SecretKeySpec(byArray2, string2);
    }
}

