/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.util;

import java.io.ByteArrayOutputStream;
import java.util.Vector;

public final class Strings {
    public static String fromUTF8ByteArray(byte[] byArray) {
        int n = 0;
        int n2 = 0;
        while (n < byArray.length) {
            ++n2;
            if ((byArray[n] & 0xF0) == 240) {
                ++n2;
                n += 4;
                continue;
            }
            if ((byArray[n] & 0xE0) == 224) {
                n += 3;
                continue;
            }
            if ((byArray[n] & 0xC0) == 192) {
                n += 2;
                continue;
            }
            ++n;
        }
        char[] cArray = new char[n2];
        n = 0;
        n2 = 0;
        while (n < byArray.length) {
            char c2;
            if ((byArray[n] & 0xF0) == 240) {
                int n3 = (byArray[n] & 3) << 18 | (byArray[n + 1] & 0x3F) << 12 | (byArray[n + 2] & 0x3F) << 6 | byArray[n + 3] & 0x3F;
                int n4 = n3 - 65536;
                char c3 = (char)(0xD800 | n4 >> 10);
                char c4 = (char)(0xDC00 | n4 & 0x3FF);
                cArray[n2++] = c3;
                c2 = c4;
                n += 4;
            } else if ((byArray[n] & 0xE0) == 224) {
                c2 = (char)((byArray[n] & 0xF) << 12 | (byArray[n + 1] & 0x3F) << 6 | byArray[n + 2] & 0x3F);
                n += 3;
            } else if ((byArray[n] & 0xD0) == 208) {
                c2 = (char)((byArray[n] & 0x1F) << 6 | byArray[n + 1] & 0x3F);
                n += 2;
            } else if ((byArray[n] & 0xC0) == 192) {
                c2 = (char)((byArray[n] & 0x1F) << 6 | byArray[n + 1] & 0x3F);
                n += 2;
            } else {
                c2 = (char)(byArray[n] & 0xFF);
                ++n;
            }
            cArray[n2++] = c2;
        }
        return new String(cArray);
    }

    public static byte[] toUTF8ByteArray(String string2) {
        return Strings.toUTF8ByteArray(string2.toCharArray());
    }

    public static byte[] toUTF8ByteArray(char[] cArray) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        char[] cArray2 = cArray;
        for (int i = 0; i < cArray2.length; ++i) {
            char c2 = cArray2[i];
            if (c2 < '\u0080') {
                byteArrayOutputStream.write(c2);
                continue;
            }
            if (c2 < '\u0800') {
                byteArrayOutputStream.write(0xC0 | c2 >> 6);
                byteArrayOutputStream.write(0x80 | c2 & 0x3F);
                continue;
            }
            if (c2 >= '\ud800' && c2 <= '\udfff') {
                if (i + 1 >= cArray2.length) {
                    throw new IllegalStateException("invalid UTF-16 codepoint");
                }
                char c3 = c2;
                char c4 = c2 = cArray2[++i];
                if (c3 > '\udbff') {
                    throw new IllegalStateException("invalid UTF-16 codepoint");
                }
                int n = ((c3 & 0x3FF) << 10 | c4 & 0x3FF) + 65536;
                byteArrayOutputStream.write(0xF0 | n >> 18);
                byteArrayOutputStream.write(0x80 | n >> 12 & 0x3F);
                byteArrayOutputStream.write(0x80 | n >> 6 & 0x3F);
                byteArrayOutputStream.write(0x80 | n & 0x3F);
                continue;
            }
            byteArrayOutputStream.write(0xE0 | c2 >> 12);
            byteArrayOutputStream.write(0x80 | c2 >> 6 & 0x3F);
            byteArrayOutputStream.write(0x80 | c2 & 0x3F);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static String toUpperCase(String string2) {
        boolean bl = false;
        char[] cArray = string2.toCharArray();
        for (int i = 0; i != cArray.length; ++i) {
            char c2 = cArray[i];
            if ('a' > c2 || 'z' < c2) continue;
            bl = true;
            cArray[i] = (char)(c2 - 97 + 65);
        }
        if (bl) {
            return new String(cArray);
        }
        return string2;
    }

    public static String toLowerCase(String string2) {
        boolean bl = false;
        char[] cArray = string2.toCharArray();
        for (int i = 0; i != cArray.length; ++i) {
            char c2 = cArray[i];
            if ('A' > c2 || 'Z' < c2) continue;
            bl = true;
            cArray[i] = (char)(c2 - 65 + 97);
        }
        if (bl) {
            return new String(cArray);
        }
        return string2;
    }

    public static byte[] toByteArray(String string2) {
        byte[] byArray = new byte[string2.length()];
        for (int i = 0; i != byArray.length; ++i) {
            char c2 = string2.charAt(i);
            byArray[i] = (byte)c2;
        }
        return byArray;
    }

    public static String[] split(String string2, char c2) {
        Vector<String> vector = new Vector<String>();
        boolean bl = true;
        while (bl) {
            int n = string2.indexOf(c2);
            if (n > 0) {
                String string3 = string2.substring(0, n);
                vector.addElement(string3);
                string2 = string2.substring(n + 1);
                continue;
            }
            bl = false;
            vector.addElement(string2);
        }
        String[] stringArray = new String[vector.size()];
        for (int i = 0; i != stringArray.length; ++i) {
            stringArray[i] = (String)vector.elementAt(i);
        }
        return stringArray;
    }
}

