/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.x509;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.x509.AttributeCertificate;
import org.bouncycastle.asn1.x509.X509Extension;
import org.bouncycastle.asn1.x509.X509Extensions;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.x509.AttributeCertificateHolder;
import org.bouncycastle.x509.AttributeCertificateIssuer;
import org.bouncycastle.x509.X509Attribute;
import org.bouncycastle.x509.X509AttributeCertificate;

public class X509V2AttributeCertificate
implements X509AttributeCertificate {
    private AttributeCertificate cert;
    private Date notBefore;
    private Date notAfter;

    public X509V2AttributeCertificate(InputStream inputStream) throws IOException {
        this(AttributeCertificate.getInstance(new ASN1InputStream(inputStream).readObject()));
    }

    public X509V2AttributeCertificate(byte[] byArray) throws IOException {
        this(new ByteArrayInputStream(byArray));
    }

    X509V2AttributeCertificate(AttributeCertificate attributeCertificate) throws IOException {
        this.cert = attributeCertificate;
        try {
            this.notAfter = attributeCertificate.getAcinfo().getAttrCertValidityPeriod().getNotAfterTime().getDate();
            this.notBefore = attributeCertificate.getAcinfo().getAttrCertValidityPeriod().getNotBeforeTime().getDate();
        }
        catch (ParseException parseException) {
            throw new IOException("invalid data structure in certificate!");
        }
    }

    @Override
    public int getVersion() {
        return this.cert.getAcinfo().getVersion().getValue().intValue() + 1;
    }

    @Override
    public BigInteger getSerialNumber() {
        return this.cert.getAcinfo().getSerialNumber().getValue();
    }

    @Override
    public AttributeCertificateHolder getHolder() {
        return new AttributeCertificateHolder((ASN1Sequence)this.cert.getAcinfo().getHolder().toASN1Object());
    }

    @Override
    public AttributeCertificateIssuer getIssuer() {
        return new AttributeCertificateIssuer(this.cert.getAcinfo().getIssuer());
    }

    @Override
    public Date getNotBefore() {
        return this.notBefore;
    }

    @Override
    public Date getNotAfter() {
        return this.notAfter;
    }

    @Override
    public boolean[] getIssuerUniqueID() {
        DERBitString dERBitString = this.cert.getAcinfo().getIssuerUniqueID();
        if (dERBitString != null) {
            byte[] byArray = dERBitString.getBytes();
            boolean[] blArray = new boolean[byArray.length * 8 - dERBitString.getPadBits()];
            for (int i = 0; i != blArray.length; ++i) {
                blArray[i] = (byArray[i / 8] & 128 >>> i % 8) != 0;
            }
            return blArray;
        }
        return null;
    }

    @Override
    public void checkValidity() throws CertificateExpiredException, CertificateNotYetValidException {
        this.checkValidity(new Date());
    }

    @Override
    public void checkValidity(Date date) throws CertificateExpiredException, CertificateNotYetValidException {
        if (date.after(this.getNotAfter())) {
            throw new CertificateExpiredException("certificate expired on " + this.getNotAfter());
        }
        if (date.before(this.getNotBefore())) {
            throw new CertificateNotYetValidException("certificate not valid till " + this.getNotBefore());
        }
    }

    @Override
    public byte[] getSignature() {
        return this.cert.getSignatureValue().getBytes();
    }

    @Override
    public final void verify(PublicKey publicKey, String string2) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        Signature signature2 = null;
        if (!this.cert.getSignatureAlgorithm().equals(this.cert.getAcinfo().getSignature())) {
            throw new CertificateException("Signature algorithm in certificate info not same as outer certificate");
        }
        signature2 = Signature.getInstance(this.cert.getSignatureAlgorithm().getObjectId().getId(), string2);
        signature2.initVerify(publicKey);
        try {
            signature2.update(this.cert.getAcinfo().getEncoded());
        }
        catch (IOException iOException) {
            throw new SignatureException("Exception encoding certificate info object");
        }
        if (!signature2.verify(this.getSignature())) {
            throw new InvalidKeyException("Public key presented not for certificate signature");
        }
    }

    @Override
    public byte[] getEncoded() throws IOException {
        return this.cert.getEncoded();
    }

    @Override
    public byte[] getExtensionValue(String string2) {
        X509Extension x509Extension;
        X509Extensions x509Extensions = this.cert.getAcinfo().getExtensions();
        if (x509Extensions != null && (x509Extension = x509Extensions.getExtension(new DERObjectIdentifier(string2))) != null) {
            try {
                return x509Extension.getValue().getEncoded("DER");
            }
            catch (Exception exception) {
                throw new RuntimeException("error encoding " + exception.toString());
            }
        }
        return null;
    }

    private Set getExtensionOIDs(boolean bl) {
        X509Extensions x509Extensions = this.cert.getAcinfo().getExtensions();
        if (x509Extensions != null) {
            HashSet<String> hashSet = new HashSet<String>();
            Enumeration enumeration = x509Extensions.oids();
            while (enumeration.hasMoreElements()) {
                DERObjectIdentifier dERObjectIdentifier = (DERObjectIdentifier)enumeration.nextElement();
                X509Extension x509Extension = x509Extensions.getExtension(dERObjectIdentifier);
                if (x509Extension.isCritical() != bl) continue;
                hashSet.add(dERObjectIdentifier.getId());
            }
            return hashSet;
        }
        return null;
    }

    public Set getNonCriticalExtensionOIDs() {
        return this.getExtensionOIDs(false);
    }

    public Set getCriticalExtensionOIDs() {
        return this.getExtensionOIDs(true);
    }

    @Override
    public boolean hasUnsupportedCriticalExtension() {
        Set set2 = this.getCriticalExtensionOIDs();
        return set2 != null && !set2.isEmpty();
    }

    @Override
    public X509Attribute[] getAttributes() {
        ASN1Sequence aSN1Sequence = this.cert.getAcinfo().getAttributes();
        X509Attribute[] x509AttributeArray = new X509Attribute[aSN1Sequence.size()];
        for (int i = 0; i != aSN1Sequence.size(); ++i) {
            x509AttributeArray[i] = new X509Attribute((ASN1Encodable)aSN1Sequence.getObjectAt(i));
        }
        return x509AttributeArray;
    }

    @Override
    public X509Attribute[] getAttributes(String string2) {
        ASN1Sequence aSN1Sequence = this.cert.getAcinfo().getAttributes();
        ArrayList<X509Attribute> arrayList = new ArrayList<X509Attribute>();
        for (int i = 0; i != aSN1Sequence.size(); ++i) {
            X509Attribute x509Attribute = new X509Attribute((ASN1Encodable)aSN1Sequence.getObjectAt(i));
            if (!x509Attribute.getOID().equals(string2)) continue;
            arrayList.add(x509Attribute);
        }
        if (arrayList.size() == 0) {
            return null;
        }
        return arrayList.toArray(new X509Attribute[arrayList.size()]);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof X509AttributeCertificate)) {
            return false;
        }
        X509AttributeCertificate x509AttributeCertificate = (X509AttributeCertificate)object;
        try {
            byte[] byArray = this.getEncoded();
            byte[] byArray2 = x509AttributeCertificate.getEncoded();
            return Arrays.areEqual(byArray, byArray2);
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public int hashCode() {
        try {
            return Arrays.hashCode(this.getEncoded());
        }
        catch (IOException iOException) {
            return 0;
        }
    }
}

