/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.stax2.ri;

import java.io.IOException;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.util.StreamReaderDelegate;
import org.codehaus.stax2.AttributeInfo;
import org.codehaus.stax2.DTDInfo;
import org.codehaus.stax2.LocationInfo;
import org.codehaus.stax2.XMLStreamLocation2;
import org.codehaus.stax2.XMLStreamReader2;
import org.codehaus.stax2.ri.Stax2LocationAdapter;
import org.codehaus.stax2.ri.Stax2Util;
import org.codehaus.stax2.ri.typed.StringBase64Decoder;
import org.codehaus.stax2.ri.typed.ValueDecoderFactory;
import org.codehaus.stax2.typed.Base64Variant;
import org.codehaus.stax2.typed.Base64Variants;
import org.codehaus.stax2.typed.TypedArrayDecoder;
import org.codehaus.stax2.typed.TypedValueDecoder;
import org.codehaus.stax2.typed.TypedXMLStreamException;
import org.codehaus.stax2.validation.DTDValidationSchema;
import org.codehaus.stax2.validation.ValidationProblemHandler;
import org.codehaus.stax2.validation.XMLValidationSchema;
import org.codehaus.stax2.validation.XMLValidator;

public class Stax2ReaderAdapter
extends StreamReaderDelegate
implements XMLStreamReader2,
AttributeInfo,
DTDInfo,
LocationInfo {
    static final int INT_SPACE = 32;
    private static final int MASK_GET_ELEMENT_TEXT = 4688;
    protected static final int MASK_TYPED_ACCESS_BINARY = 4178;
    protected ValueDecoderFactory _decoderFactory;
    protected StringBase64Decoder _base64Decoder = null;
    protected int _depth = 0;
    protected String _typedContent;

    protected Stax2ReaderAdapter(XMLStreamReader sr) {
        super(sr);
    }

    public static XMLStreamReader2 wrapIfNecessary(XMLStreamReader sr) {
        if (sr instanceof XMLStreamReader2) {
            return (XMLStreamReader2)sr;
        }
        return new Stax2ReaderAdapter(sr);
    }

    public int next() throws XMLStreamException {
        if (this._typedContent != null) {
            this._typedContent = null;
            return 2;
        }
        int type = super.next();
        if (type == 1) {
            ++this._depth;
        } else if (type == 2) {
            --this._depth;
        }
        return type;
    }

    public String getElementText() throws XMLStreamException {
        boolean hadStart = this.getEventType() == 1;
        String text2 = super.getElementText();
        if (hadStart) {
            --this._depth;
        }
        return text2;
    }

    public boolean getElementAsBoolean() throws XMLStreamException {
        ValueDecoderFactory.BooleanDecoder dec = this._decoderFactory().getBooleanDecoder();
        this.getElementAs(dec);
        return dec.getValue();
    }

    public int getElementAsInt() throws XMLStreamException {
        ValueDecoderFactory.IntDecoder dec = this._decoderFactory().getIntDecoder();
        this.getElementAs(dec);
        return dec.getValue();
    }

    public long getElementAsLong() throws XMLStreamException {
        ValueDecoderFactory.LongDecoder dec = this._decoderFactory().getLongDecoder();
        this.getElementAs(dec);
        return dec.getValue();
    }

    public float getElementAsFloat() throws XMLStreamException {
        ValueDecoderFactory.FloatDecoder dec = this._decoderFactory().getFloatDecoder();
        this.getElementAs(dec);
        return dec.getValue();
    }

    public double getElementAsDouble() throws XMLStreamException {
        ValueDecoderFactory.DoubleDecoder dec = this._decoderFactory().getDoubleDecoder();
        this.getElementAs(dec);
        return dec.getValue();
    }

    public BigInteger getElementAsInteger() throws XMLStreamException {
        ValueDecoderFactory.IntegerDecoder dec = this._decoderFactory().getIntegerDecoder();
        this.getElementAs(dec);
        return dec.getValue();
    }

    public BigDecimal getElementAsDecimal() throws XMLStreamException {
        ValueDecoderFactory.DecimalDecoder dec = this._decoderFactory().getDecimalDecoder();
        this.getElementAs(dec);
        return dec.getValue();
    }

    public QName getElementAsQName() throws XMLStreamException {
        ValueDecoderFactory.QNameDecoder dec = this._decoderFactory().getQNameDecoder(this.getNamespaceContext());
        this.getElementAs(dec);
        return dec.getValue();
    }

    public byte[] getElementAsBinary() throws XMLStreamException {
        return this.getElementAsBinary(Base64Variants.getDefaultVariant());
    }

    public byte[] getElementAsBinary(Base64Variant v) throws XMLStreamException {
        Stax2Util.ByteAggregator aggr = this._base64Decoder().getByteAggregator();
        byte[] buffer = aggr.startAggregation();
        while (true) {
            int readCount;
            int offset2 = 0;
            int len2 = buffer.length;
            do {
                if ((readCount = this.readElementAsBinary(buffer, offset2, len2, v)) < 1) {
                    return aggr.aggregateAll(buffer, offset2);
                }
                offset2 += readCount;
            } while ((len2 -= readCount) > 0);
            buffer = aggr.addFullBlock(buffer);
        }
    }

    public void getElementAs(TypedValueDecoder tvd) throws XMLStreamException {
        String value2 = this.getElementText();
        value2 = Stax2Util.trimSpaces(value2);
        try {
            if (value2 == null) {
                tvd.handleEmptyValue();
            } else {
                tvd.decode(value2);
            }
        }
        catch (IllegalArgumentException iae) {
            throw this._constructTypeException(iae, value2);
        }
    }

    public int readElementAsIntArray(int[] value2, int from2, int length2) throws XMLStreamException {
        return this.readElementAsArray(this._decoderFactory().getIntArrayDecoder(value2, from2, length2));
    }

    public int readElementAsLongArray(long[] value2, int from2, int length2) throws XMLStreamException {
        return this.readElementAsArray(this._decoderFactory().getLongArrayDecoder(value2, from2, length2));
    }

    public int readElementAsFloatArray(float[] value2, int from2, int length2) throws XMLStreamException {
        return this.readElementAsArray(this._decoderFactory().getFloatArrayDecoder(value2, from2, length2));
    }

    public int readElementAsDoubleArray(double[] value2, int from2, int length2) throws XMLStreamException {
        return this.readElementAsArray(this._decoderFactory().getDoubleArrayDecoder(value2, from2, length2));
    }

    public int readElementAsArray(TypedArrayDecoder tad) throws XMLStreamException {
        String string2;
        int ptr;
        if (this._typedContent == null) {
            int type = this.getEventType();
            if (type == 2) {
                return -1;
            }
            if (type != 1) {
                throw new IllegalStateException("First call to readElementAsArray() must be for a START_ELEMENT");
            }
            this._typedContent = this.getElementText();
        }
        String input2 = this._typedContent;
        int end2 = input2.length();
        int count2 = 0;
        String value2 = null;
        try {
            int len2;
            block4: for (ptr = 0; ptr < end2; ++ptr) {
                while (input2.charAt(ptr) <= ' ') {
                    if (++ptr < end2) continue;
                    break block4;
                }
                int start2 = ptr++;
                while (ptr < end2 && input2.charAt(ptr) > ' ') {
                    ++ptr;
                }
                ++count2;
                value2 = input2.substring(start2, ptr);
                if (!tad.decodeValue(value2)) continue;
                break;
            }
            string2 = (len2 = end2 - ptr) < 1 ? null : input2.substring(ptr);
        }
        catch (IllegalArgumentException iae) {
            try {
                Location loc = this.getLocation();
                throw new TypedXMLStreamException(value2, iae.getMessage(), loc, iae);
            }
            catch (Throwable throwable2) {
                int len3 = end2 - ptr;
                this._typedContent = len3 < 1 ? null : input2.substring(ptr);
                throw throwable2;
            }
        }
        this._typedContent = string2;
        return count2 < 1 ? -1 : count2;
    }

    public int readElementAsBinary(byte[] resultBuffer, int offset2, int maxLength) throws XMLStreamException {
        return this.readElementAsBinary(resultBuffer, offset2, maxLength, Base64Variants.getDefaultVariant());
    }

    public int readElementAsBinary(byte[] resultBuffer, int offset2, int maxLength, Base64Variant v) throws XMLStreamException {
        if (resultBuffer == null) {
            throw new IllegalArgumentException("resultBuffer is null");
        }
        if (offset2 < 0) {
            throw new IllegalArgumentException("Illegal offset (" + offset2 + "), must be [0, " + resultBuffer.length + "[");
        }
        if (maxLength < 1 || offset2 + maxLength > resultBuffer.length) {
            if (maxLength == 0) {
                return 0;
            }
            throw new IllegalArgumentException("Illegal maxLength (" + maxLength + "), has to be positive number, and offset+maxLength can not exceed" + resultBuffer.length);
        }
        StringBase64Decoder dec = this._base64Decoder();
        int type = this.getEventType();
        if ((1 << type & 0x1052) == 0) {
            if (type == 2) {
                if (!dec.hasData()) {
                    return -1;
                }
            } else {
                this.throwNotStartElemOrTextual(type);
            }
        }
        if (type == 1) {
            do {
                if ((type = this.next()) != 2) continue;
                return -1;
            } while (type == 5 || type == 3);
            if ((1 << type & 0x1250) == 0) {
                this.throwNotStartElemOrTextual(type);
            }
            dec.init(v, true, this.getText());
        }
        int totalCount = 0;
        while (true) {
            int count2;
            try {
                count2 = dec.decode(resultBuffer, offset2, maxLength);
            }
            catch (IllegalArgumentException iae) {
                throw this._constructTypeException(iae, "");
            }
            offset2 += count2;
            totalCount += count2;
            if ((maxLength -= count2) < 1 || this.getEventType() == 2) break;
            while ((type = this.next()) == 5 || type == 3 || type == 6) {
            }
            if (type == 2) {
                int left2 = dec.endOfContent();
                if (left2 < 0) {
                    throw this._constructTypeException("Incomplete base64 triplet at the end of decoded content", "");
                }
                if (left2 <= 0) break;
                continue;
            }
            if ((1 << type & 0x1250) == 0) {
                this.throwNotStartElemOrTextual(type);
            }
            dec.init(v, false, this.getText());
        }
        return totalCount > 0 ? totalCount : -1;
    }

    public int getAttributeIndex(String namespaceURI, String localName) {
        return this.findAttributeIndex(namespaceURI, localName);
    }

    public boolean getAttributeAsBoolean(int index2) throws XMLStreamException {
        ValueDecoderFactory.BooleanDecoder dec = this._decoderFactory().getBooleanDecoder();
        this.getAttributeAs(index2, dec);
        return dec.getValue();
    }

    public int getAttributeAsInt(int index2) throws XMLStreamException {
        ValueDecoderFactory.IntDecoder dec = this._decoderFactory().getIntDecoder();
        this.getAttributeAs(index2, dec);
        return dec.getValue();
    }

    public long getAttributeAsLong(int index2) throws XMLStreamException {
        ValueDecoderFactory.LongDecoder dec = this._decoderFactory().getLongDecoder();
        this.getAttributeAs(index2, dec);
        return dec.getValue();
    }

    public float getAttributeAsFloat(int index2) throws XMLStreamException {
        ValueDecoderFactory.FloatDecoder dec = this._decoderFactory().getFloatDecoder();
        this.getAttributeAs(index2, dec);
        return dec.getValue();
    }

    public double getAttributeAsDouble(int index2) throws XMLStreamException {
        ValueDecoderFactory.DoubleDecoder dec = this._decoderFactory().getDoubleDecoder();
        this.getAttributeAs(index2, dec);
        return dec.getValue();
    }

    public BigInteger getAttributeAsInteger(int index2) throws XMLStreamException {
        ValueDecoderFactory.IntegerDecoder dec = this._decoderFactory().getIntegerDecoder();
        this.getAttributeAs(index2, dec);
        return dec.getValue();
    }

    public BigDecimal getAttributeAsDecimal(int index2) throws XMLStreamException {
        ValueDecoderFactory.DecimalDecoder dec = this._decoderFactory().getDecimalDecoder();
        this.getAttributeAs(index2, dec);
        return dec.getValue();
    }

    public QName getAttributeAsQName(int index2) throws XMLStreamException {
        ValueDecoderFactory.QNameDecoder dec = this._decoderFactory().getQNameDecoder(this.getNamespaceContext());
        this.getAttributeAs(index2, dec);
        return dec.getValue();
    }

    public void getAttributeAs(int index2, TypedValueDecoder tvd) throws XMLStreamException {
        String value2 = this.getAttributeValue(index2);
        value2 = Stax2Util.trimSpaces(value2);
        try {
            if (value2 == null) {
                tvd.handleEmptyValue();
            } else {
                tvd.decode(value2);
            }
        }
        catch (IllegalArgumentException iae) {
            throw this._constructTypeException(iae, value2);
        }
    }

    public int[] getAttributeAsIntArray(int index2) throws XMLStreamException {
        ValueDecoderFactory.IntArrayDecoder dec = this._decoderFactory().getIntArrayDecoder();
        this._getAttributeAsArray(dec, this.getAttributeValue(index2));
        return dec.getValues();
    }

    public long[] getAttributeAsLongArray(int index2) throws XMLStreamException {
        ValueDecoderFactory.LongArrayDecoder dec = this._decoderFactory().getLongArrayDecoder();
        this._getAttributeAsArray(dec, this.getAttributeValue(index2));
        return dec.getValues();
    }

    public float[] getAttributeAsFloatArray(int index2) throws XMLStreamException {
        ValueDecoderFactory.FloatArrayDecoder dec = this._decoderFactory().getFloatArrayDecoder();
        this._getAttributeAsArray(dec, this.getAttributeValue(index2));
        return dec.getValues();
    }

    public double[] getAttributeAsDoubleArray(int index2) throws XMLStreamException {
        ValueDecoderFactory.DoubleArrayDecoder dec = this._decoderFactory().getDoubleArrayDecoder();
        this._getAttributeAsArray(dec, this.getAttributeValue(index2));
        return dec.getValues();
    }

    public int getAttributeAsArray(int index2, TypedArrayDecoder tad) throws XMLStreamException {
        return this._getAttributeAsArray(tad, this.getAttributeValue(index2));
    }

    protected int _getAttributeAsArray(TypedArrayDecoder tad, String attrValue) throws XMLStreamException {
        int count2;
        block5: {
            int ptr = 0;
            int start2 = 0;
            int end2 = attrValue.length();
            String lexical = null;
            count2 = 0;
            try {
                while (ptr < end2) {
                    while (attrValue.charAt(ptr) <= ' ') {
                        if (++ptr < end2) continue;
                        break block5;
                    }
                    start2 = ptr++;
                    while (ptr < end2 && attrValue.charAt(ptr) > ' ') {
                        ++ptr;
                    }
                    int tokenEnd = ptr++;
                    lexical = attrValue.substring(start2, tokenEnd);
                    ++count2;
                    if (!tad.decodeValue(lexical) || this.checkExpand(tad)) continue;
                    break;
                }
            }
            catch (IllegalArgumentException iae) {
                Location loc = this.getLocation();
                throw new TypedXMLStreamException(lexical, iae.getMessage(), loc, iae);
            }
        }
        return count2;
    }

    private final boolean checkExpand(TypedArrayDecoder tad) {
        if (tad instanceof ValueDecoderFactory.BaseArrayDecoder) {
            ((ValueDecoderFactory.BaseArrayDecoder)tad).expand();
            return true;
        }
        return false;
    }

    public byte[] getAttributeAsBinary(int index2) throws XMLStreamException {
        return this.getAttributeAsBinary(index2, Base64Variants.getDefaultVariant());
    }

    public byte[] getAttributeAsBinary(int index2, Base64Variant v) throws XMLStreamException {
        String lexical = this.getAttributeValue(index2);
        StringBase64Decoder dec = this._base64Decoder();
        dec.init(v, true, lexical);
        try {
            return dec.decodeCompletely();
        }
        catch (IllegalArgumentException iae) {
            throw new TypedXMLStreamException(lexical, iae.getMessage(), this.getLocation(), iae);
        }
    }

    public Object getFeature(String name) {
        return null;
    }

    public void setFeature(String name, Object value2) {
    }

    public boolean isPropertySupported(String name) {
        return false;
    }

    public boolean setProperty(String name, Object value2) {
        return false;
    }

    public void skipElement() throws XMLStreamException {
        if (this.getEventType() != 1) {
            this.throwNotStartElem(this.getEventType());
        }
        int nesting = 1;
        while (true) {
            int type;
            if ((type = this.next()) == 1) {
                ++nesting;
                continue;
            }
            if (type == 2 && --nesting == 0) break;
        }
    }

    public AttributeInfo getAttributeInfo() throws XMLStreamException {
        if (this.getEventType() != 1) {
            this.throwNotStartElem(this.getEventType());
        }
        return this;
    }

    public DTDInfo getDTDInfo() throws XMLStreamException {
        if (this.getEventType() != 11) {
            return null;
        }
        return this;
    }

    public final LocationInfo getLocationInfo() {
        return this;
    }

    public int getText(Writer w, boolean preserveContents) throws IOException, XMLStreamException {
        char[] cbuf = this.getTextCharacters();
        int start2 = this.getTextStart();
        int len2 = this.getTextLength();
        if (len2 > 0) {
            w.write(cbuf, start2, len2);
        }
        return len2;
    }

    public int getDepth() {
        if (this.getEventType() == 2) {
            return this._depth + 1;
        }
        return this._depth;
    }

    public boolean isEmptyElement() throws XMLStreamException {
        return false;
    }

    public NamespaceContext getNonTransientNamespaceContext() {
        return null;
    }

    public String getPrefixedName() {
        switch (this.getEventType()) {
            case 1: 
            case 2: {
                String prefix2 = this.getPrefix();
                String ln = this.getLocalName();
                if (prefix2 == null || prefix2.length() == 0) {
                    return ln;
                }
                StringBuffer sb = new StringBuffer(ln.length() + 1 + prefix2.length());
                sb.append(prefix2);
                sb.append(':');
                sb.append(ln);
                return sb.toString();
            }
            case 9: {
                return this.getLocalName();
            }
            case 3: {
                return this.getPITarget();
            }
            case 11: {
                return this.getDTDRootName();
            }
        }
        throw new IllegalStateException("Current state not START_ELEMENT, END_ELEMENT, ENTITY_REFERENCE, PROCESSING_INSTRUCTION or DTD");
    }

    public void closeCompletely() throws XMLStreamException {
        this.close();
    }

    public int findAttributeIndex(String nsURI, String localName) {
        if ("".equals(nsURI)) {
            nsURI = null;
        }
        int len2 = this.getAttributeCount();
        for (int i = 0; i < len2; ++i) {
            if (!this.getAttributeLocalName(i).equals(localName)) continue;
            String otherUri = this.getAttributeNamespace(i);
            if (!(nsURI == null ? otherUri == null || otherUri.length() == 0 : nsURI.equals(otherUri))) continue;
            return i;
        }
        return -1;
    }

    public int getIdAttributeIndex() {
        int len2 = this.getAttributeCount();
        for (int i = 0; i < len2; ++i) {
            if (!"ID".equals(this.getAttributeType(i))) continue;
            return i;
        }
        return -1;
    }

    public int getNotationAttributeIndex() {
        int len2 = this.getAttributeCount();
        for (int i = 0; i < len2; ++i) {
            if (!"NOTATION".equals(this.getAttributeType(i))) continue;
            return i;
        }
        return -1;
    }

    public Object getProcessedDTD() {
        return null;
    }

    public String getDTDRootName() {
        return null;
    }

    public String getDTDPublicId() {
        return null;
    }

    public String getDTDSystemId() {
        return null;
    }

    public String getDTDInternalSubset() {
        if (this.getEventType() == 11) {
            return this.getText();
        }
        return null;
    }

    public DTDValidationSchema getProcessedDTDSchema() {
        return null;
    }

    public long getStartingByteOffset() {
        return -1L;
    }

    public long getStartingCharOffset() {
        return 0L;
    }

    public long getEndingByteOffset() throws XMLStreamException {
        return -1L;
    }

    public long getEndingCharOffset() throws XMLStreamException {
        return -1L;
    }

    public XMLStreamLocation2 getStartLocation() {
        return this.getCurrentLocation();
    }

    public XMLStreamLocation2 getCurrentLocation() {
        return new Stax2LocationAdapter(this.getLocation());
    }

    public final XMLStreamLocation2 getEndLocation() throws XMLStreamException {
        return this.getCurrentLocation();
    }

    public XMLValidator validateAgainst(XMLValidationSchema schema) throws XMLStreamException {
        this.throwUnsupported();
        return null;
    }

    public XMLValidator stopValidatingAgainst(XMLValidationSchema schema) throws XMLStreamException {
        this.throwUnsupported();
        return null;
    }

    public XMLValidator stopValidatingAgainst(XMLValidator validator) throws XMLStreamException {
        this.throwUnsupported();
        return null;
    }

    public ValidationProblemHandler setValidationProblemHandler(ValidationProblemHandler h) {
        return null;
    }

    protected ValueDecoderFactory _decoderFactory() {
        if (this._decoderFactory == null) {
            this._decoderFactory = new ValueDecoderFactory();
        }
        return this._decoderFactory;
    }

    protected StringBase64Decoder _base64Decoder() {
        if (this._base64Decoder == null) {
            this._base64Decoder = new StringBase64Decoder();
        }
        return this._base64Decoder;
    }

    protected void throwUnsupported() throws XMLStreamException {
        throw new XMLStreamException("Unsupported method");
    }

    protected void throwNotStartElem(int type) {
        throw new IllegalStateException("Current event (" + Stax2Util.eventTypeDesc(type) + ") not START_ELEMENT");
    }

    protected void throwNotStartElemOrTextual(int type) {
        throw new IllegalStateException("Current event (" + Stax2Util.eventTypeDesc(type) + ") not START_ELEMENT, END_ELEMENT, CHARACTERS or CDATA");
    }

    protected TypedXMLStreamException _constructTypeException(IllegalArgumentException iae, String lexicalValue) {
        XMLStreamLocation2 loc;
        String msg = iae.getMessage();
        if (msg == null) {
            msg = "";
        }
        if ((loc = this.getStartLocation()) == null) {
            return new TypedXMLStreamException(lexicalValue, msg, iae);
        }
        return new TypedXMLStreamException(lexicalValue, msg, loc, iae);
    }

    protected TypedXMLStreamException _constructTypeException(String msg, String lexicalValue) {
        XMLStreamLocation2 loc = this.getStartLocation();
        if (loc == null) {
            return new TypedXMLStreamException(lexicalValue, msg);
        }
        return new TypedXMLStreamException(lexicalValue, msg, loc);
    }
}

