/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.stax2.ri.dom;

import java.io.IOException;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import javax.xml.transform.dom.DOMSource;
import org.codehaus.stax2.AttributeInfo;
import org.codehaus.stax2.DTDInfo;
import org.codehaus.stax2.LocationInfo;
import org.codehaus.stax2.XMLStreamLocation2;
import org.codehaus.stax2.XMLStreamReader2;
import org.codehaus.stax2.ri.EmptyIterator;
import org.codehaus.stax2.ri.EmptyNamespaceContext;
import org.codehaus.stax2.ri.SingletonIterator;
import org.codehaus.stax2.ri.Stax2Util;
import org.codehaus.stax2.ri.typed.StringBase64Decoder;
import org.codehaus.stax2.ri.typed.ValueDecoderFactory;
import org.codehaus.stax2.typed.Base64Variant;
import org.codehaus.stax2.typed.Base64Variants;
import org.codehaus.stax2.typed.TypedArrayDecoder;
import org.codehaus.stax2.typed.TypedValueDecoder;
import org.codehaus.stax2.typed.TypedXMLStreamException;
import org.codehaus.stax2.validation.DTDValidationSchema;
import org.codehaus.stax2.validation.ValidationProblemHandler;
import org.codehaus.stax2.validation.XMLValidationSchema;
import org.codehaus.stax2.validation.XMLValidator;
import org.w3c.dom.Attr;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public abstract class DOMWrappingReader
implements XMLStreamReader2,
AttributeInfo,
DTDInfo,
LocationInfo,
NamespaceContext,
XMLStreamConstants {
    protected static final int INT_SPACE = 32;
    private static final int MASK_GET_TEXT = 6768;
    private static final int MASK_GET_TEXT_XXX = 4208;
    private static final int MASK_GET_ELEMENT_TEXT = 4688;
    protected static final int MASK_TYPED_ACCESS_BINARY = 4178;
    protected static final int ERR_STATE_NOT_START_ELEM = 1;
    protected static final int ERR_STATE_NOT_ELEM = 2;
    protected static final int ERR_STATE_NOT_PI = 3;
    protected static final int ERR_STATE_NOT_TEXTUAL = 4;
    protected static final int ERR_STATE_NOT_TEXTUAL_XXX = 5;
    protected static final int ERR_STATE_NOT_TEXTUAL_OR_ELEM = 6;
    protected static final int ERR_STATE_NO_LOCALNAME = 7;
    protected final String _systemId;
    protected final Node _rootNode;
    protected final boolean _cfgNsAware;
    protected final boolean _coalescing;
    protected boolean _cfgInternNames = false;
    protected boolean _cfgInternNsURIs = false;
    protected int _currEvent = 7;
    protected Node _currNode;
    protected int _depth = 0;
    protected String _coalescedText;
    protected Stax2Util.TextBuffer _textBuffer = new Stax2Util.TextBuffer();
    protected List _attrList = null;
    protected List _nsDeclList = null;
    protected ValueDecoderFactory _decoderFactory;
    protected StringBase64Decoder _base64Decoder = null;

    protected DOMWrappingReader(DOMSource src, boolean nsAware, boolean coalescing) throws XMLStreamException {
        Node treeRoot = src.getNode();
        if (treeRoot == null) {
            throw new IllegalArgumentException("Can not pass null Node for constructing a DOM-based XMLStreamReader");
        }
        this._cfgNsAware = nsAware;
        this._coalescing = coalescing;
        this._systemId = src.getSystemId();
        switch (treeRoot.getNodeType()) {
            case 1: 
            case 9: 
            case 11: {
                break;
            }
            default: {
                throw new XMLStreamException("Can not create an XMLStreamReader for a DOM node of type " + treeRoot.getClass());
            }
        }
        this._rootNode = this._currNode = treeRoot;
    }

    protected void setInternNames(boolean state2) {
        this._cfgInternNames = state2;
    }

    protected void setInternNsURIs(boolean state2) {
        this._cfgInternNsURIs = state2;
    }

    protected abstract void throwStreamException(String var1, Location var2) throws XMLStreamException;

    public String getCharacterEncodingScheme() {
        return null;
    }

    public String getEncoding() {
        return this.getCharacterEncodingScheme();
    }

    public String getVersion() {
        return null;
    }

    public boolean isStandalone() {
        return false;
    }

    public boolean standaloneSet() {
        return false;
    }

    public abstract Object getProperty(String var1);

    public abstract boolean isPropertySupported(String var1);

    public abstract boolean setProperty(String var1, Object var2);

    public int getAttributeCount() {
        if (this._currEvent != 1) {
            this.reportWrongState(1);
        }
        if (this._attrList == null) {
            this._calcNsAndAttrLists(true);
        }
        return this._attrList.size();
    }

    public String getAttributeLocalName(int index2) {
        if (this._currEvent != 1) {
            this.reportWrongState(1);
        }
        if (this._attrList == null) {
            this._calcNsAndAttrLists(true);
        }
        if (index2 >= this._attrList.size() || index2 < 0) {
            this.handleIllegalAttrIndex(index2);
            return null;
        }
        Attr attr = (Attr)this._attrList.get(index2);
        return this._internName(this._safeGetLocalName(attr));
    }

    public QName getAttributeName(int index2) {
        if (this._currEvent != 1) {
            this.reportWrongState(1);
        }
        if (this._attrList == null) {
            this._calcNsAndAttrLists(true);
        }
        if (index2 >= this._attrList.size() || index2 < 0) {
            this.handleIllegalAttrIndex(index2);
            return null;
        }
        Attr attr = (Attr)this._attrList.get(index2);
        return this._constructQName(attr.getNamespaceURI(), this._safeGetLocalName(attr), attr.getPrefix());
    }

    public String getAttributeNamespace(int index2) {
        if (this._currEvent != 1) {
            this.reportWrongState(1);
        }
        if (this._attrList == null) {
            this._calcNsAndAttrLists(true);
        }
        if (index2 >= this._attrList.size() || index2 < 0) {
            this.handleIllegalAttrIndex(index2);
            return null;
        }
        Attr attr = (Attr)this._attrList.get(index2);
        return this._internNsURI(attr.getNamespaceURI());
    }

    public String getAttributePrefix(int index2) {
        if (this._currEvent != 1) {
            this.reportWrongState(1);
        }
        if (this._attrList == null) {
            this._calcNsAndAttrLists(true);
        }
        if (index2 >= this._attrList.size() || index2 < 0) {
            this.handleIllegalAttrIndex(index2);
            return null;
        }
        Attr attr = (Attr)this._attrList.get(index2);
        return this._internName(attr.getPrefix());
    }

    public String getAttributeType(int index2) {
        if (this._currEvent != 1) {
            this.reportWrongState(1);
        }
        if (this._attrList == null) {
            this._calcNsAndAttrLists(true);
        }
        if (index2 >= this._attrList.size() || index2 < 0) {
            this.handleIllegalAttrIndex(index2);
            return null;
        }
        return "CDATA";
    }

    public String getAttributeValue(int index2) {
        if (this._currEvent != 1) {
            this.reportWrongState(1);
        }
        if (this._attrList == null) {
            this._calcNsAndAttrLists(true);
        }
        if (index2 >= this._attrList.size() || index2 < 0) {
            this.handleIllegalAttrIndex(index2);
            return null;
        }
        Attr attr = (Attr)this._attrList.get(index2);
        return attr.getValue();
    }

    public String getAttributeValue(String nsURI, String localName) {
        Attr attr;
        if (this._currEvent != 1) {
            this.reportWrongState(1);
        }
        Element elem2 = (Element)this._currNode;
        NamedNodeMap attrs = elem2.getAttributes();
        if (nsURI != null && nsURI.length() == 0) {
            nsURI = null;
        }
        return (attr = (Attr)attrs.getNamedItemNS(nsURI, localName)) == null ? null : attr.getValue();
    }

    public String getElementText() throws XMLStreamException {
        int type;
        if (this._currEvent != 1) {
            this.reportParseProblem(1);
        }
        if (this._coalescing) {
            int type2;
            String text2 = null;
            while ((type2 = this.next()) != 2) {
                if (type2 == 5 || type2 == 3) continue;
                if ((1 << type2 & 0x1250) == 0) {
                    this.reportParseProblem(4);
                }
                if (text2 == null) {
                    text2 = this.getText();
                    continue;
                }
                text2 = text2 + this.getText();
            }
            return text2 == null ? "" : text2;
        }
        this._textBuffer.reset();
        while ((type = this.next()) != 2) {
            if (type == 5 || type == 3) continue;
            if ((1 << type & 0x1250) == 0) {
                this.reportParseProblem(4);
            }
            this._textBuffer.append(this.getText());
        }
        return this._textBuffer.get();
    }

    public int getEventType() {
        return this._currEvent;
    }

    public String getLocalName() {
        if (this._currEvent == 1 || this._currEvent == 2) {
            return this._internName(this._safeGetLocalName(this._currNode));
        }
        if (this._currEvent != 9) {
            this.reportWrongState(7);
        }
        return this._internName(this._currNode.getNodeName());
    }

    public final Location getLocation() {
        return this.getStartLocation();
    }

    public QName getName() {
        if (this._currEvent != 1 && this._currEvent != 2) {
            this.reportWrongState(1);
        }
        return this._constructQName(this._currNode.getNamespaceURI(), this._safeGetLocalName(this._currNode), this._currNode.getPrefix());
    }

    public NamespaceContext getNamespaceContext() {
        return this;
    }

    public int getNamespaceCount() {
        if (this._currEvent != 1 && this._currEvent != 2) {
            this.reportWrongState(2);
        }
        if (this._nsDeclList == null) {
            if (!this._cfgNsAware) {
                return 0;
            }
            this._calcNsAndAttrLists(this._currEvent == 1);
        }
        return this._nsDeclList.size() / 2;
    }

    public String getNamespacePrefix(int index2) {
        if (this._currEvent != 1 && this._currEvent != 2) {
            this.reportWrongState(2);
        }
        if (this._nsDeclList == null) {
            if (!this._cfgNsAware) {
                this.handleIllegalNsIndex(index2);
            }
            this._calcNsAndAttrLists(this._currEvent == 1);
        }
        if (index2 < 0 || index2 + index2 >= this._nsDeclList.size()) {
            this.handleIllegalNsIndex(index2);
        }
        return (String)this._nsDeclList.get(index2 + index2);
    }

    public String getNamespaceURI() {
        if (this._currEvent != 1 && this._currEvent != 2) {
            this.reportWrongState(2);
        }
        return this._internNsURI(this._currNode.getNamespaceURI());
    }

    public String getNamespaceURI(int index2) {
        if (this._currEvent != 1 && this._currEvent != 2) {
            this.reportWrongState(2);
        }
        if (this._nsDeclList == null) {
            if (!this._cfgNsAware) {
                this.handleIllegalNsIndex(index2);
            }
            this._calcNsAndAttrLists(this._currEvent == 1);
        }
        if (index2 < 0 || index2 + index2 >= this._nsDeclList.size()) {
            this.handleIllegalNsIndex(index2);
        }
        return (String)this._nsDeclList.get(index2 + index2 + 1);
    }

    public String getPIData() {
        if (this._currEvent != 3) {
            this.reportWrongState(3);
        }
        return this._currNode.getNodeValue();
    }

    public String getPITarget() {
        if (this._currEvent != 3) {
            this.reportWrongState(3);
        }
        return this._internName(this._currNode.getNodeName());
    }

    public String getPrefix() {
        if (this._currEvent != 1 && this._currEvent != 2) {
            this.reportWrongState(2);
        }
        return this._internName(this._currNode.getPrefix());
    }

    public String getText() {
        if (this._coalescedText != null) {
            return this._coalescedText;
        }
        if ((1 << this._currEvent & 0x1A70) == 0) {
            this.reportWrongState(4);
        }
        return this._currNode.getNodeValue();
    }

    public char[] getTextCharacters() {
        String text2 = this.getText();
        return text2.toCharArray();
    }

    public int getTextCharacters(int sourceStart, char[] target2, int targetStart, int len2) {
        String text2;
        if ((1 << this._currEvent & 0x1070) == 0) {
            this.reportWrongState(5);
        }
        if (len2 > (text2 = this.getText()).length()) {
            len2 = text2.length();
        }
        text2.getChars(sourceStart, sourceStart + len2, target2, targetStart);
        return len2;
    }

    public int getTextLength() {
        if ((1 << this._currEvent & 0x1070) == 0) {
            this.reportWrongState(5);
        }
        return this.getText().length();
    }

    public int getTextStart() {
        if ((1 << this._currEvent & 0x1070) == 0) {
            this.reportWrongState(5);
        }
        return 0;
    }

    public boolean hasName() {
        return this._currEvent == 1 || this._currEvent == 2;
    }

    public boolean hasNext() {
        return this._currEvent != 8;
    }

    public boolean hasText() {
        return (1 << this._currEvent & 0x1A70) != 0;
    }

    public boolean isAttributeSpecified(int index2) {
        Element elem2;
        Attr attr;
        if (this._currEvent != 1) {
            this.reportWrongState(1);
        }
        if ((attr = (Attr)(elem2 = (Element)this._currNode).getAttributes().item(index2)) == null) {
            this.handleIllegalAttrIndex(index2);
            return false;
        }
        return attr.getSpecified();
    }

    public boolean isCharacters() {
        return this._currEvent == 4;
    }

    public boolean isEndElement() {
        return this._currEvent == 2;
    }

    public boolean isStartElement() {
        return this._currEvent == 1;
    }

    public boolean isWhiteSpace() {
        if (this._currEvent == 4 || this._currEvent == 12) {
            String text2 = this.getText();
            int len2 = text2.length();
            for (int i = 0; i < len2; ++i) {
                if (text2.charAt(i) <= ' ') continue;
                return false;
            }
            return true;
        }
        return this._currEvent == 6;
    }

    public void require(int type, String nsUri, String localName) throws XMLStreamException {
        int curr = this._currEvent;
        if (curr != type) {
            if (curr == 12) {
                curr = 4;
            } else if (curr == 6) {
                curr = 4;
            }
        }
        if (type != curr) {
            this.throwStreamException("Required type " + Stax2Util.eventTypeDesc(type) + ", current type " + Stax2Util.eventTypeDesc(curr));
        }
        if (localName != null) {
            String n;
            if (curr != 1 && curr != 2 && curr != 9) {
                this.throwStreamException("Required a non-null local name, but current token not a START_ELEMENT, END_ELEMENT or ENTITY_REFERENCE (was " + Stax2Util.eventTypeDesc(this._currEvent) + ")");
            }
            if ((n = this.getLocalName()) != localName && !n.equals(localName)) {
                this.throwStreamException("Required local name '" + localName + "'; current local name '" + n + "'.");
            }
        }
        if (nsUri != null) {
            if (curr != 1 && curr != 2) {
                this.throwStreamException("Required non-null NS URI, but current token not a START_ELEMENT or END_ELEMENT (was " + Stax2Util.eventTypeDesc(curr) + ")");
            }
            String uri = this.getNamespaceURI();
            if (nsUri.length() == 0) {
                if (uri != null && uri.length() > 0) {
                    this.throwStreamException("Required empty namespace, instead have '" + uri + "'.");
                }
            } else if (nsUri != uri && !nsUri.equals(uri)) {
                this.throwStreamException("Required namespace '" + nsUri + "'; have '" + uri + "'.");
            }
        }
    }

    public int next() throws XMLStreamException {
        this._coalescedText = null;
        block0 : switch (this._currEvent) {
            case 7: {
                switch (this._currNode.getNodeType()) {
                    case 9: 
                    case 11: {
                        this._currNode = this._currNode.getFirstChild();
                        if (this._currNode != null) break block0;
                        this._currEvent = 8;
                        return 8;
                    }
                    case 1: {
                        this._currEvent = 1;
                        return 1;
                    }
                    default: {
                        throw new XMLStreamException("Internal error: unexpected DOM root node type " + this._currNode.getNodeType() + " for node '" + this._currNode + "'");
                    }
                }
            }
            case 8: {
                throw new NoSuchElementException("Can not call next() after receiving END_DOCUMENT");
            }
            case 1: {
                ++this._depth;
                this._attrList = null;
                Node firstChild = this._currNode.getFirstChild();
                if (firstChild == null) {
                    this._currEvent = 2;
                    return 2;
                }
                this._nsDeclList = null;
                this._currNode = firstChild;
                break;
            }
            case 2: {
                --this._depth;
                this._attrList = null;
                this._nsDeclList = null;
                if (this._currNode == this._rootNode) {
                    this._currEvent = 8;
                    return 8;
                }
            }
            default: {
                Node next2 = this._currNode.getNextSibling();
                if (next2 != null) {
                    this._currNode = next2;
                    break;
                }
                this._currNode = this._currNode.getParentNode();
                short type = this._currNode.getNodeType();
                if (type == 1) {
                    this._currEvent = 2;
                    return 2;
                }
                if (this._currNode != this._rootNode || type != 9 && type != 11) {
                    throw new XMLStreamException("Internal error: non-element parent node (" + type + ") that is not the initial root node");
                }
                this._currEvent = 8;
                return 8;
            }
        }
        switch (this._currNode.getNodeType()) {
            case 4: {
                if (this._coalescing) {
                    this.coalesceText(12);
                    break;
                }
                this._currEvent = 12;
                break;
            }
            case 8: {
                this._currEvent = 5;
                break;
            }
            case 10: {
                this._currEvent = 11;
                break;
            }
            case 1: {
                this._currEvent = 1;
                break;
            }
            case 5: {
                this._currEvent = 9;
                break;
            }
            case 7: {
                this._currEvent = 3;
                break;
            }
            case 3: {
                if (this._coalescing) {
                    this.coalesceText(4);
                    break;
                }
                this._currEvent = 4;
                break;
            }
            case 2: 
            case 6: 
            case 12: {
                throw new XMLStreamException("Internal error: unexpected DOM node type " + this._currNode.getNodeType() + " (attr/entity/notation?), for node '" + this._currNode + "'");
            }
            default: {
                throw new XMLStreamException("Internal error: unrecognized DOM node type " + this._currNode.getNodeType() + ", for node '" + this._currNode + "'");
            }
        }
        return this._currEvent;
    }

    public int nextTag() throws XMLStreamException {
        block5: while (true) {
            int next2 = this.next();
            switch (next2) {
                case 3: 
                case 5: 
                case 6: {
                    continue block5;
                }
                case 4: 
                case 12: {
                    if (this.isWhiteSpace()) continue block5;
                    this.throwStreamException("Received non-all-whitespace CHARACTERS or CDATA event in nextTag().");
                    break;
                }
                case 1: 
                case 2: {
                    return next2;
                }
            }
            this.throwStreamException("Received event " + Stax2Util.eventTypeDesc(next2) + ", instead of START_ELEMENT or END_ELEMENT.");
        }
    }

    public void close() throws XMLStreamException {
    }

    public String getNamespaceURI(String prefix2) {
        return null;
    }

    public String getPrefix(String namespaceURI) {
        return null;
    }

    public Iterator getPrefixes(String namespaceURI) {
        String prefix2 = this.getPrefix(namespaceURI);
        if (prefix2 == null) {
            return EmptyIterator.getInstance();
        }
        return new SingletonIterator(prefix2);
    }

    public boolean getElementAsBoolean() throws XMLStreamException {
        ValueDecoderFactory.BooleanDecoder dec = this._decoderFactory().getBooleanDecoder();
        this.getElementAs(dec);
        return dec.getValue();
    }

    public int getElementAsInt() throws XMLStreamException {
        ValueDecoderFactory.IntDecoder dec = this._decoderFactory().getIntDecoder();
        this.getElementAs(dec);
        return dec.getValue();
    }

    public long getElementAsLong() throws XMLStreamException {
        ValueDecoderFactory.LongDecoder dec = this._decoderFactory().getLongDecoder();
        this.getElementAs(dec);
        return dec.getValue();
    }

    public float getElementAsFloat() throws XMLStreamException {
        ValueDecoderFactory.FloatDecoder dec = this._decoderFactory().getFloatDecoder();
        this.getElementAs(dec);
        return dec.getValue();
    }

    public double getElementAsDouble() throws XMLStreamException {
        ValueDecoderFactory.DoubleDecoder dec = this._decoderFactory().getDoubleDecoder();
        this.getElementAs(dec);
        return dec.getValue();
    }

    public BigInteger getElementAsInteger() throws XMLStreamException {
        ValueDecoderFactory.IntegerDecoder dec = this._decoderFactory().getIntegerDecoder();
        this.getElementAs(dec);
        return dec.getValue();
    }

    public BigDecimal getElementAsDecimal() throws XMLStreamException {
        ValueDecoderFactory.DecimalDecoder dec = this._decoderFactory().getDecimalDecoder();
        this.getElementAs(dec);
        return dec.getValue();
    }

    public QName getElementAsQName() throws XMLStreamException {
        ValueDecoderFactory.QNameDecoder dec = this._decoderFactory().getQNameDecoder(this.getNamespaceContext());
        this.getElementAs(dec);
        return dec.getValue();
    }

    public byte[] getElementAsBinary() throws XMLStreamException {
        return this.getElementAsBinary(Base64Variants.getDefaultVariant());
    }

    public byte[] getElementAsBinary(Base64Variant v) throws XMLStreamException {
        Stax2Util.ByteAggregator aggr = this._base64Decoder().getByteAggregator();
        byte[] buffer = aggr.startAggregation();
        while (true) {
            int readCount;
            int offset2 = 0;
            int len2 = buffer.length;
            do {
                if ((readCount = this.readElementAsBinary(buffer, offset2, len2, v)) < 1) {
                    return aggr.aggregateAll(buffer, offset2);
                }
                offset2 += readCount;
            } while ((len2 -= readCount) > 0);
            buffer = aggr.addFullBlock(buffer);
        }
    }

    public void getElementAs(TypedValueDecoder tvd) throws XMLStreamException {
        String value2 = this.getElementText();
        value2 = Stax2Util.trimSpaces(value2);
        try {
            if (value2 == null) {
                tvd.handleEmptyValue();
            } else {
                tvd.decode(value2);
            }
        }
        catch (IllegalArgumentException iae) {
            throw this._constructTypeException(iae, value2);
        }
    }

    public int readElementAsIntArray(int[] value2, int from2, int length2) throws XMLStreamException {
        return this.readElementAsArray(this._decoderFactory().getIntArrayDecoder(value2, from2, length2));
    }

    public int readElementAsLongArray(long[] value2, int from2, int length2) throws XMLStreamException {
        return this.readElementAsArray(this._decoderFactory().getLongArrayDecoder(value2, from2, length2));
    }

    public int readElementAsFloatArray(float[] value2, int from2, int length2) throws XMLStreamException {
        return this.readElementAsArray(this._decoderFactory().getFloatArrayDecoder(value2, from2, length2));
    }

    public int readElementAsDoubleArray(double[] value2, int from2, int length2) throws XMLStreamException {
        return this.readElementAsArray(this._decoderFactory().getDoubleArrayDecoder(value2, from2, length2));
    }

    public int readElementAsArray(TypedArrayDecoder tad) throws XMLStreamException {
        String string2;
        int ptr;
        if (this._currEvent == 1) {
            Node fc = this._currNode.getFirstChild();
            if (fc == null) {
                this._currEvent = 2;
                return -1;
            }
            this._coalescedText = this.coalesceTypedText(fc);
            this._currEvent = 4;
            this._currNode = this._currNode.getLastChild();
        } else {
            if (this._currEvent != 4 && this._currEvent != 12) {
                if (this._currEvent == 2) {
                    return -1;
                }
                this.reportWrongState(6);
            }
            if (this._coalescedText == null) {
                throw new IllegalStateException("First call to readElementAsArray() must be for a START_ELEMENT, not directly for a textual event");
            }
        }
        String input2 = this._coalescedText;
        int end2 = input2.length();
        int count2 = 0;
        String value2 = null;
        try {
            int len2;
            block4: for (ptr = 0; ptr < end2; ++ptr) {
                while (input2.charAt(ptr) <= ' ') {
                    if (++ptr < end2) continue;
                    break block4;
                }
                int start2 = ptr++;
                while (ptr < end2 && input2.charAt(ptr) > ' ') {
                    ++ptr;
                }
                ++count2;
                value2 = input2.substring(start2, ptr);
                if (!tad.decodeValue(value2)) continue;
                break;
            }
            string2 = (len2 = end2 - ptr) < 1 ? "" : input2.substring(ptr);
        }
        catch (IllegalArgumentException iae) {
            try {
                Location loc = this.getLocation();
                throw new TypedXMLStreamException(value2, iae.getMessage(), loc, iae);
            }
            catch (Throwable throwable2) {
                int len3 = end2 - ptr;
                this._coalescedText = len3 < 1 ? "" : input2.substring(ptr);
                throw throwable2;
            }
        }
        this._coalescedText = string2;
        if (count2 < 1) {
            this._currEvent = 2;
            this._currNode = this._currNode.getParentNode();
            return -1;
        }
        return count2;
    }

    private String coalesceTypedText(Node firstNode) throws XMLStreamException {
        this._textBuffer.reset();
        this._attrList = null;
        block5: for (Node n = firstNode; n != null; n = n.getNextSibling()) {
            switch (n.getNodeType()) {
                case 1: {
                    this.throwStreamException("Element content can not contain child START_ELEMENT when using Typed Access methods");
                }
                case 3: 
                case 4: {
                    this._textBuffer.append(n.getNodeValue());
                    continue block5;
                }
                case 7: 
                case 8: {
                    continue block5;
                }
                default: {
                    this.throwStreamException("Unexpected DOM node type (" + n.getNodeType() + ") when trying to decode Typed content");
                }
            }
        }
        return this._textBuffer.get();
    }

    public int readElementAsBinary(byte[] resultBuffer, int offset2, int maxLength) throws XMLStreamException {
        return this.readElementAsBinary(resultBuffer, offset2, maxLength, Base64Variants.getDefaultVariant());
    }

    public int readElementAsBinary(byte[] resultBuffer, int offset2, int maxLength, Base64Variant v) throws XMLStreamException {
        if (resultBuffer == null) {
            throw new IllegalArgumentException("resultBuffer is null");
        }
        if (offset2 < 0) {
            throw new IllegalArgumentException("Illegal offset (" + offset2 + "), must be [0, " + resultBuffer.length + "[");
        }
        if (maxLength < 1 || offset2 + maxLength > resultBuffer.length) {
            if (maxLength == 0) {
                return 0;
            }
            throw new IllegalArgumentException("Illegal maxLength (" + maxLength + "), has to be positive number, and offset+maxLength can not exceed" + resultBuffer.length);
        }
        StringBase64Decoder dec = this._base64Decoder();
        int type = this._currEvent;
        if ((1 << type & 0x1052) == 0) {
            if (type == 2) {
                if (!dec.hasData()) {
                    return -1;
                }
            } else {
                this.reportWrongState(6);
            }
        }
        if (type == 1) {
            do {
                if ((type = this.next()) != 2) continue;
                return -1;
            } while (type == 5 || type == 3);
            if ((1 << type & 0x1250) == 0) {
                this.reportParseProblem(4);
            }
            dec.init(v, true, this.getText());
        }
        int totalCount = 0;
        while (true) {
            int count2;
            try {
                count2 = dec.decode(resultBuffer, offset2, maxLength);
            }
            catch (IllegalArgumentException iae) {
                throw this._constructTypeException(iae, "");
            }
            offset2 += count2;
            totalCount += count2;
            if ((maxLength -= count2) < 1 || this._currEvent == 2) break;
            while ((type = this.next()) == 5 || type == 3 || type == 6) {
            }
            if (type == 2) {
                int left2 = dec.endOfContent();
                if (left2 < 0) {
                    throw this._constructTypeException("Incomplete base64 triplet at the end of decoded content", "");
                }
                if (left2 <= 0) break;
                continue;
            }
            if ((1 << type & 0x1250) == 0) {
                this.reportParseProblem(4);
            }
            dec.init(v, false, this.getText());
        }
        return totalCount > 0 ? totalCount : -1;
    }

    public int getAttributeIndex(String namespaceURI, String localName) {
        return this.findAttributeIndex(namespaceURI, localName);
    }

    public boolean getAttributeAsBoolean(int index2) throws XMLStreamException {
        ValueDecoderFactory.BooleanDecoder dec = this._decoderFactory().getBooleanDecoder();
        this.getAttributeAs(index2, dec);
        return dec.getValue();
    }

    public int getAttributeAsInt(int index2) throws XMLStreamException {
        ValueDecoderFactory.IntDecoder dec = this._decoderFactory().getIntDecoder();
        this.getAttributeAs(index2, dec);
        return dec.getValue();
    }

    public long getAttributeAsLong(int index2) throws XMLStreamException {
        ValueDecoderFactory.LongDecoder dec = this._decoderFactory().getLongDecoder();
        this.getAttributeAs(index2, dec);
        return dec.getValue();
    }

    public float getAttributeAsFloat(int index2) throws XMLStreamException {
        ValueDecoderFactory.FloatDecoder dec = this._decoderFactory().getFloatDecoder();
        this.getAttributeAs(index2, dec);
        return dec.getValue();
    }

    public double getAttributeAsDouble(int index2) throws XMLStreamException {
        ValueDecoderFactory.DoubleDecoder dec = this._decoderFactory().getDoubleDecoder();
        this.getAttributeAs(index2, dec);
        return dec.getValue();
    }

    public BigInteger getAttributeAsInteger(int index2) throws XMLStreamException {
        ValueDecoderFactory.IntegerDecoder dec = this._decoderFactory().getIntegerDecoder();
        this.getAttributeAs(index2, dec);
        return dec.getValue();
    }

    public BigDecimal getAttributeAsDecimal(int index2) throws XMLStreamException {
        ValueDecoderFactory.DecimalDecoder dec = this._decoderFactory().getDecimalDecoder();
        this.getAttributeAs(index2, dec);
        return dec.getValue();
    }

    public QName getAttributeAsQName(int index2) throws XMLStreamException {
        ValueDecoderFactory.QNameDecoder dec = this._decoderFactory().getQNameDecoder(this.getNamespaceContext());
        this.getAttributeAs(index2, dec);
        return dec.getValue();
    }

    public final void getAttributeAs(int index2, TypedValueDecoder tvd) throws XMLStreamException {
        String value2 = this.getAttributeValue(index2);
        value2 = Stax2Util.trimSpaces(value2);
        try {
            if (value2 == null) {
                tvd.handleEmptyValue();
            } else {
                tvd.decode(value2);
            }
        }
        catch (IllegalArgumentException iae) {
            throw this._constructTypeException(iae, value2);
        }
    }

    public int[] getAttributeAsIntArray(int index2) throws XMLStreamException {
        ValueDecoderFactory.IntArrayDecoder dec = this._decoderFactory().getIntArrayDecoder();
        this._getAttributeAsArray(dec, this.getAttributeValue(index2));
        return dec.getValues();
    }

    public long[] getAttributeAsLongArray(int index2) throws XMLStreamException {
        ValueDecoderFactory.LongArrayDecoder dec = this._decoderFactory().getLongArrayDecoder();
        this._getAttributeAsArray(dec, this.getAttributeValue(index2));
        return dec.getValues();
    }

    public float[] getAttributeAsFloatArray(int index2) throws XMLStreamException {
        ValueDecoderFactory.FloatArrayDecoder dec = this._decoderFactory().getFloatArrayDecoder();
        this._getAttributeAsArray(dec, this.getAttributeValue(index2));
        return dec.getValues();
    }

    public double[] getAttributeAsDoubleArray(int index2) throws XMLStreamException {
        ValueDecoderFactory.DoubleArrayDecoder dec = this._decoderFactory().getDoubleArrayDecoder();
        this._getAttributeAsArray(dec, this.getAttributeValue(index2));
        return dec.getValues();
    }

    public int getAttributeAsArray(int index2, TypedArrayDecoder tad) throws XMLStreamException {
        return this._getAttributeAsArray(tad, this.getAttributeValue(index2));
    }

    protected int _getAttributeAsArray(TypedArrayDecoder tad, String attrValue) throws XMLStreamException {
        int count2;
        block5: {
            int ptr = 0;
            int start2 = 0;
            int end2 = attrValue.length();
            String lexical = null;
            count2 = 0;
            try {
                while (ptr < end2) {
                    while (attrValue.charAt(ptr) <= ' ') {
                        if (++ptr < end2) continue;
                        break block5;
                    }
                    start2 = ptr++;
                    while (ptr < end2 && attrValue.charAt(ptr) > ' ') {
                        ++ptr;
                    }
                    int tokenEnd = ptr++;
                    lexical = attrValue.substring(start2, tokenEnd);
                    ++count2;
                    if (!tad.decodeValue(lexical) || this.checkExpand(tad)) continue;
                    break;
                }
            }
            catch (IllegalArgumentException iae) {
                Location loc = this.getLocation();
                throw new TypedXMLStreamException(lexical, iae.getMessage(), loc, iae);
            }
        }
        return count2;
    }

    private final boolean checkExpand(TypedArrayDecoder tad) {
        if (tad instanceof ValueDecoderFactory.BaseArrayDecoder) {
            ((ValueDecoderFactory.BaseArrayDecoder)tad).expand();
            return true;
        }
        return false;
    }

    public byte[] getAttributeAsBinary(int index2) throws XMLStreamException {
        return this.getAttributeAsBinary(index2, Base64Variants.getDefaultVariant());
    }

    public byte[] getAttributeAsBinary(int index2, Base64Variant v) throws XMLStreamException {
        String lexical = this.getAttributeValue(index2);
        StringBase64Decoder dec = this._base64Decoder();
        dec.init(v, true, lexical);
        try {
            return dec.decodeCompletely();
        }
        catch (IllegalArgumentException iae) {
            throw this._constructTypeException(iae, lexical);
        }
    }

    public Object getFeature(String name) {
        throw new IllegalArgumentException("Unrecognized feature \"" + name + "\"");
    }

    public void setFeature(String name, Object value2) {
        throw new IllegalArgumentException("Unrecognized feature \"" + name + "\"");
    }

    public void skipElement() throws XMLStreamException {
        if (this._currEvent != 1) {
            this.reportWrongState(1);
        }
        int nesting = 1;
        while (true) {
            int type;
            if ((type = this.next()) == 1) {
                ++nesting;
                continue;
            }
            if (type == 2 && --nesting == 0) break;
        }
    }

    public AttributeInfo getAttributeInfo() throws XMLStreamException {
        if (this._currEvent != 1) {
            this.reportWrongState(1);
        }
        return this;
    }

    public int findAttributeIndex(String nsURI, String localName) {
        if (this._currEvent != 1) {
            this.reportWrongState(1);
        }
        Element elem2 = (Element)this._currNode;
        NamedNodeMap attrs = elem2.getAttributes();
        if (nsURI != null && nsURI.length() == 0) {
            nsURI = null;
        }
        int len2 = attrs.getLength();
        for (int i = 0; i < len2; ++i) {
            boolean isEmpty2;
            Node attr = attrs.item(i);
            String ln = this._safeGetLocalName(attr);
            if (!localName.equals(ln)) continue;
            String thisUri = attr.getNamespaceURI();
            boolean bl = isEmpty2 = thisUri == null || thisUri.length() == 0;
            if (!(nsURI == null ? isEmpty2 : !isEmpty2 && nsURI.equals(thisUri))) continue;
            return i;
        }
        return -1;
    }

    public int getIdAttributeIndex() {
        return -1;
    }

    public int getNotationAttributeIndex() {
        return -1;
    }

    public DTDInfo getDTDInfo() throws XMLStreamException {
        if (this._currEvent != 11) {
            return null;
        }
        return this;
    }

    public final LocationInfo getLocationInfo() {
        return this;
    }

    public int getText(Writer w, boolean preserveContents) throws IOException, XMLStreamException {
        String text2 = this.getText();
        w.write(text2);
        return text2.length();
    }

    public int getDepth() {
        return this._depth;
    }

    public boolean isEmptyElement() throws XMLStreamException {
        return false;
    }

    public NamespaceContext getNonTransientNamespaceContext() {
        return EmptyNamespaceContext.getInstance();
    }

    public String getPrefixedName() {
        switch (this._currEvent) {
            case 1: 
            case 2: {
                String prefix2 = this._currNode.getPrefix();
                String ln = this._safeGetLocalName(this._currNode);
                if (prefix2 == null) {
                    return this._internName(ln);
                }
                StringBuffer sb = new StringBuffer(ln.length() + 1 + prefix2.length());
                sb.append(prefix2);
                sb.append(':');
                sb.append(ln);
                return this._internName(sb.toString());
            }
            case 9: {
                return this.getLocalName();
            }
            case 3: {
                return this.getPITarget();
            }
            case 11: {
                return this.getDTDRootName();
            }
        }
        throw new IllegalStateException("Current state (" + Stax2Util.eventTypeDesc(this._currEvent) + ") not START_ELEMENT, END_ELEMENT, ENTITY_REFERENCE, PROCESSING_INSTRUCTION or DTD");
    }

    public void closeCompletely() throws XMLStreamException {
    }

    public Object getProcessedDTD() {
        return null;
    }

    public String getDTDRootName() {
        if (this._currEvent == 11) {
            return this._internName(((DocumentType)this._currNode).getName());
        }
        return null;
    }

    public String getDTDPublicId() {
        if (this._currEvent == 11) {
            return ((DocumentType)this._currNode).getPublicId();
        }
        return null;
    }

    public String getDTDSystemId() {
        if (this._currEvent == 11) {
            return ((DocumentType)this._currNode).getSystemId();
        }
        return null;
    }

    public String getDTDInternalSubset() {
        return null;
    }

    public DTDValidationSchema getProcessedDTDSchema() {
        return null;
    }

    public long getStartingByteOffset() {
        return -1L;
    }

    public long getStartingCharOffset() {
        return 0L;
    }

    public long getEndingByteOffset() throws XMLStreamException {
        return -1L;
    }

    public long getEndingCharOffset() throws XMLStreamException {
        return -1L;
    }

    public XMLStreamLocation2 getStartLocation() {
        return XMLStreamLocation2.NOT_AVAILABLE;
    }

    public XMLStreamLocation2 getCurrentLocation() {
        return XMLStreamLocation2.NOT_AVAILABLE;
    }

    public final XMLStreamLocation2 getEndLocation() throws XMLStreamException {
        return XMLStreamLocation2.NOT_AVAILABLE;
    }

    public XMLValidator validateAgainst(XMLValidationSchema schema) throws XMLStreamException {
        return null;
    }

    public XMLValidator stopValidatingAgainst(XMLValidationSchema schema) throws XMLStreamException {
        return null;
    }

    public XMLValidator stopValidatingAgainst(XMLValidator validator) throws XMLStreamException {
        return null;
    }

    public ValidationProblemHandler setValidationProblemHandler(ValidationProblemHandler h) {
        return null;
    }

    protected void coalesceText(int initialType) {
        short type;
        Node n;
        this._textBuffer.reset();
        this._textBuffer.append(this._currNode.getNodeValue());
        while ((n = this._currNode.getNextSibling()) != null && ((type = n.getNodeType()) == 3 || type == 4)) {
            this._currNode = n;
            this._textBuffer.append(this._currNode.getNodeValue());
        }
        this._coalescedText = this._textBuffer.get();
        this._currEvent = 4;
    }

    private QName _constructQName(String uri, String ln, String prefix2) {
        return new QName(this._internNsURI(uri), this._internName(ln), this._internName(prefix2));
    }

    private void _calcNsAndAttrLists(boolean attrsToo) {
        NamedNodeMap attrsIn = this._currNode.getAttributes();
        int len2 = attrsIn.getLength();
        if (len2 == 0) {
            this._attrList = this._nsDeclList = Collections.EMPTY_LIST;
            return;
        }
        if (!this._cfgNsAware) {
            this._attrList = new ArrayList(len2);
            for (int i = 0; i < len2; ++i) {
                this._attrList.add(attrsIn.item(i));
            }
            this._nsDeclList = Collections.EMPTY_LIST;
            return;
        }
        ArrayList<Node> attrsOut = null;
        ArrayList<String> nsOut = null;
        for (int i = 0; i < len2; ++i) {
            Node attr = attrsIn.item(i);
            String prefix2 = attr.getPrefix();
            if (prefix2 == null || prefix2.length() == 0) {
                if (!"xmlns".equals(attr.getLocalName())) {
                    if (!attrsToo) continue;
                    if (attrsOut == null) {
                        attrsOut = new ArrayList<Node>(len2 - i);
                    }
                    attrsOut.add(attr);
                    continue;
                }
                prefix2 = null;
            } else {
                if (!"xmlns".equals(prefix2)) {
                    if (!attrsToo) continue;
                    if (attrsOut == null) {
                        attrsOut = new ArrayList(len2 - i);
                    }
                    attrsOut.add(attr);
                    continue;
                }
                prefix2 = attr.getLocalName();
            }
            if (nsOut == null) {
                nsOut = new ArrayList<String>((len2 - i) * 2);
            }
            nsOut.add(this._internName(prefix2));
            nsOut.add(this._internNsURI(attr.getNodeValue()));
        }
        this._attrList = attrsOut == null ? Collections.EMPTY_LIST : attrsOut;
        this._nsDeclList = nsOut == null ? Collections.EMPTY_LIST : nsOut;
    }

    private void handleIllegalAttrIndex(int index2) {
        Element elem2 = (Element)this._currNode;
        NamedNodeMap attrs = elem2.getAttributes();
        int len2 = attrs.getLength();
        String msg = "Illegal attribute index " + index2 + "; element <" + elem2.getNodeName() + "> has " + (len2 == 0 ? "no" : String.valueOf(len2)) + " attributes";
        throw new IllegalArgumentException(msg);
    }

    private void handleIllegalNsIndex(int index2) {
        String msg = "Illegal namespace declaration index " + index2 + " (has " + this.getNamespaceCount() + " ns declarations)";
        throw new IllegalArgumentException(msg);
    }

    private String _safeGetLocalName(Node n) {
        String ln = n.getLocalName();
        if (ln == null) {
            ln = n.getNodeName();
        }
        return ln;
    }

    protected void reportWrongState(int errorType) {
        throw new IllegalStateException(this.findErrorDesc(errorType, this._currEvent));
    }

    protected void reportParseProblem(int errorType) throws XMLStreamException {
        this.throwStreamException(this.findErrorDesc(errorType, this._currEvent));
    }

    protected void throwStreamException(String msg) throws XMLStreamException {
        this.throwStreamException(msg, this.getErrorLocation());
    }

    protected Location getErrorLocation() {
        Location loc = this.getCurrentLocation();
        if (loc == null) {
            loc = this.getLocation();
        }
        return loc;
    }

    protected TypedXMLStreamException _constructTypeException(IllegalArgumentException iae, String lexicalValue) {
        XMLStreamLocation2 loc;
        String msg = iae.getMessage();
        if (msg == null) {
            msg = "";
        }
        if ((loc = this.getStartLocation()) == null) {
            return new TypedXMLStreamException(lexicalValue, msg, iae);
        }
        return new TypedXMLStreamException(lexicalValue, msg, loc);
    }

    protected TypedXMLStreamException _constructTypeException(String msg, String lexicalValue) {
        XMLStreamLocation2 loc = this.getStartLocation();
        if (loc == null) {
            return new TypedXMLStreamException(lexicalValue, msg);
        }
        return new TypedXMLStreamException(lexicalValue, msg, loc);
    }

    protected ValueDecoderFactory _decoderFactory() {
        if (this._decoderFactory == null) {
            this._decoderFactory = new ValueDecoderFactory();
        }
        return this._decoderFactory;
    }

    protected StringBase64Decoder _base64Decoder() {
        if (this._base64Decoder == null) {
            this._base64Decoder = new StringBase64Decoder();
        }
        return this._base64Decoder;
    }

    protected String findErrorDesc(int errorType, int currEvent) {
        String evtDesc = Stax2Util.eventTypeDesc(currEvent);
        switch (errorType) {
            case 1: {
                return "Current event " + evtDesc + ", needs to be START_ELEMENT";
            }
            case 2: {
                return "Current event " + evtDesc + ", needs to be START_ELEMENT or END_ELEMENT";
            }
            case 7: {
                return "Current event (" + evtDesc + ") has no local name";
            }
            case 3: {
                return "Current event (" + evtDesc + ") needs to be PROCESSING_INSTRUCTION";
            }
            case 4: {
                return "Current event (" + evtDesc + ") not a textual event";
            }
            case 6: {
                return "Current event (" + evtDesc + " not START_ELEMENT, END_ELEMENT, CHARACTERS or CDATA";
            }
            case 5: {
                return "Current event " + evtDesc + ", needs to be one of CHARACTERS, CDATA, SPACE or COMMENT";
            }
        }
        return "Internal error (unrecognized error type: " + errorType + ")";
    }

    protected String _internName(String name) {
        if (name == null) {
            return "";
        }
        return this._cfgInternNames ? name.intern() : name;
    }

    protected String _internNsURI(String uri) {
        if (uri == null) {
            return "";
        }
        return this._cfgInternNsURIs ? uri.intern() : uri;
    }
}

