/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.stax2.ri.evt;

import java.io.IOException;
import java.io.Writer;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Characters;
import org.codehaus.stax2.XMLStreamWriter2;
import org.codehaus.stax2.ri.evt.BaseEventImpl;

public class CharactersEventImpl
extends BaseEventImpl
implements Characters {
    final String mContent;
    final boolean mIsCData;
    final boolean mIgnorableWS;
    boolean mWhitespaceChecked = false;
    boolean mIsWhitespace = false;

    public CharactersEventImpl(Location loc, String content2, boolean cdata) {
        super(loc);
        this.mContent = content2;
        this.mIsCData = cdata;
        this.mIgnorableWS = false;
    }

    private CharactersEventImpl(Location loc, String content2, boolean cdata, boolean allWS, boolean ignorableWS) {
        super(loc);
        this.mContent = content2;
        this.mIsCData = cdata;
        this.mIsWhitespace = allWS;
        if (allWS) {
            this.mWhitespaceChecked = true;
            this.mIgnorableWS = ignorableWS;
        } else {
            this.mWhitespaceChecked = false;
            this.mIgnorableWS = false;
        }
    }

    public static final CharactersEventImpl createIgnorableWS(Location loc, String content2) {
        return new CharactersEventImpl(loc, content2, false, true, true);
    }

    public static final CharactersEventImpl createNonIgnorableWS(Location loc, String content2) {
        return new CharactersEventImpl(loc, content2, false, true, false);
    }

    public Characters asCharacters() {
        return this;
    }

    public int getEventType() {
        return this.mIsCData ? 12 : 4;
    }

    public boolean isCharacters() {
        return true;
    }

    public void writeAsEncodedUnicode(Writer w) throws XMLStreamException {
        try {
            if (this.mIsCData) {
                w.write("<![CDATA[");
                w.write(this.mContent);
                w.write("]]>");
            } else {
                CharactersEventImpl.writeEscapedXMLText(w, this.mContent);
            }
        }
        catch (IOException ie) {
            this.throwFromIOE(ie);
        }
    }

    public void writeUsing(XMLStreamWriter2 w) throws XMLStreamException {
        if (this.mIsCData) {
            w.writeCData(this.mContent);
        } else {
            w.writeCharacters(this.mContent);
        }
    }

    public String getData() {
        return this.mContent;
    }

    public boolean isCData() {
        return this.mIsCData;
    }

    public boolean isIgnorableWhiteSpace() {
        return this.mIgnorableWS;
    }

    public boolean isWhiteSpace() {
        if (!this.mWhitespaceChecked) {
            int i;
            this.mWhitespaceChecked = true;
            String str = this.mContent;
            int len2 = str.length();
            for (i = 0; i < len2 && str.charAt(i) <= ' '; ++i) {
            }
            this.mIsWhitespace = i == len2;
        }
        return this.mIsWhitespace;
    }

    public void setWhitespaceStatus(boolean status) {
        this.mWhitespaceChecked = true;
        this.mIsWhitespace = status;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (!(o instanceof Characters)) {
            return false;
        }
        Characters other = (Characters)o;
        if (this.mContent.equals(other.getData())) {
            return this.isCData() == other.isCData();
        }
        return false;
    }

    public int hashCode() {
        return this.mContent.hashCode();
    }

    protected static void writeEscapedXMLText(Writer w, String text2) throws IOException {
        int len2 = text2.length();
        for (int i = 0; i < len2; ++i) {
            int start2 = i;
            char c2 = '\u0000';
            while (i < len2 && (c2 = text2.charAt(i)) != '<' && c2 != '&' && (c2 != '>' || i < 2 || text2.charAt(i - 1) != ']' || text2.charAt(i - 2) != ']')) {
                ++i;
            }
            int outLen = i - start2;
            if (outLen > 0) {
                w.write(text2, start2, outLen);
            }
            if (i >= len2) continue;
            if (c2 == '<') {
                w.write("&lt;");
                continue;
            }
            if (c2 == '&') {
                w.write("&amp;");
                continue;
            }
            if (c2 != '>') continue;
            w.write("&gt;");
        }
    }
}

