/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.stax2.ri.evt;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Namespace;
import javax.xml.stream.events.StartElement;
import org.codehaus.stax2.XMLStreamWriter2;
import org.codehaus.stax2.ri.EmptyIterator;
import org.codehaus.stax2.ri.EmptyNamespaceContext;
import org.codehaus.stax2.ri.evt.BaseEventImpl;
import org.codehaus.stax2.ri.evt.MergedNsContext;

public class StartElementEventImpl
extends BaseEventImpl
implements StartElement {
    protected final QName mName;
    protected final ArrayList mAttrs;
    protected final ArrayList mNsDecls;
    protected NamespaceContext mParentNsCtxt;
    NamespaceContext mActualNsCtxt = null;

    protected StartElementEventImpl(Location loc, QName name, ArrayList attrs, ArrayList nsDecls, NamespaceContext parentNsCtxt) {
        super(loc);
        this.mName = name;
        this.mAttrs = attrs;
        this.mNsDecls = nsDecls;
        this.mParentNsCtxt = parentNsCtxt == null ? EmptyNamespaceContext.getInstance() : parentNsCtxt;
    }

    public static StartElementEventImpl construct(Location loc, QName name, Iterator attrIt, Iterator nsDeclIt, NamespaceContext nsCtxt) {
        ArrayList<Namespace> nsDecls;
        ArrayList<Attribute> attrs;
        if (attrIt == null || !attrIt.hasNext()) {
            attrs = null;
        } else {
            attrs = new ArrayList<Attribute>();
            do {
                attrs.add((Attribute)attrIt.next());
            } while (attrIt.hasNext());
        }
        if (nsDeclIt == null || !nsDeclIt.hasNext()) {
            nsDecls = null;
        } else {
            nsDecls = new ArrayList<Namespace>();
            do {
                nsDecls.add((Namespace)nsDeclIt.next());
            } while (nsDeclIt.hasNext());
        }
        return new StartElementEventImpl(loc, name, attrs, nsDecls, nsCtxt);
    }

    public StartElement asStartElement() {
        return this;
    }

    public int getEventType() {
        return 1;
    }

    public boolean isStartElement() {
        return true;
    }

    public void writeAsEncodedUnicode(Writer w) throws XMLStreamException {
        try {
            int i;
            int len2;
            w.write(60);
            String prefix2 = this.mName.getPrefix();
            if (prefix2 != null && prefix2.length() > 0) {
                w.write(prefix2);
                w.write(58);
            }
            w.write(this.mName.getLocalPart());
            if (this.mNsDecls != null) {
                len2 = this.mNsDecls.size();
                for (i = 0; i < len2; ++i) {
                    w.write(32);
                    ((Namespace)this.mNsDecls.get(i)).writeAsEncodedUnicode(w);
                }
            }
            if (this.mAttrs != null) {
                len2 = this.mAttrs.size();
                for (i = 0; i < len2; ++i) {
                    Attribute attr = (Attribute)this.mAttrs.get(i);
                    if (!attr.isSpecified()) continue;
                    w.write(32);
                    attr.writeAsEncodedUnicode(w);
                }
            }
            w.write(62);
        }
        catch (IOException ie) {
            throw new XMLStreamException(ie);
        }
    }

    public void writeUsing(XMLStreamWriter2 sw) throws XMLStreamException {
        int i;
        int len2;
        QName n = this.mName;
        sw.writeStartElement(n.getPrefix(), n.getLocalPart(), n.getNamespaceURI());
        if (this.mNsDecls != null) {
            len2 = this.mNsDecls.size();
            for (i = 0; i < len2; ++i) {
                Namespace ns = (Namespace)this.mNsDecls.get(i);
                String prefix2 = ns.getPrefix();
                String uri = ns.getNamespaceURI();
                if (prefix2 == null || prefix2.length() == 0) {
                    sw.writeDefaultNamespace(uri);
                    continue;
                }
                sw.writeNamespace(prefix2, uri);
            }
        }
        if (this.mAttrs != null) {
            len2 = this.mAttrs.size();
            for (i = 0; i < len2; ++i) {
                Attribute attr = (Attribute)this.mAttrs.get(i);
                if (!attr.isSpecified()) continue;
                QName name = attr.getName();
                sw.writeAttribute(name.getPrefix(), name.getNamespaceURI(), name.getLocalPart(), attr.getValue());
            }
        }
    }

    public final QName getName() {
        return this.mName;
    }

    public Iterator getNamespaces() {
        return this.mNsDecls == null ? EmptyIterator.getInstance() : this.mNsDecls.iterator();
    }

    public NamespaceContext getNamespaceContext() {
        if (this.mActualNsCtxt == null) {
            this.mActualNsCtxt = this.mNsDecls == null ? this.mParentNsCtxt : MergedNsContext.construct(this.mParentNsCtxt, this.mNsDecls);
        }
        return this.mActualNsCtxt;
    }

    public String getNamespaceURI(String prefix2) {
        if (this.mNsDecls != null) {
            if (prefix2 == null) {
                prefix2 = "";
            }
            int len2 = this.mNsDecls.size();
            for (int i = 0; i < len2; ++i) {
                Namespace ns = (Namespace)this.mNsDecls.get(i);
                String thisPrefix = ns.getPrefix();
                if (thisPrefix == null) {
                    thisPrefix = "";
                }
                if (!prefix2.equals(thisPrefix)) continue;
                return ns.getNamespaceURI();
            }
        }
        return null;
    }

    public Attribute getAttributeByName(QName nameIn) {
        if (this.mAttrs == null) {
            return null;
        }
        String ln = nameIn.getLocalPart();
        String uri = nameIn.getNamespaceURI();
        int len2 = this.mAttrs.size();
        boolean notInNs = uri == null || uri.length() == 0;
        for (int i = 0; i < len2; ++i) {
            Attribute attr = (Attribute)this.mAttrs.get(i);
            QName name = attr.getName();
            if (!name.getLocalPart().equals(ln)) continue;
            String thisUri = name.getNamespaceURI();
            if (!(notInNs ? thisUri == null || thisUri.length() == 0 : uri.equals(thisUri))) continue;
            return attr;
        }
        return null;
    }

    public Iterator getAttributes() {
        if (this.mAttrs == null) {
            return EmptyIterator.getInstance();
        }
        return this.mAttrs.iterator();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (!(o instanceof StartElement)) {
            return false;
        }
        StartElement other = (StartElement)o;
        if (this.mName.equals(other.getName()) && StartElementEventImpl.iteratedEquals(this.getNamespaces(), other.getNamespaces())) {
            return StartElementEventImpl.iteratedEquals(this.getAttributes(), other.getAttributes());
        }
        return false;
    }

    public int hashCode() {
        int hash2 = this.mName.hashCode();
        hash2 = StartElementEventImpl.addHash(this.getNamespaces(), hash2);
        hash2 = StartElementEventImpl.addHash(this.getAttributes(), hash2);
        return hash2;
    }
}

