/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.stax2.ri.typed;

public final class NumberUtil {
    public static final int MAX_INT_CLEN = 11;
    public static final int MAX_LONG_CLEN = 21;
    public static final int MAX_DOUBLE_CLEN = 32;
    public static final int MAX_FLOAT_CLEN = 32;
    private static final char NULL_CHAR = '\u0000';
    private static final int MILLION = 1000000;
    private static final int BILLION = 1000000000;
    private static final long TEN_BILLION_L = 10000000000L;
    private static final long THOUSAND_L = 1000L;
    private static final byte BYTE_HYPHEN = 45;
    private static final byte BYTE_1 = 49;
    private static final byte BYTE_2 = 50;
    private static long MIN_INT_AS_LONG = -2147483647L;
    private static long MAX_INT_AS_LONG = Integer.MAX_VALUE;
    static final char[] LEADING_TRIPLETS = new char[4000];
    static final char[] FULL_TRIPLETS = new char[4000];

    public static int writeInt(int value2, char[] buffer, int offset2) {
        boolean hasBillions;
        if (value2 < 0) {
            if (value2 == Integer.MIN_VALUE) {
                return NumberUtil.writeLong((long)value2, buffer, offset2);
            }
            buffer[offset2++] = 45;
            value2 = -value2;
        }
        if (value2 < 1000000) {
            if (value2 < 1000) {
                if (value2 < 10) {
                    buffer[offset2++] = (char)(48 + value2);
                } else {
                    offset2 = NumberUtil.writeLeadingTriplet(value2, buffer, offset2);
                }
            } else {
                int thousands = value2 / 1000;
                offset2 = NumberUtil.writeLeadingTriplet(thousands, buffer, offset2);
                offset2 = NumberUtil.writeFullTriplet(value2 -= thousands * 1000, buffer, offset2);
            }
            return offset2;
        }
        boolean bl = hasBillions = value2 >= 1000000000;
        if (hasBillions) {
            if ((value2 -= 1000000000) >= 1000000000) {
                value2 -= 1000000000;
                buffer[offset2++] = 50;
            } else {
                buffer[offset2++] = 49;
            }
        }
        int newValue = value2 / 1000;
        int ones = value2 - newValue * 1000;
        value2 = newValue;
        int thousands = value2 - (newValue /= 1000) * 1000;
        offset2 = hasBillions ? NumberUtil.writeFullTriplet(newValue, buffer, offset2) : NumberUtil.writeLeadingTriplet(newValue, buffer, offset2);
        offset2 = NumberUtil.writeFullTriplet(thousands, buffer, offset2);
        offset2 = NumberUtil.writeFullTriplet(ones, buffer, offset2);
        return offset2;
    }

    public static int writeInt(int value2, byte[] buffer, int offset2) {
        boolean hasBillions;
        if (value2 < 0) {
            if (value2 == Integer.MIN_VALUE) {
                return NumberUtil.writeLong((long)value2, buffer, offset2);
            }
            buffer[offset2++] = 45;
            value2 = -value2;
        }
        if (value2 < 1000000) {
            if (value2 < 1000) {
                if (value2 < 10) {
                    buffer[offset2++] = (byte)(48 + value2);
                } else {
                    offset2 = NumberUtil.writeLeadingTriplet(value2, buffer, offset2);
                }
            } else {
                int thousands = value2 / 1000;
                offset2 = NumberUtil.writeLeadingTriplet(thousands, buffer, offset2);
                offset2 = NumberUtil.writeFullTriplet(value2 -= thousands * 1000, buffer, offset2);
            }
            return offset2;
        }
        boolean bl = hasBillions = value2 >= 1000000000;
        if (hasBillions) {
            if ((value2 -= 1000000000) >= 1000000000) {
                value2 -= 1000000000;
                buffer[offset2++] = 50;
            } else {
                buffer[offset2++] = 49;
            }
        }
        int newValue = value2 / 1000;
        int ones = value2 - newValue * 1000;
        value2 = newValue;
        int thousands = value2 - (newValue /= 1000) * 1000;
        offset2 = hasBillions ? NumberUtil.writeFullTriplet(newValue, buffer, offset2) : NumberUtil.writeLeadingTriplet(newValue, buffer, offset2);
        offset2 = NumberUtil.writeFullTriplet(thousands, buffer, offset2);
        offset2 = NumberUtil.writeFullTriplet(ones, buffer, offset2);
        return offset2;
    }

    public static int writeLong(long value2, char[] buffer, int offset2) {
        int triplet;
        if (value2 < 0L) {
            if (value2 >= MIN_INT_AS_LONG) {
                return NumberUtil.writeInt((int)value2, buffer, offset2);
            }
            if (value2 == Long.MIN_VALUE) {
                return NumberUtil.getChars(String.valueOf(value2), buffer, offset2);
            }
            buffer[offset2++] = 45;
            value2 = -value2;
        } else if (value2 <= MAX_INT_AS_LONG) {
            return NumberUtil.writeInt((int)value2, buffer, offset2);
        }
        int origOffset = offset2;
        int ptr = offset2 += NumberUtil.calcLongStrLength(value2);
        while (value2 > MAX_INT_AS_LONG) {
            long newValue = value2 / 1000L;
            triplet = (int)(value2 - newValue * 1000L);
            NumberUtil.writeFullTriplet(triplet, buffer, ptr -= 3);
            value2 = newValue;
        }
        int ivalue = (int)value2;
        while (ivalue >= 1000) {
            int newValue = ivalue / 1000;
            triplet = ivalue - newValue * 1000;
            NumberUtil.writeFullTriplet(triplet, buffer, ptr -= 3);
            ivalue = newValue;
        }
        NumberUtil.writeLeadingTriplet(ivalue, buffer, origOffset);
        return offset2;
    }

    public static int writeLong(long value2, byte[] buffer, int offset2) {
        int triplet;
        if (value2 < 0L) {
            if (value2 >= MIN_INT_AS_LONG) {
                return NumberUtil.writeInt((int)value2, buffer, offset2);
            }
            if (value2 == Long.MIN_VALUE) {
                return NumberUtil.getAsciiBytes(String.valueOf(value2), buffer, offset2);
            }
            buffer[offset2++] = 45;
            value2 = -value2;
        } else if (value2 <= MAX_INT_AS_LONG) {
            return NumberUtil.writeInt((int)value2, buffer, offset2);
        }
        int origOffset = offset2;
        int ptr = offset2 += NumberUtil.calcLongStrLength(value2);
        while (value2 > MAX_INT_AS_LONG) {
            long newValue = value2 / 1000L;
            triplet = (int)(value2 - newValue * 1000L);
            NumberUtil.writeFullTriplet(triplet, buffer, ptr -= 3);
            value2 = newValue;
        }
        int ivalue = (int)value2;
        while (ivalue >= 1000) {
            int newValue = ivalue / 1000;
            triplet = ivalue - newValue * 1000;
            NumberUtil.writeFullTriplet(triplet, buffer, ptr -= 3);
            ivalue = newValue;
        }
        NumberUtil.writeLeadingTriplet(ivalue, buffer, origOffset);
        return offset2;
    }

    public static int writeFloat(float value2, char[] buffer, int offset2) {
        return NumberUtil.getChars(String.valueOf(value2), buffer, offset2);
    }

    public static int writeFloat(float value2, byte[] buffer, int offset2) {
        return NumberUtil.getAsciiBytes(String.valueOf(value2), buffer, offset2);
    }

    public static int writeDouble(double value2, char[] buffer, int offset2) {
        return NumberUtil.getChars(String.valueOf(value2), buffer, offset2);
    }

    public static int writeDouble(double value2, byte[] buffer, int offset2) {
        return NumberUtil.getAsciiBytes(String.valueOf(value2), buffer, offset2);
    }

    private static int writeLeadingTriplet(int triplet, char[] buffer, int offset2) {
        char c2;
        int digitOffset = triplet << 2;
        if ((c2 = LEADING_TRIPLETS[digitOffset++]) != '\u0000') {
            buffer[offset2++] = c2;
        }
        if ((c2 = LEADING_TRIPLETS[digitOffset++]) != '\u0000') {
            buffer[offset2++] = c2;
        }
        buffer[offset2++] = LEADING_TRIPLETS[digitOffset];
        return offset2;
    }

    private static int writeLeadingTriplet(int triplet, byte[] buffer, int offset2) {
        char c2;
        int digitOffset = triplet << 2;
        if ((c2 = LEADING_TRIPLETS[digitOffset++]) != '\u0000') {
            buffer[offset2++] = (byte)c2;
        }
        if ((c2 = LEADING_TRIPLETS[digitOffset++]) != '\u0000') {
            buffer[offset2++] = (byte)c2;
        }
        buffer[offset2++] = (byte)LEADING_TRIPLETS[digitOffset];
        return offset2;
    }

    private static int writeFullTriplet(int triplet, char[] buffer, int offset2) {
        int digitOffset = triplet << 2;
        buffer[offset2++] = FULL_TRIPLETS[digitOffset++];
        buffer[offset2++] = FULL_TRIPLETS[digitOffset++];
        buffer[offset2++] = FULL_TRIPLETS[digitOffset];
        return offset2;
    }

    private static int writeFullTriplet(int triplet, byte[] buffer, int offset2) {
        int digitOffset = triplet << 2;
        buffer[offset2++] = (byte)FULL_TRIPLETS[digitOffset++];
        buffer[offset2++] = (byte)FULL_TRIPLETS[digitOffset++];
        buffer[offset2++] = (byte)FULL_TRIPLETS[digitOffset];
        return offset2;
    }

    private static int calcLongStrLength(long posValue) {
        int len2;
        long comp = 10000000000L;
        for (len2 = 10; posValue >= comp && len2 != 19; ++len2) {
            comp = (comp << 3) + (comp << 1);
        }
        return len2;
    }

    private static int getChars(String str, char[] buffer, int ptr) {
        int len2 = str.length();
        str.getChars(0, len2, buffer, ptr);
        return ptr + len2;
    }

    private static int getAsciiBytes(String str, byte[] buffer, int ptr) {
        int len2 = str.length();
        for (int i = 0; i < len2; ++i) {
            buffer[ptr++] = (byte)str.charAt(i);
        }
        return ptr;
    }

    static {
        int ix = 0;
        for (int i1 = 0; i1 < 10; ++i1) {
            char f1 = (char)(48 + i1);
            char l1 = i1 == 0 ? (char)'\u0000' : f1;
            for (int i2 = 0; i2 < 10; ++i2) {
                char f2 = (char)(48 + i2);
                char l2 = i1 == 0 && i2 == 0 ? (char)'\u0000' : f2;
                for (int i3 = 0; i3 < 10; ++i3) {
                    char f3 = (char)(48 + i3);
                    NumberUtil.LEADING_TRIPLETS[ix] = l1;
                    NumberUtil.LEADING_TRIPLETS[ix + 1] = l2;
                    NumberUtil.LEADING_TRIPLETS[ix + 2] = f3;
                    NumberUtil.FULL_TRIPLETS[ix] = f1;
                    NumberUtil.FULL_TRIPLETS[ix + 1] = f2;
                    NumberUtil.FULL_TRIPLETS[ix + 2] = f3;
                    ix += 4;
                }
            }
        }
    }
}

