/*
 * Decompiled with CFR 0.152.
 */
package org.jcp.xml.dsig.internal.dom;

import java.security.InvalidAlgorithmParameterException;
import java.security.spec.AlgorithmParameterSpec;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.dom.DOMCryptoContext;
import javax.xml.crypto.dsig.DigestMethod;
import javax.xml.crypto.dsig.spec.DigestMethodParameterSpec;
import org.jcp.xml.dsig.internal.dom.DOMStructure;
import org.jcp.xml.dsig.internal.dom.DOMUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class DOMDigestMethod
extends DOMStructure
implements DigestMethod {
    static final String SHA384 = "http://www.w3.org/2001/04/xmldsig-more#sha384";
    private DigestMethodParameterSpec params;
    static final /* synthetic */ boolean $assertionsDisabled;

    DOMDigestMethod(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException {
        if (algorithmParameterSpec != null && !(algorithmParameterSpec instanceof DigestMethodParameterSpec)) {
            throw new InvalidAlgorithmParameterException("params must be of type DigestMethodParameterSpec");
        }
        this.checkParams((DigestMethodParameterSpec)algorithmParameterSpec);
        this.params = (DigestMethodParameterSpec)algorithmParameterSpec;
    }

    DOMDigestMethod(Element element2) throws MarshalException {
        Element element3 = DOMUtils.getFirstChildElement(element2);
        if (element3 != null) {
            this.params = this.unmarshalParams(element3);
        }
        try {
            this.checkParams(this.params);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new MarshalException(invalidAlgorithmParameterException);
        }
    }

    static DigestMethod unmarshal(Element element2) throws MarshalException {
        String string2 = DOMUtils.getAttributeValue(element2, "Algorithm");
        if (string2.equals("http://www.w3.org/2000/09/xmldsig#sha1")) {
            return new SHA1(element2);
        }
        if (string2.equals("http://www.w3.org/2001/04/xmlenc#sha256")) {
            return new SHA256(element2);
        }
        if (string2.equals(SHA384)) {
            return new SHA384(element2);
        }
        if (string2.equals("http://www.w3.org/2001/04/xmlenc#sha512")) {
            return new SHA512(element2);
        }
        throw new MarshalException("unsupported DigestMethod algorithm: " + string2);
    }

    void checkParams(DigestMethodParameterSpec digestMethodParameterSpec) throws InvalidAlgorithmParameterException {
        if (digestMethodParameterSpec != null) {
            throw new InvalidAlgorithmParameterException("no parameters should be specified for the " + this.getMessageDigestAlgorithm() + " DigestMethod algorithm");
        }
    }

    public final AlgorithmParameterSpec getParameterSpec() {
        return this.params;
    }

    DigestMethodParameterSpec unmarshalParams(Element element2) throws MarshalException {
        throw new MarshalException("no parameters should be specified for the " + this.getMessageDigestAlgorithm() + " DigestMethod algorithm");
    }

    public void marshal(Node node4, String string2, DOMCryptoContext dOMCryptoContext) throws MarshalException {
        Document document2 = DOMUtils.getOwnerDocument(node4);
        Element element2 = DOMUtils.createElement(document2, "DigestMethod", "http://www.w3.org/2000/09/xmldsig#", string2);
        DOMUtils.setAttribute(element2, "Algorithm", this.getAlgorithm());
        if (this.params != null) {
            this.marshalParams(element2, string2);
        }
        node4.appendChild(element2);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof DigestMethod)) {
            return false;
        }
        DigestMethod digestMethod = (DigestMethod)object;
        boolean bl = this.params == null ? digestMethod.getParameterSpec() == null : this.params.equals(digestMethod.getParameterSpec());
        return this.getAlgorithm().equals(digestMethod.getAlgorithm()) && bl;
    }

    public int hashCode() {
        if (!$assertionsDisabled) {
            throw new AssertionError((Object)"hashCode not designed");
        }
        return 51;
    }

    void marshalParams(Element element2, String string2) throws MarshalException {
        throw new MarshalException("no parameters should be specified for the " + this.getMessageDigestAlgorithm() + " DigestMethod algorithm");
    }

    abstract String getMessageDigestAlgorithm();

    static {
        $assertionsDisabled = !DOMDigestMethod.class.desiredAssertionStatus();
    }

    static final class SHA512
    extends DOMDigestMethod {
        SHA512(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException {
            super(algorithmParameterSpec);
        }

        SHA512(Element element2) throws MarshalException {
            super(element2);
        }

        public String getAlgorithm() {
            return "http://www.w3.org/2001/04/xmlenc#sha512";
        }

        String getMessageDigestAlgorithm() {
            return "SHA-512";
        }
    }

    static final class SHA384
    extends DOMDigestMethod {
        SHA384(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException {
            super(algorithmParameterSpec);
        }

        SHA384(Element element2) throws MarshalException {
            super(element2);
        }

        public String getAlgorithm() {
            return DOMDigestMethod.SHA384;
        }

        String getMessageDigestAlgorithm() {
            return "SHA-384";
        }
    }

    static final class SHA256
    extends DOMDigestMethod {
        SHA256(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException {
            super(algorithmParameterSpec);
        }

        SHA256(Element element2) throws MarshalException {
            super(element2);
        }

        public String getAlgorithm() {
            return "http://www.w3.org/2001/04/xmlenc#sha256";
        }

        String getMessageDigestAlgorithm() {
            return "SHA-256";
        }
    }

    static final class SHA1
    extends DOMDigestMethod {
        SHA1(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException {
            super(algorithmParameterSpec);
        }

        SHA1(Element element2) throws MarshalException {
            super(element2);
        }

        public String getAlgorithm() {
            return "http://www.w3.org/2000/09/xmldsig#sha1";
        }

        String getMessageDigestAlgorithm() {
            return "SHA-1";
        }
    }
}

