/*
 * Decompiled with CFR 0.152.
 */
package org.jcp.xml.dsig.internal.dom;

import java.security.Provider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.XMLCryptoContext;
import javax.xml.crypto.XMLStructure;
import javax.xml.crypto.dom.DOMCryptoContext;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import org.jcp.xml.dsig.internal.dom.DOMKeyName;
import org.jcp.xml.dsig.internal.dom.DOMKeyValue;
import org.jcp.xml.dsig.internal.dom.DOMPGPData;
import org.jcp.xml.dsig.internal.dom.DOMRetrievalMethod;
import org.jcp.xml.dsig.internal.dom.DOMStructure;
import org.jcp.xml.dsig.internal.dom.DOMUtils;
import org.jcp.xml.dsig.internal.dom.DOMX509Data;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class DOMKeyInfo
extends DOMStructure
implements KeyInfo {
    private final String id;
    private final List keyInfoTypes;
    static final /* synthetic */ boolean $assertionsDisabled;

    public DOMKeyInfo(List list2, String string2) {
        if (list2 == null) {
            throw new NullPointerException("content cannot be null");
        }
        ArrayList arrayList = new ArrayList(list2);
        if (arrayList.isEmpty()) {
            throw new IllegalArgumentException("content cannot be empty");
        }
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            if (arrayList.get(i) instanceof XMLStructure) continue;
            throw new ClassCastException("content[" + i + "] is not a valid KeyInfo type");
        }
        this.keyInfoTypes = Collections.unmodifiableList(arrayList);
        this.id = string2;
    }

    public DOMKeyInfo(Element element2, XMLCryptoContext xMLCryptoContext, Provider provider) throws MarshalException {
        this.id = DOMUtils.getAttributeValue(element2, "Id");
        NodeList nodeList = element2.getChildNodes();
        int n = nodeList.getLength();
        if (n < 1) {
            throw new MarshalException("KeyInfo must contain at least one type");
        }
        ArrayList<XMLStructure> arrayList = new ArrayList<XMLStructure>(n);
        for (int i = 0; i < n; ++i) {
            Node node4 = nodeList.item(i);
            if (node4.getNodeType() != 1) continue;
            Element element3 = (Element)node4;
            String string2 = element3.getLocalName();
            if (string2.equals("X509Data")) {
                arrayList.add(new DOMX509Data(element3));
                continue;
            }
            if (string2.equals("KeyName")) {
                arrayList.add(new DOMKeyName(element3));
                continue;
            }
            if (string2.equals("KeyValue")) {
                arrayList.add(new DOMKeyValue(element3));
                continue;
            }
            if (string2.equals("RetrievalMethod")) {
                arrayList.add(new DOMRetrievalMethod(element3, xMLCryptoContext, provider));
                continue;
            }
            if (string2.equals("PGPData")) {
                arrayList.add(new DOMPGPData(element3));
                continue;
            }
            arrayList.add(new javax.xml.crypto.dom.DOMStructure(element3));
        }
        this.keyInfoTypes = Collections.unmodifiableList(arrayList);
    }

    public String getId() {
        return this.id;
    }

    public List getContent() {
        return this.keyInfoTypes;
    }

    public void marshal(XMLStructure xMLStructure, XMLCryptoContext xMLCryptoContext) throws MarshalException {
        if (xMLStructure == null) {
            throw new NullPointerException("parent is null");
        }
        Node node4 = ((javax.xml.crypto.dom.DOMStructure)xMLStructure).getNode();
        String string2 = DOMUtils.getSignaturePrefix(xMLCryptoContext);
        Element element2 = DOMUtils.createElement(DOMUtils.getOwnerDocument(node4), "KeyInfo", "http://www.w3.org/2000/09/xmldsig#", string2);
        if (string2 == null || string2.length() == 0) {
            element2.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "http://www.w3.org/2000/09/xmldsig#");
        } else {
            element2.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + string2, "http://www.w3.org/2000/09/xmldsig#");
        }
        this.marshal(node4, element2, null, string2, (DOMCryptoContext)xMLCryptoContext);
    }

    public void marshal(Node node4, String string2, DOMCryptoContext dOMCryptoContext) throws MarshalException {
        this.marshal(node4, null, string2, dOMCryptoContext);
    }

    public void marshal(Node node4, Node node5, String string2, DOMCryptoContext dOMCryptoContext) throws MarshalException {
        Document document2 = DOMUtils.getOwnerDocument(node4);
        Element element2 = DOMUtils.createElement(document2, "KeyInfo", "http://www.w3.org/2000/09/xmldsig#", string2);
        this.marshal(node4, element2, node5, string2, dOMCryptoContext);
    }

    private void marshal(Node node4, Element element2, Node node5, String string2, DOMCryptoContext dOMCryptoContext) throws MarshalException {
        int n = this.keyInfoTypes.size();
        for (int i = 0; i < n; ++i) {
            XMLStructure xMLStructure = (XMLStructure)this.keyInfoTypes.get(i);
            if (xMLStructure instanceof DOMStructure) {
                ((DOMStructure)xMLStructure).marshal(element2, string2, dOMCryptoContext);
                continue;
            }
            DOMUtils.appendChild(element2, ((javax.xml.crypto.dom.DOMStructure)xMLStructure).getNode());
        }
        DOMUtils.setAttributeID(element2, "Id", this.id);
        node4.insertBefore(element2, node5);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof KeyInfo)) {
            return false;
        }
        KeyInfo keyInfo = (KeyInfo)object;
        boolean bl = this.id == null ? keyInfo.getId() == null : this.id.equals(keyInfo.getId());
        return ((Object)this.keyInfoTypes).equals(keyInfo.getContent()) && bl;
    }

    public int hashCode() {
        if (!$assertionsDisabled) {
            throw new AssertionError((Object)"hashCode not designed");
        }
        return 43;
    }

    static {
        $assertionsDisabled = !DOMKeyInfo.class.desiredAssertionStatus();
    }
}

