/*
 * Decompiled with CFR 0.152.
 */
package org.jcp.xml.dsig.internal.dom;

import java.security.KeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.interfaces.DSAParams;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.DSAPublicKeySpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.RSAPublicKeySpec;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.dom.DOMCryptoContext;
import javax.xml.crypto.dsig.keyinfo.KeyValue;
import org.jcp.xml.dsig.internal.dom.DOMCryptoBinary;
import org.jcp.xml.dsig.internal.dom.DOMStructure;
import org.jcp.xml.dsig.internal.dom.DOMUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class DOMKeyValue
extends DOMStructure
implements KeyValue {
    private KeyFactory rsakf;
    private KeyFactory dsakf;
    private PublicKey publicKey;
    private javax.xml.crypto.dom.DOMStructure externalPublicKey;
    private DOMCryptoBinary p;
    private DOMCryptoBinary q;
    private DOMCryptoBinary g;
    private DOMCryptoBinary y;
    private DOMCryptoBinary j;
    private DOMCryptoBinary seed;
    private DOMCryptoBinary pgen;
    private DOMCryptoBinary modulus;
    private DOMCryptoBinary exponent;
    static final /* synthetic */ boolean $assertionsDisabled;

    public DOMKeyValue(PublicKey publicKey) throws KeyException {
        if (publicKey == null) {
            throw new NullPointerException("key cannot be null");
        }
        this.publicKey = publicKey;
        if (publicKey instanceof DSAPublicKey) {
            DSAPublicKey dSAPublicKey = (DSAPublicKey)publicKey;
            DSAParams dSAParams = dSAPublicKey.getParams();
            this.p = new DOMCryptoBinary(dSAParams.getP());
            this.q = new DOMCryptoBinary(dSAParams.getQ());
            this.g = new DOMCryptoBinary(dSAParams.getG());
            this.y = new DOMCryptoBinary(dSAPublicKey.getY());
        } else if (publicKey instanceof RSAPublicKey) {
            RSAPublicKey rSAPublicKey = (RSAPublicKey)publicKey;
            this.exponent = new DOMCryptoBinary(rSAPublicKey.getPublicExponent());
            this.modulus = new DOMCryptoBinary(rSAPublicKey.getModulus());
        } else {
            throw new KeyException("unsupported key algorithm: " + publicKey.getAlgorithm());
        }
    }

    public DOMKeyValue(Element element2) throws MarshalException {
        Element element3 = DOMUtils.getFirstChildElement(element2);
        if (element3.getLocalName().equals("DSAKeyValue")) {
            this.publicKey = this.unmarshalDSAKeyValue(element3);
        } else if (element3.getLocalName().equals("RSAKeyValue")) {
            this.publicKey = this.unmarshalRSAKeyValue(element3);
        } else {
            this.publicKey = null;
            this.externalPublicKey = new javax.xml.crypto.dom.DOMStructure(element3);
        }
    }

    public PublicKey getPublicKey() throws KeyException {
        if (this.publicKey == null) {
            throw new KeyException("can't convert KeyValue to PublicKey");
        }
        return this.publicKey;
    }

    public void marshal(Node node4, String string2, DOMCryptoContext dOMCryptoContext) throws MarshalException {
        Document document2 = DOMUtils.getOwnerDocument(node4);
        Element element2 = DOMUtils.createElement(document2, "KeyValue", "http://www.w3.org/2000/09/xmldsig#", string2);
        this.marshalPublicKey(element2, document2, string2, dOMCryptoContext);
        node4.appendChild(element2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void marshalPublicKey(Node node4, Document document2, String string2, DOMCryptoContext dOMCryptoContext) throws MarshalException {
        if (this.publicKey != null) {
            if (this.publicKey instanceof DSAPublicKey) {
                this.marshalDSAPublicKey(node4, document2, string2, dOMCryptoContext);
                return;
            } else {
                if (!(this.publicKey instanceof RSAPublicKey)) throw new MarshalException(this.publicKey.getAlgorithm() + " public key algorithm not supported");
                this.marshalRSAPublicKey(node4, document2, string2, dOMCryptoContext);
            }
            return;
        } else {
            node4.appendChild(this.externalPublicKey.getNode());
        }
    }

    private void marshalDSAPublicKey(Node node4, Document document2, String string2, DOMCryptoContext dOMCryptoContext) throws MarshalException {
        Element element2 = DOMUtils.createElement(document2, "DSAKeyValue", "http://www.w3.org/2000/09/xmldsig#", string2);
        Element element3 = DOMUtils.createElement(document2, "P", "http://www.w3.org/2000/09/xmldsig#", string2);
        Element element4 = DOMUtils.createElement(document2, "Q", "http://www.w3.org/2000/09/xmldsig#", string2);
        Element element5 = DOMUtils.createElement(document2, "G", "http://www.w3.org/2000/09/xmldsig#", string2);
        Element element6 = DOMUtils.createElement(document2, "Y", "http://www.w3.org/2000/09/xmldsig#", string2);
        this.p.marshal(element3, string2, dOMCryptoContext);
        this.q.marshal(element4, string2, dOMCryptoContext);
        this.g.marshal(element5, string2, dOMCryptoContext);
        this.y.marshal(element6, string2, dOMCryptoContext);
        element2.appendChild(element3);
        element2.appendChild(element4);
        element2.appendChild(element5);
        element2.appendChild(element6);
        node4.appendChild(element2);
    }

    private void marshalRSAPublicKey(Node node4, Document document2, String string2, DOMCryptoContext dOMCryptoContext) throws MarshalException {
        Element element2 = DOMUtils.createElement(document2, "RSAKeyValue", "http://www.w3.org/2000/09/xmldsig#", string2);
        Element element3 = DOMUtils.createElement(document2, "Modulus", "http://www.w3.org/2000/09/xmldsig#", string2);
        Element element4 = DOMUtils.createElement(document2, "Exponent", "http://www.w3.org/2000/09/xmldsig#", string2);
        this.modulus.marshal(element3, string2, dOMCryptoContext);
        this.exponent.marshal(element4, string2, dOMCryptoContext);
        element2.appendChild(element3);
        element2.appendChild(element4);
        node4.appendChild(element2);
    }

    private DSAPublicKey unmarshalDSAKeyValue(Element element2) throws MarshalException {
        Element element3;
        if (this.dsakf == null) {
            try {
                this.dsakf = KeyFactory.getInstance("DSA");
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new RuntimeException("unable to create DSA KeyFactory: " + noSuchAlgorithmException.getMessage());
            }
        }
        if ((element3 = DOMUtils.getFirstChildElement(element2)).getLocalName().equals("P")) {
            this.p = new DOMCryptoBinary(element3.getFirstChild());
            element3 = DOMUtils.getNextSiblingElement(element3);
            this.q = new DOMCryptoBinary(element3.getFirstChild());
            element3 = DOMUtils.getNextSiblingElement(element3);
        }
        if (element3.getLocalName().equals("G")) {
            this.g = new DOMCryptoBinary(element3.getFirstChild());
            element3 = DOMUtils.getNextSiblingElement(element3);
        }
        this.y = new DOMCryptoBinary(element3.getFirstChild());
        if ((element3 = DOMUtils.getNextSiblingElement(element3)) != null && element3.getLocalName().equals("J")) {
            this.j = new DOMCryptoBinary(element3.getFirstChild());
            element3 = DOMUtils.getNextSiblingElement(element3);
        }
        if (element3 != null) {
            this.seed = new DOMCryptoBinary(element3.getFirstChild());
            element3 = DOMUtils.getNextSiblingElement(element3);
            this.pgen = new DOMCryptoBinary(element3.getFirstChild());
        }
        DSAPublicKeySpec dSAPublicKeySpec = new DSAPublicKeySpec(this.y.getBigNum(), this.p.getBigNum(), this.q.getBigNum(), this.g.getBigNum());
        return (DSAPublicKey)this.generatePublicKey(this.dsakf, dSAPublicKeySpec);
    }

    private RSAPublicKey unmarshalRSAKeyValue(Element element2) throws MarshalException {
        if (this.rsakf == null) {
            try {
                this.rsakf = KeyFactory.getInstance("RSA");
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new RuntimeException("unable to create RSA KeyFactory: " + noSuchAlgorithmException.getMessage());
            }
        }
        Element element3 = DOMUtils.getFirstChildElement(element2);
        this.modulus = new DOMCryptoBinary(element3.getFirstChild());
        Element element4 = DOMUtils.getNextSiblingElement(element3);
        this.exponent = new DOMCryptoBinary(element4.getFirstChild());
        RSAPublicKeySpec rSAPublicKeySpec = new RSAPublicKeySpec(this.modulus.getBigNum(), this.exponent.getBigNum());
        return (RSAPublicKey)this.generatePublicKey(this.rsakf, rSAPublicKeySpec);
    }

    private PublicKey generatePublicKey(KeyFactory keyFactory, KeySpec keySpec) {
        try {
            return keyFactory.generatePublic(keySpec);
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            return null;
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof KeyValue)) {
            return false;
        }
        try {
            KeyValue keyValue = (KeyValue)object;
            if (this.publicKey == null ? keyValue.getPublicKey() != null : !this.publicKey.equals(keyValue.getPublicKey())) {
                return false;
            }
        }
        catch (KeyException keyException) {
            return false;
        }
        return true;
    }

    public int hashCode() {
        if (!$assertionsDisabled) {
            throw new AssertionError((Object)"hashCode not designed");
        }
        return 45;
    }

    static {
        $assertionsDisabled = !DOMKeyValue.class.desiredAssertionStatus();
    }
}

