/*
 * Decompiled with CFR 0.152.
 */
package org.jcp.xml.dsig.internal.dom;

import java.security.Provider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.XMLCryptoContext;
import javax.xml.crypto.dom.DOMCryptoContext;
import javax.xml.crypto.dsig.Manifest;
import javax.xml.crypto.dsig.Reference;
import org.jcp.xml.dsig.internal.dom.DOMReference;
import org.jcp.xml.dsig.internal.dom.DOMStructure;
import org.jcp.xml.dsig.internal.dom.DOMUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class DOMManifest
extends DOMStructure
implements Manifest {
    private final List references;
    private final String id;
    static final /* synthetic */ boolean $assertionsDisabled;

    public DOMManifest(List list2, String string2) {
        if (list2 == null) {
            throw new NullPointerException("references cannot be null");
        }
        ArrayList arrayList = new ArrayList(list2);
        if (arrayList.isEmpty()) {
            throw new IllegalArgumentException("list of references must contain at least one entry");
        }
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            if (arrayList.get(i) instanceof Reference) continue;
            throw new ClassCastException("references[" + i + "] is not a valid type");
        }
        this.references = Collections.unmodifiableList(arrayList);
        this.id = string2;
    }

    public DOMManifest(Element element2, XMLCryptoContext xMLCryptoContext, Provider provider) throws MarshalException {
        this.id = DOMUtils.getAttributeValue(element2, "Id");
        Element element3 = DOMUtils.getFirstChildElement(element2);
        ArrayList<DOMReference> arrayList = new ArrayList<DOMReference>();
        while (element3 != null) {
            arrayList.add(new DOMReference(element3, xMLCryptoContext, provider));
            element3 = DOMUtils.getNextSiblingElement(element3);
        }
        this.references = Collections.unmodifiableList(arrayList);
    }

    public String getId() {
        return this.id;
    }

    public List getReferences() {
        return this.references;
    }

    public void marshal(Node node4, String string2, DOMCryptoContext dOMCryptoContext) throws MarshalException {
        Document document2 = DOMUtils.getOwnerDocument(node4);
        Element element2 = DOMUtils.createElement(document2, "Manifest", "http://www.w3.org/2000/09/xmldsig#", string2);
        DOMUtils.setAttributeID(element2, "Id", this.id);
        int n = this.references.size();
        for (int i = 0; i < n; ++i) {
            DOMReference dOMReference = (DOMReference)this.references.get(i);
            dOMReference.marshal(element2, string2, dOMCryptoContext);
        }
        node4.appendChild(element2);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Manifest)) {
            return false;
        }
        Manifest manifest2 = (Manifest)object;
        boolean bl = this.id == null ? manifest2.getId() == null : this.id.equals(manifest2.getId());
        return bl && ((Object)this.references).equals(manifest2.getReferences());
    }

    public int hashCode() {
        if (!$assertionsDisabled) {
            throw new AssertionError((Object)"hashCode not designed");
        }
        return 46;
    }

    static {
        $assertionsDisabled = !DOMManifest.class.desiredAssertionStatus();
    }
}

