/*
 * Decompiled with CFR 0.152.
 */
package org.jcp.xml.dsig.internal.dom;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.XMLStructure;
import javax.xml.crypto.dom.DOMCryptoContext;
import javax.xml.crypto.dsig.keyinfo.PGPData;
import org.apache.xml.security.exceptions.Base64DecodingException;
import org.apache.xml.security.utils.Base64;
import org.jcp.xml.dsig.internal.dom.DOMStructure;
import org.jcp.xml.dsig.internal.dom.DOMUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class DOMPGPData
extends DOMStructure
implements PGPData {
    private final byte[] keyId;
    private final byte[] keyPacket;
    private final List externalElements;

    public DOMPGPData(byte[] byArray, List list2) {
        if (byArray == null) {
            throw new NullPointerException("keyPacket cannot be null");
        }
        if (list2 == null || list2.isEmpty()) {
            this.externalElements = Collections.EMPTY_LIST;
        } else {
            ArrayList arrayList = new ArrayList(list2);
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                if (arrayList.get(i) instanceof XMLStructure) continue;
                throw new ClassCastException("other[" + i + "] is not a valid PGPData type");
            }
            this.externalElements = Collections.unmodifiableList(arrayList);
        }
        this.keyPacket = (byte[])byArray.clone();
        this.checkKeyPacket(byArray);
        this.keyId = null;
    }

    public DOMPGPData(byte[] byArray, byte[] byArray2, List list2) {
        if (byArray == null) {
            throw new NullPointerException("keyId cannot be null");
        }
        if (byArray.length != 8) {
            throw new IllegalArgumentException("keyId must be 8 bytes long");
        }
        if (list2 == null || list2.isEmpty()) {
            this.externalElements = Collections.EMPTY_LIST;
        } else {
            ArrayList arrayList = new ArrayList(list2);
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                if (arrayList.get(i) instanceof XMLStructure) continue;
                throw new ClassCastException("other[" + i + "] is not a valid PGPData type");
            }
            this.externalElements = Collections.unmodifiableList(arrayList);
        }
        this.keyId = (byte[])byArray.clone();
        byte[] byArray3 = this.keyPacket = byArray2 == null ? null : (byte[])byArray2.clone();
        if (byArray2 != null) {
            this.checkKeyPacket(byArray2);
        }
    }

    public DOMPGPData(Element element2) throws MarshalException {
        byte[] byArray = null;
        byte[] byArray2 = null;
        NodeList nodeList = element2.getChildNodes();
        int n = nodeList.getLength();
        ArrayList<javax.xml.crypto.dom.DOMStructure> arrayList = new ArrayList<javax.xml.crypto.dom.DOMStructure>(n);
        for (int i = 0; i < n; ++i) {
            Node node4 = nodeList.item(i);
            if (node4.getNodeType() != 1) continue;
            Element element3 = (Element)node4;
            String string2 = element3.getLocalName();
            try {
                if (string2.equals("PGPKeyID")) {
                    byArray = Base64.decode(element3);
                    continue;
                }
                if (string2.equals("PGPKeyPacket")) {
                    byArray2 = Base64.decode(element3);
                    continue;
                }
                arrayList.add(new javax.xml.crypto.dom.DOMStructure(element3));
                continue;
            }
            catch (Base64DecodingException base64DecodingException) {
                throw new MarshalException(base64DecodingException);
            }
        }
        this.keyId = byArray;
        this.keyPacket = byArray2;
        this.externalElements = Collections.unmodifiableList(arrayList);
    }

    public byte[] getKeyId() {
        return this.keyId == null ? null : (byte[])this.keyId.clone();
    }

    public byte[] getKeyPacket() {
        return this.keyPacket == null ? null : (byte[])this.keyPacket.clone();
    }

    public List getExternalElements() {
        return this.externalElements;
    }

    public void marshal(Node node4, String string2, DOMCryptoContext dOMCryptoContext) throws MarshalException {
        Element element2;
        Document document2 = DOMUtils.getOwnerDocument(node4);
        Element element3 = DOMUtils.createElement(document2, "PGPData", "http://www.w3.org/2000/09/xmldsig#", string2);
        if (this.keyId != null) {
            element2 = DOMUtils.createElement(document2, "PGPKeyID", "http://www.w3.org/2000/09/xmldsig#", string2);
            element2.appendChild(document2.createTextNode(Base64.encode(this.keyId)));
            element3.appendChild(element2);
        }
        if (this.keyPacket != null) {
            element2 = DOMUtils.createElement(document2, "PGPKeyPacket", "http://www.w3.org/2000/09/xmldsig#", string2);
            element2.appendChild(document2.createTextNode(Base64.encode(this.keyPacket)));
            element3.appendChild(element2);
        }
        int n = this.externalElements.size();
        for (int i = 0; i < n; ++i) {
            DOMUtils.appendChild(element3, ((javax.xml.crypto.dom.DOMStructure)this.externalElements.get(i)).getNode());
        }
        node4.appendChild(element3);
    }

    private void checkKeyPacket(byte[] byArray) {
        if (byArray.length < 3) {
            throw new IllegalArgumentException("keypacket must be at least 3 bytes long");
        }
        byte by2 = byArray[0];
        if ((by2 & 0x80) != 128) {
            throw new IllegalArgumentException("keypacket tag is invalid: bit 7 is not set");
        }
        if ((by2 & 0x40) != 64) {
            throw new IllegalArgumentException("old keypacket tag format is unsupported");
        }
        if ((by2 & 6) != 6 && (by2 & 0xE) != 14 && (by2 & 5) != 5 && (by2 & 7) != 7) {
            throw new IllegalArgumentException("keypacket tag is invalid: must be 6, 14, 5, or 7");
        }
    }
}

