/*
 * Decompiled with CFR 0.152.
 */
package org.jcp.xml.dsig.internal.dom;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.crypto.Data;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.NodeSetData;
import javax.xml.crypto.OctetStreamData;
import javax.xml.crypto.URIDereferencer;
import javax.xml.crypto.URIReferenceException;
import javax.xml.crypto.XMLCryptoContext;
import javax.xml.crypto.dom.DOMCryptoContext;
import javax.xml.crypto.dom.DOMURIReference;
import javax.xml.crypto.dsig.DigestMethod;
import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.Transform;
import javax.xml.crypto.dsig.TransformException;
import javax.xml.crypto.dsig.TransformService;
import javax.xml.crypto.dsig.XMLSignContext;
import javax.xml.crypto.dsig.XMLSignatureException;
import javax.xml.crypto.dsig.XMLValidateContext;
import org.apache.xml.security.exceptions.Base64DecodingException;
import org.apache.xml.security.signature.XMLSignatureInput;
import org.apache.xml.security.utils.Base64;
import org.apache.xml.security.utils.UnsyncBufferedOutputStream;
import org.jcp.xml.dsig.internal.DigesterOutputStream;
import org.jcp.xml.dsig.internal.dom.ApacheData;
import org.jcp.xml.dsig.internal.dom.DOMDigestMethod;
import org.jcp.xml.dsig.internal.dom.DOMStructure;
import org.jcp.xml.dsig.internal.dom.DOMSubTreeData;
import org.jcp.xml.dsig.internal.dom.DOMTransform;
import org.jcp.xml.dsig.internal.dom.DOMURIDereferencer;
import org.jcp.xml.dsig.internal.dom.DOMUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class DOMReference
extends DOMStructure
implements Reference,
DOMURIReference {
    private static boolean useC14N11;
    private static Logger log;
    private final DigestMethod digestMethod;
    private final String id;
    private final List transforms;
    private List allTransforms;
    private final Data appliedTransformData;
    private Attr here;
    private final String uri;
    private final String type;
    private byte[] digestValue;
    private byte[] calcDigestValue;
    private Element refElem;
    private boolean digested = false;
    private boolean validated = false;
    private boolean validationStatus;
    private Data derefData;
    private InputStream dis;
    private MessageDigest md;
    private Provider provider;
    static final /* synthetic */ boolean $assertionsDisabled;

    public DOMReference(String string2, String string3, DigestMethod digestMethod, List list2, String string4, Provider provider) {
        this(string2, string3, digestMethod, null, null, list2, string4, null, provider);
    }

    public DOMReference(String string2, String string3, DigestMethod digestMethod, List list2, Data data2, List list3, String string4, Provider provider) {
        this(string2, string3, digestMethod, list2, data2, list3, string4, null, provider);
    }

    public DOMReference(String string2, String string3, DigestMethod digestMethod, List list2, Data data2, List list3, String string4, byte[] byArray, Provider provider) {
        int n;
        int n2;
        ArrayList arrayList;
        if (digestMethod == null) {
            throw new NullPointerException("DigestMethod must be non-null");
        }
        this.allTransforms = new ArrayList();
        if (list2 != null) {
            arrayList = new ArrayList(list2);
            n2 = arrayList.size();
            for (n = 0; n < n2; ++n) {
                if (arrayList.get(n) instanceof Transform) continue;
                throw new ClassCastException("appliedTransforms[" + n + "] is not a valid type");
            }
            this.allTransforms = arrayList;
        }
        if (list3 == null) {
            this.transforms = Collections.EMPTY_LIST;
        } else {
            arrayList = new ArrayList(list3);
            n2 = arrayList.size();
            for (n = 0; n < n2; ++n) {
                if (arrayList.get(n) instanceof Transform) continue;
                throw new ClassCastException("transforms[" + n + "] is not a valid type");
            }
            this.transforms = arrayList;
            this.allTransforms.addAll(arrayList);
        }
        this.digestMethod = digestMethod;
        this.uri = string2;
        if (string2 != null && !string2.equals("")) {
            try {
                new URI(string2);
            }
            catch (URISyntaxException uRISyntaxException) {
                throw new IllegalArgumentException(uRISyntaxException.getMessage());
            }
        }
        this.type = string3;
        this.id = string4;
        if (byArray != null) {
            this.digestValue = (byte[])byArray.clone();
            this.digested = true;
        }
        this.appliedTransformData = data2;
        this.provider = provider;
    }

    public DOMReference(Element element2, XMLCryptoContext xMLCryptoContext, Provider provider) throws MarshalException {
        Element element3;
        Element element4 = DOMUtils.getFirstChildElement(element2);
        ArrayList<DOMTransform> arrayList = new ArrayList<DOMTransform>(5);
        if (element4.getLocalName().equals("Transforms")) {
            element3 = DOMUtils.getFirstChildElement(element4);
            while (element3 != null) {
                arrayList.add(new DOMTransform(element3, xMLCryptoContext, provider));
                element3 = DOMUtils.getNextSiblingElement(element3);
            }
            element4 = DOMUtils.getNextSiblingElement(element4);
        }
        element3 = element4;
        this.digestMethod = DOMDigestMethod.unmarshal(element3);
        try {
            Element element5 = DOMUtils.getNextSiblingElement(element3);
            this.digestValue = Base64.decode(element5);
        }
        catch (Base64DecodingException base64DecodingException) {
            throw new MarshalException(base64DecodingException);
        }
        this.uri = DOMUtils.getAttributeValue(element2, "URI");
        this.id = DOMUtils.getAttributeValue(element2, "Id");
        this.type = DOMUtils.getAttributeValue(element2, "Type");
        this.here = element2.getAttributeNodeNS(null, "URI");
        this.refElem = element2;
        this.transforms = arrayList;
        this.allTransforms = arrayList;
        this.appliedTransformData = null;
        this.provider = provider;
    }

    public DigestMethod getDigestMethod() {
        return this.digestMethod;
    }

    public String getId() {
        return this.id;
    }

    public String getURI() {
        return this.uri;
    }

    public String getType() {
        return this.type;
    }

    public List getTransforms() {
        return Collections.unmodifiableList(this.allTransforms);
    }

    public byte[] getDigestValue() {
        return this.digestValue == null ? null : (byte[])this.digestValue.clone();
    }

    public byte[] getCalculatedDigestValue() {
        return this.calcDigestValue == null ? null : (byte[])this.calcDigestValue.clone();
    }

    public void marshal(Node node4, String string2, DOMCryptoContext dOMCryptoContext) throws MarshalException {
        Element element2;
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Marshalling Reference");
        }
        Document document2 = DOMUtils.getOwnerDocument(node4);
        this.refElem = DOMUtils.createElement(document2, "Reference", "http://www.w3.org/2000/09/xmldsig#", string2);
        DOMUtils.setAttributeID(this.refElem, "Id", this.id);
        DOMUtils.setAttribute(this.refElem, "URI", this.uri);
        DOMUtils.setAttribute(this.refElem, "Type", this.type);
        if (!this.allTransforms.isEmpty()) {
            element2 = DOMUtils.createElement(document2, "Transforms", "http://www.w3.org/2000/09/xmldsig#", string2);
            this.refElem.appendChild(element2);
            int n = this.allTransforms.size();
            for (int i = 0; i < n; ++i) {
                DOMStructure dOMStructure = (DOMStructure)this.allTransforms.get(i);
                dOMStructure.marshal(element2, string2, dOMCryptoContext);
            }
        }
        ((DOMDigestMethod)this.digestMethod).marshal(this.refElem, string2, dOMCryptoContext);
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Adding digestValueElem");
        }
        element2 = DOMUtils.createElement(document2, "DigestValue", "http://www.w3.org/2000/09/xmldsig#", string2);
        if (this.digestValue != null) {
            element2.appendChild(document2.createTextNode(Base64.encode(this.digestValue)));
        }
        this.refElem.appendChild(element2);
        node4.appendChild(this.refElem);
        this.here = this.refElem.getAttributeNodeNS(null, "URI");
    }

    public void digest(XMLSignContext xMLSignContext) throws XMLSignatureException {
        Element element2;
        Data data2 = null;
        data2 = this.appliedTransformData == null ? this.dereference(xMLSignContext) : this.appliedTransformData;
        this.digestValue = this.transform(data2, xMLSignContext);
        String string2 = Base64.encode(this.digestValue);
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Reference object uri = " + this.uri);
        }
        if ((element2 = DOMUtils.getLastChildElement(this.refElem)) == null) {
            throw new XMLSignatureException("DigestValue element expected");
        }
        DOMUtils.removeAllChildren(element2);
        element2.appendChild(this.refElem.getOwnerDocument().createTextNode(string2));
        this.digested = true;
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Reference digesting completed");
        }
    }

    public boolean validate(XMLValidateContext xMLValidateContext) throws XMLSignatureException {
        if (xMLValidateContext == null) {
            throw new NullPointerException("validateContext cannot be null");
        }
        if (this.validated) {
            return this.validationStatus;
        }
        Data data2 = this.dereference(xMLValidateContext);
        this.calcDigestValue = this.transform(data2, xMLValidateContext);
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Expected digest: " + Base64.encode(this.digestValue));
            log.log(Level.FINE, "Actual digest: " + Base64.encode(this.calcDigestValue));
        }
        this.validationStatus = Arrays.equals(this.digestValue, this.calcDigestValue);
        this.validated = true;
        return this.validationStatus;
    }

    public Data getDereferencedData() {
        return this.derefData;
    }

    public InputStream getDigestInputStream() {
        return this.dis;
    }

    private Data dereference(XMLCryptoContext xMLCryptoContext) throws XMLSignatureException {
        Data data2 = null;
        URIDereferencer uRIDereferencer = xMLCryptoContext.getURIDereferencer();
        if (uRIDereferencer == null) {
            uRIDereferencer = DOMURIDereferencer.INSTANCE;
        }
        try {
            data2 = uRIDereferencer.dereference(this, xMLCryptoContext);
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "URIDereferencer class name: " + uRIDereferencer.getClass().getName());
                log.log(Level.FINE, "Data class name: " + data2.getClass().getName());
            }
        }
        catch (URIReferenceException uRIReferenceException) {
            throw new XMLSignatureException(uRIReferenceException);
        }
        return data2;
    }

    private byte[] transform(Data data2, XMLCryptoContext xMLCryptoContext) throws XMLSignatureException {
        Object object;
        DigesterOutputStream digesterOutputStream;
        if (this.md == null) {
            try {
                this.md = MessageDigest.getInstance(((DOMDigestMethod)this.digestMethod).getMessageDigestAlgorithm());
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new XMLSignatureException(noSuchAlgorithmException);
            }
        }
        this.md.reset();
        Boolean bl = (Boolean)xMLCryptoContext.getProperty("javax.xml.crypto.dsig.cacheReference");
        if (bl != null && bl.booleanValue()) {
            this.derefData = DOMReference.copyDerefData(data2);
            digesterOutputStream = new DigesterOutputStream(this.md, true);
        } else {
            digesterOutputStream = new DigesterOutputStream(this.md);
        }
        UnsyncBufferedOutputStream unsyncBufferedOutputStream = new UnsyncBufferedOutputStream(digesterOutputStream);
        Data data3 = data2;
        int n = this.transforms.size();
        for (int i = 0; i < n; ++i) {
            object = (DOMTransform)this.transforms.get(i);
            try {
                if (i < n - 1) {
                    data3 = ((DOMTransform)object).transform(data3, xMLCryptoContext);
                    continue;
                }
                data3 = ((DOMTransform)object).transform(data3, xMLCryptoContext, unsyncBufferedOutputStream);
                continue;
            }
            catch (TransformException transformException) {
                throw new XMLSignatureException(transformException);
            }
        }
        try {
            if (data3 != null) {
                XMLSignatureInput xMLSignatureInput;
                Object object2;
                n = useC14N11 ? 1 : 0;
                object = "http://www.w3.org/TR/2001/REC-xml-c14n-20010315";
                if (xMLCryptoContext instanceof XMLSignContext) {
                    if (n == 0) {
                        object2 = (Boolean)xMLCryptoContext.getProperty("org.apache.xml.security.useC14N11");
                        int n2 = n = object2 != null && ((Boolean)object2).booleanValue() ? 1 : 0;
                        if (n != 0) {
                            object = "http://www.w3.org/2006/12/xml-c14n11";
                        }
                    } else {
                        object = "http://www.w3.org/2006/12/xml-c14n11";
                    }
                }
                if (data3 instanceof ApacheData) {
                    xMLSignatureInput = ((ApacheData)data3).getXMLSignatureInput();
                } else if (data3 instanceof OctetStreamData) {
                    xMLSignatureInput = new XMLSignatureInput(((OctetStreamData)data3).getOctetStream());
                } else if (data3 instanceof NodeSetData) {
                    object2 = null;
                    try {
                        object2 = TransformService.getInstance((String)object, "DOM");
                    }
                    catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                        object2 = TransformService.getInstance((String)object, "DOM", this.provider);
                    }
                    data3 = object2.transform(data3, xMLCryptoContext);
                    xMLSignatureInput = new XMLSignatureInput(((OctetStreamData)data3).getOctetStream());
                } else {
                    throw new XMLSignatureException("unrecognized Data type");
                }
                if (xMLCryptoContext instanceof XMLSignContext && n != 0 && !xMLSignatureInput.isOctetStream() && !xMLSignatureInput.isOutputStreamSet()) {
                    object2 = new DOMTransform(TransformService.getInstance((String)object, "DOM"));
                    Element element2 = null;
                    String string2 = DOMUtils.getSignaturePrefix(xMLCryptoContext);
                    if (this.allTransforms.isEmpty()) {
                        element2 = DOMUtils.createElement(this.refElem.getOwnerDocument(), "Transforms", "http://www.w3.org/2000/09/xmldsig#", string2);
                        this.refElem.insertBefore(element2, DOMUtils.getFirstChildElement(this.refElem));
                    } else {
                        element2 = DOMUtils.getFirstChildElement(this.refElem);
                    }
                    ((DOMTransform)object2).marshal(element2, string2, (DOMCryptoContext)xMLCryptoContext);
                    this.allTransforms.add(object2);
                    xMLSignatureInput.updateOutputStream(unsyncBufferedOutputStream, true);
                } else {
                    xMLSignatureInput.updateOutputStream(unsyncBufferedOutputStream);
                }
            }
            ((OutputStream)unsyncBufferedOutputStream).flush();
            if (bl != null && bl.booleanValue()) {
                this.dis = digesterOutputStream.getInputStream();
            }
            return digesterOutputStream.getDigestValue();
        }
        catch (Exception exception) {
            throw new XMLSignatureException(exception);
        }
    }

    public Node getHere() {
        return this.here;
    }

    public boolean equals(Object object) {
        boolean bl;
        boolean bl2;
        if (this == object) {
            return true;
        }
        if (!(object instanceof Reference)) {
            return false;
        }
        Reference reference = (Reference)object;
        boolean bl3 = this.id == null ? reference.getId() == null : (bl2 = this.id.equals(reference.getId()));
        boolean bl4 = this.uri == null ? reference.getURI() == null : (bl = this.uri.equals(reference.getURI()));
        boolean bl5 = this.type == null ? reference.getType() == null : this.type.equals(reference.getType());
        boolean bl6 = Arrays.equals(this.digestValue, reference.getDigestValue());
        return this.digestMethod.equals(reference.getDigestMethod()) && bl2 && bl && bl5 && ((Object)this.allTransforms).equals(reference.getTransforms());
    }

    public int hashCode() {
        if (!$assertionsDisabled) {
            throw new AssertionError((Object)"hashCode not designed");
        }
        return 47;
    }

    boolean isDigested() {
        return this.digested;
    }

    private static Data copyDerefData(Data data2) {
        if (data2 instanceof ApacheData) {
            ApacheData apacheData = (ApacheData)data2;
            XMLSignatureInput xMLSignatureInput = apacheData.getXMLSignatureInput();
            if (xMLSignatureInput.isNodeSet()) {
                try {
                    final Set set2 = xMLSignatureInput.getNodeSet();
                    return new NodeSetData(){

                        public Iterator iterator() {
                            return set2.iterator();
                        }
                    };
                }
                catch (Exception exception) {
                    log.log(Level.WARNING, "cannot cache dereferenced data: " + exception);
                    return null;
                }
            }
            if (xMLSignatureInput.isElement()) {
                return new DOMSubTreeData(xMLSignatureInput.getSubNode(), xMLSignatureInput.isExcludeComments());
            }
            if (xMLSignatureInput.isOctetStream() || xMLSignatureInput.isByteArray()) {
                try {
                    return new OctetStreamData(xMLSignatureInput.getOctetStream(), xMLSignatureInput.getSourceURI(), xMLSignatureInput.getMIMEType());
                }
                catch (IOException iOException) {
                    log.log(Level.WARNING, "cannot cache dereferenced data: " + iOException);
                    return null;
                }
            }
        }
        return data2;
    }

    static {
        $assertionsDisabled = !DOMReference.class.desiredAssertionStatus();
        useC14N11 = false;
        try {
            useC14N11 = Boolean.getBoolean("org.apache.xml.security.useC14N11");
        }
        catch (Exception exception) {
            // empty catch block
        }
        log = Logger.getLogger("org.jcp.xml.dsig.internal.dom");
    }
}

