/*
 * Decompiled with CFR 0.152.
 */
package org.jcp.xml.dsig.internal.dom;

import java.io.ByteArrayInputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.Provider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.crypto.Data;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.URIDereferencer;
import javax.xml.crypto.URIReferenceException;
import javax.xml.crypto.XMLCryptoContext;
import javax.xml.crypto.XMLStructure;
import javax.xml.crypto.dom.DOMCryptoContext;
import javax.xml.crypto.dom.DOMURIReference;
import javax.xml.crypto.dsig.Transform;
import javax.xml.crypto.dsig.keyinfo.RetrievalMethod;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.jcp.xml.dsig.internal.dom.ApacheData;
import org.jcp.xml.dsig.internal.dom.DOMStructure;
import org.jcp.xml.dsig.internal.dom.DOMTransform;
import org.jcp.xml.dsig.internal.dom.DOMURIDereferencer;
import org.jcp.xml.dsig.internal.dom.DOMUtils;
import org.jcp.xml.dsig.internal.dom.DOMX509Data;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class DOMRetrievalMethod
extends DOMStructure
implements RetrievalMethod,
DOMURIReference {
    private final List transforms;
    private String uri;
    private String type;
    private Attr here;
    static final /* synthetic */ boolean $assertionsDisabled;

    public DOMRetrievalMethod(String string2, String string3, List list2) {
        if (string2 == null) {
            throw new NullPointerException("uri cannot be null");
        }
        if (list2 == null || list2.isEmpty()) {
            this.transforms = Collections.EMPTY_LIST;
        } else {
            ArrayList arrayList = new ArrayList(list2);
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                if (arrayList.get(i) instanceof Transform) continue;
                throw new ClassCastException("transforms[" + i + "] is not a valid type");
            }
            this.transforms = Collections.unmodifiableList(arrayList);
        }
        this.uri = string2;
        if (string2 != null && !string2.equals("")) {
            try {
                new URI(string2);
            }
            catch (URISyntaxException uRISyntaxException) {
                throw new IllegalArgumentException(uRISyntaxException.getMessage());
            }
        }
        this.type = string3;
    }

    public DOMRetrievalMethod(Element element2, XMLCryptoContext xMLCryptoContext, Provider provider) throws MarshalException {
        this.uri = DOMUtils.getAttributeValue(element2, "URI");
        this.type = DOMUtils.getAttributeValue(element2, "Type");
        this.here = element2.getAttributeNodeNS(null, "URI");
        ArrayList<DOMTransform> arrayList = new ArrayList<DOMTransform>();
        Element element3 = DOMUtils.getFirstChildElement(element2);
        if (element3 != null) {
            Element element4 = DOMUtils.getFirstChildElement(element3);
            while (element4 != null) {
                arrayList.add(new DOMTransform(element4, xMLCryptoContext, provider));
                element4 = DOMUtils.getNextSiblingElement(element4);
            }
        }
        this.transforms = arrayList.isEmpty() ? Collections.EMPTY_LIST : Collections.unmodifiableList(arrayList);
    }

    public String getURI() {
        return this.uri;
    }

    public String getType() {
        return this.type;
    }

    public List getTransforms() {
        return this.transforms;
    }

    public void marshal(Node node4, String string2, DOMCryptoContext dOMCryptoContext) throws MarshalException {
        Document document2 = DOMUtils.getOwnerDocument(node4);
        Element element2 = DOMUtils.createElement(document2, "RetrievalMethod", "http://www.w3.org/2000/09/xmldsig#", string2);
        DOMUtils.setAttribute(element2, "URI", this.uri);
        DOMUtils.setAttribute(element2, "Type", this.type);
        if (!this.transforms.isEmpty()) {
            Element element3 = DOMUtils.createElement(document2, "Transforms", "http://www.w3.org/2000/09/xmldsig#", string2);
            element2.appendChild(element3);
            int n = this.transforms.size();
            for (int i = 0; i < n; ++i) {
                ((DOMTransform)this.transforms.get(i)).marshal(element3, string2, dOMCryptoContext);
            }
        }
        node4.appendChild(element2);
        this.here = element2.getAttributeNodeNS(null, "URI");
    }

    public Node getHere() {
        return this.here;
    }

    public Data dereference(XMLCryptoContext xMLCryptoContext) throws URIReferenceException {
        if (xMLCryptoContext == null) {
            throw new NullPointerException("context cannot be null");
        }
        URIDereferencer uRIDereferencer = xMLCryptoContext.getURIDereferencer();
        if (uRIDereferencer == null) {
            uRIDereferencer = DOMURIDereferencer.INSTANCE;
        }
        Data data2 = uRIDereferencer.dereference(this, xMLCryptoContext);
        try {
            int n = this.transforms.size();
            for (int i = 0; i < n; ++i) {
                Transform transform2 = (Transform)this.transforms.get(i);
                data2 = ((DOMTransform)transform2).transform(data2, xMLCryptoContext);
            }
        }
        catch (Exception exception) {
            throw new URIReferenceException(exception);
        }
        return data2;
    }

    public XMLStructure dereferenceAsXMLStructure(XMLCryptoContext xMLCryptoContext) throws URIReferenceException {
        try {
            ApacheData apacheData = (ApacheData)this.dereference(xMLCryptoContext);
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document2 = documentBuilder.parse(new ByteArrayInputStream(apacheData.getXMLSignatureInput().getBytes()));
            Element element2 = document2.getDocumentElement();
            if (element2.getLocalName().equals("X509Data")) {
                return new DOMX509Data(element2);
            }
            return null;
        }
        catch (Exception exception) {
            throw new URIReferenceException(exception);
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof RetrievalMethod)) {
            return false;
        }
        RetrievalMethod retrievalMethod = (RetrievalMethod)object;
        boolean bl = this.type == null ? retrievalMethod.getType() == null : this.type.equals(retrievalMethod.getType());
        return this.uri.equals(retrievalMethod.getURI()) && ((Object)this.transforms).equals(retrievalMethod.getTransforms()) && bl;
    }

    public int hashCode() {
        if (!$assertionsDisabled) {
            throw new AssertionError((Object)"hashCode not designed");
        }
        return 48;
    }

    static {
        $assertionsDisabled = !DOMRetrievalMethod.class.desiredAssertionStatus();
    }
}

