/*
 * Decompiled with CFR 0.152.
 */
package org.jcp.xml.dsig.internal.dom;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.XMLStructure;
import javax.xml.crypto.dom.DOMCryptoContext;
import javax.xml.crypto.dsig.SignatureProperty;
import org.jcp.xml.dsig.internal.dom.DOMStructure;
import org.jcp.xml.dsig.internal.dom.DOMUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class DOMSignatureProperty
extends DOMStructure
implements SignatureProperty {
    private final String id;
    private final String target;
    private final List content;
    static final /* synthetic */ boolean $assertionsDisabled;

    public DOMSignatureProperty(List list2, String string2, String string3) {
        if (string2 == null) {
            throw new NullPointerException("target cannot be null");
        }
        if (list2 == null) {
            throw new NullPointerException("content cannot be null");
        }
        if (list2.isEmpty()) {
            throw new IllegalArgumentException("content cannot be empty");
        }
        ArrayList arrayList = new ArrayList(list2);
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            if (arrayList.get(i) instanceof XMLStructure) continue;
            throw new ClassCastException("content[" + i + "] is not a valid type");
        }
        this.content = Collections.unmodifiableList(arrayList);
        this.target = string2;
        this.id = string3;
    }

    public DOMSignatureProperty(Element element2) throws MarshalException {
        this.target = DOMUtils.getAttributeValue(element2, "Target");
        if (this.target == null) {
            throw new MarshalException("target cannot be null");
        }
        this.id = DOMUtils.getAttributeValue(element2, "Id");
        NodeList nodeList = element2.getChildNodes();
        int n = nodeList.getLength();
        ArrayList<javax.xml.crypto.dom.DOMStructure> arrayList = new ArrayList<javax.xml.crypto.dom.DOMStructure>(n);
        for (int i = 0; i < n; ++i) {
            arrayList.add(new javax.xml.crypto.dom.DOMStructure(nodeList.item(i)));
        }
        if (arrayList.isEmpty()) {
            throw new MarshalException("content cannot be empty");
        }
        this.content = Collections.unmodifiableList(arrayList);
    }

    public List getContent() {
        return this.content;
    }

    public String getId() {
        return this.id;
    }

    public String getTarget() {
        return this.target;
    }

    public void marshal(Node node4, String string2, DOMCryptoContext dOMCryptoContext) throws MarshalException {
        Document document2 = DOMUtils.getOwnerDocument(node4);
        Element element2 = DOMUtils.createElement(document2, "SignatureProperty", "http://www.w3.org/2000/09/xmldsig#", string2);
        DOMUtils.setAttributeID(element2, "Id", this.id);
        DOMUtils.setAttribute(element2, "Target", this.target);
        int n = this.content.size();
        for (int i = 0; i < n; ++i) {
            javax.xml.crypto.dom.DOMStructure dOMStructure = (javax.xml.crypto.dom.DOMStructure)this.content.get(i);
            DOMUtils.appendChild(element2, dOMStructure.getNode());
        }
        node4.appendChild(element2);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof SignatureProperty)) {
            return false;
        }
        SignatureProperty signatureProperty = (SignatureProperty)object;
        boolean bl = this.id == null ? signatureProperty.getId() == null : this.id.equals(signatureProperty.getId());
        return this.equalsContent(signatureProperty.getContent()) && this.target.equals(signatureProperty.getTarget()) && bl;
    }

    public int hashCode() {
        if (!$assertionsDisabled) {
            throw new AssertionError((Object)"hashCode not designed");
        }
        return 50;
    }

    private boolean equalsContent(List list2) {
        int n = list2.size();
        if (this.content.size() != n) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            XMLStructure xMLStructure = (XMLStructure)list2.get(i);
            XMLStructure xMLStructure2 = (XMLStructure)this.content.get(i);
            if (xMLStructure instanceof javax.xml.crypto.dom.DOMStructure) {
                if (!(xMLStructure2 instanceof javax.xml.crypto.dom.DOMStructure)) {
                    return false;
                }
                Node node4 = ((javax.xml.crypto.dom.DOMStructure)xMLStructure).getNode();
                Node node5 = ((javax.xml.crypto.dom.DOMStructure)xMLStructure2).getNode();
                if (DOMUtils.nodesEqual(node5, node4)) continue;
                return false;
            }
            if (xMLStructure2.equals(xMLStructure)) continue;
            return false;
        }
        return true;
    }

    static {
        $assertionsDisabled = !DOMSignatureProperty.class.desiredAssertionStatus();
    }
}

