/*
 * Decompiled with CFR 0.152.
 */
package org.jcp.xml.dsig.internal.dom;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.security.Provider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.XMLCryptoContext;
import javax.xml.crypto.dom.DOMCryptoContext;
import javax.xml.crypto.dsig.CanonicalizationMethod;
import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.SignatureMethod;
import javax.xml.crypto.dsig.SignedInfo;
import javax.xml.crypto.dsig.TransformException;
import javax.xml.crypto.dsig.XMLSignatureException;
import org.apache.xml.security.utils.Base64;
import org.apache.xml.security.utils.UnsyncBufferedOutputStream;
import org.jcp.xml.dsig.internal.dom.DOMCanonicalizationMethod;
import org.jcp.xml.dsig.internal.dom.DOMReference;
import org.jcp.xml.dsig.internal.dom.DOMSignatureMethod;
import org.jcp.xml.dsig.internal.dom.DOMStructure;
import org.jcp.xml.dsig.internal.dom.DOMSubTreeData;
import org.jcp.xml.dsig.internal.dom.DOMUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class DOMSignedInfo
extends DOMStructure
implements SignedInfo {
    private static Logger log;
    private List references;
    private CanonicalizationMethod canonicalizationMethod;
    private SignatureMethod signatureMethod;
    private String id;
    private Document ownerDoc;
    private Element localSiElem;
    private InputStream canonData;
    static final /* synthetic */ boolean $assertionsDisabled;

    public DOMSignedInfo(CanonicalizationMethod canonicalizationMethod, SignatureMethod signatureMethod, List list2) {
        if (canonicalizationMethod == null || signatureMethod == null || list2 == null) {
            throw new NullPointerException();
        }
        this.canonicalizationMethod = canonicalizationMethod;
        this.signatureMethod = signatureMethod;
        this.references = Collections.unmodifiableList(new ArrayList(list2));
        if (this.references.isEmpty()) {
            throw new IllegalArgumentException("list of references must contain at least one entry");
        }
        int n = this.references.size();
        for (int i = 0; i < n; ++i) {
            Object e2 = this.references.get(i);
            if (e2 instanceof Reference) continue;
            throw new ClassCastException("list of references contains an illegal type");
        }
    }

    public DOMSignedInfo(CanonicalizationMethod canonicalizationMethod, SignatureMethod signatureMethod, List list2, String string2) {
        this(canonicalizationMethod, signatureMethod, list2);
        this.id = string2;
    }

    public DOMSignedInfo(Element element2, XMLCryptoContext xMLCryptoContext, Provider provider) throws MarshalException {
        this.localSiElem = element2;
        this.ownerDoc = element2.getOwnerDocument();
        this.id = DOMUtils.getAttributeValue(element2, "Id");
        Element element3 = DOMUtils.getFirstChildElement(element2);
        this.canonicalizationMethod = new DOMCanonicalizationMethod(element3, xMLCryptoContext, provider);
        Element element4 = DOMUtils.getNextSiblingElement(element3);
        this.signatureMethod = DOMSignatureMethod.unmarshal(element4);
        ArrayList<DOMReference> arrayList = new ArrayList<DOMReference>(5);
        Element element5 = DOMUtils.getNextSiblingElement(element4);
        while (element5 != null) {
            arrayList.add(new DOMReference(element5, xMLCryptoContext, provider));
            element5 = DOMUtils.getNextSiblingElement(element5);
        }
        this.references = Collections.unmodifiableList(arrayList);
    }

    public CanonicalizationMethod getCanonicalizationMethod() {
        return this.canonicalizationMethod;
    }

    public SignatureMethod getSignatureMethod() {
        return this.signatureMethod;
    }

    public String getId() {
        return this.id;
    }

    public List getReferences() {
        return this.references;
    }

    public InputStream getCanonicalizedData() {
        return this.canonData;
    }

    public void canonicalize(XMLCryptoContext xMLCryptoContext, ByteArrayOutputStream byteArrayOutputStream) throws XMLSignatureException {
        Object object;
        if (xMLCryptoContext == null) {
            throw new NullPointerException("context cannot be null");
        }
        UnsyncBufferedOutputStream unsyncBufferedOutputStream = new UnsyncBufferedOutputStream(byteArrayOutputStream);
        try {
            ((OutputStream)unsyncBufferedOutputStream).close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        DOMSubTreeData dOMSubTreeData = new DOMSubTreeData(this.localSiElem, true);
        try {
            object = ((DOMCanonicalizationMethod)this.canonicalizationMethod).canonicalize(dOMSubTreeData, xMLCryptoContext, unsyncBufferedOutputStream);
        }
        catch (TransformException transformException) {
            throw new XMLSignatureException(transformException);
        }
        object = byteArrayOutputStream.toByteArray();
        if (log.isLoggable(Level.FINE)) {
            InputStreamReader inputStreamReader = new InputStreamReader(new ByteArrayInputStream((byte[])object));
            char[] cArray = new char[((Object)object).length];
            try {
                inputStreamReader.read(cArray);
                log.log(Level.FINE, "Canonicalized SignedInfo:\n" + new String(cArray));
            }
            catch (IOException iOException) {
                log.log(Level.FINE, "IOException reading SignedInfo bytes");
            }
            log.log(Level.FINE, "Data to be signed/verified:" + Base64.encode((byte[])object));
        }
        this.canonData = new ByteArrayInputStream((byte[])object);
    }

    public void marshal(Node node4, String string2, DOMCryptoContext dOMCryptoContext) throws MarshalException {
        this.ownerDoc = DOMUtils.getOwnerDocument(node4);
        Element element2 = DOMUtils.createElement(this.ownerDoc, "SignedInfo", "http://www.w3.org/2000/09/xmldsig#", string2);
        DOMCanonicalizationMethod dOMCanonicalizationMethod = (DOMCanonicalizationMethod)this.canonicalizationMethod;
        dOMCanonicalizationMethod.marshal(element2, string2, dOMCryptoContext);
        ((DOMSignatureMethod)this.signatureMethod).marshal(element2, string2, dOMCryptoContext);
        int n = this.references.size();
        for (int i = 0; i < n; ++i) {
            DOMReference dOMReference = (DOMReference)this.references.get(i);
            dOMReference.marshal(element2, string2, dOMCryptoContext);
        }
        DOMUtils.setAttributeID(element2, "Id", this.id);
        node4.appendChild(element2);
        this.localSiElem = element2;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof SignedInfo)) {
            return false;
        }
        SignedInfo signedInfo = (SignedInfo)object;
        boolean bl = this.id == null ? signedInfo.getId() == null : this.id.equals(signedInfo.getId());
        return this.canonicalizationMethod.equals(signedInfo.getCanonicalizationMethod()) && this.signatureMethod.equals(signedInfo.getSignatureMethod()) && ((Object)this.references).equals(signedInfo.getReferences()) && bl;
    }

    public int hashCode() {
        if (!$assertionsDisabled) {
            throw new AssertionError((Object)"hashCode not designed");
        }
        return 59;
    }

    static {
        $assertionsDisabled = !DOMSignedInfo.class.desiredAssertionStatus();
        log = Logger.getLogger("org.jcp.xml.dsig.internal.dom");
    }
}

