/*
 * Decompiled with CFR 0.152.
 */
package org.jcp.xml.dsig.internal.dom;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import javax.xml.crypto.NodeSetData;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class DOMSubTreeData
implements NodeSetData {
    private boolean excludeComments;
    private Iterator ni;
    private Node root;

    public DOMSubTreeData(Node node4, boolean bl) {
        this.root = node4;
        this.ni = new DelayedNodeIterator(node4, bl);
        this.excludeComments = bl;
    }

    public Iterator iterator() {
        return this.ni;
    }

    public Node getRoot() {
        return this.root;
    }

    public boolean excludeComments() {
        return this.excludeComments;
    }

    static class DelayedNodeIterator
    implements Iterator {
        private Node root;
        private List nodeSet;
        private ListIterator li;
        private boolean withComments;

        DelayedNodeIterator(Node node4, boolean bl) {
            this.root = node4;
            this.withComments = !bl;
        }

        public boolean hasNext() {
            if (this.nodeSet == null) {
                this.nodeSet = this.dereferenceSameDocumentURI(this.root);
                this.li = this.nodeSet.listIterator();
            }
            return this.li.hasNext();
        }

        public Object next() {
            if (this.nodeSet == null) {
                this.nodeSet = this.dereferenceSameDocumentURI(this.root);
                this.li = this.nodeSet.listIterator();
            }
            if (this.li.hasNext()) {
                return (Node)this.li.next();
            }
            throw new NoSuchElementException();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        private List dereferenceSameDocumentURI(Node node4) {
            ArrayList arrayList = new ArrayList();
            if (node4 != null) {
                this.nodeSetMinusCommentNodes(node4, arrayList, null);
            }
            return arrayList;
        }

        private void nodeSetMinusCommentNodes(Node node4, List list2, Node node5) {
            switch (node4.getNodeType()) {
                case 1: {
                    NamedNodeMap namedNodeMap = node4.getAttributes();
                    if (namedNodeMap != null) {
                        int n = namedNodeMap.getLength();
                        for (int i = 0; i < n; ++i) {
                            list2.add(namedNodeMap.item(i));
                        }
                    }
                    list2.add(node4);
                }
                case 9: {
                    Node node6 = null;
                    for (Node node7 = node4.getFirstChild(); node7 != null; node7 = node7.getNextSibling()) {
                        this.nodeSetMinusCommentNodes(node7, list2, node6);
                        node6 = node7;
                    }
                    break;
                }
                case 3: 
                case 4: {
                    if (node5 != null && (node5.getNodeType() == 3 || node5.getNodeType() == 4)) {
                        return;
                    }
                }
                case 7: {
                    list2.add(node4);
                    break;
                }
                case 8: {
                    if (!this.withComments) break;
                    list2.add(node4);
                }
            }
        }
    }
}

