/*
 * Decompiled with CFR 0.152.
 */
package org.jcp.xml.dsig.internal.dom;

import java.io.OutputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.spec.AlgorithmParameterSpec;
import javax.xml.crypto.Data;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.XMLCryptoContext;
import javax.xml.crypto.dom.DOMCryptoContext;
import javax.xml.crypto.dsig.Transform;
import javax.xml.crypto.dsig.TransformException;
import javax.xml.crypto.dsig.TransformService;
import javax.xml.crypto.dsig.dom.DOMSignContext;
import org.jcp.xml.dsig.internal.dom.DOMStructure;
import org.jcp.xml.dsig.internal.dom.DOMUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DOMTransform
extends DOMStructure
implements Transform {
    protected TransformService spi;
    static final /* synthetic */ boolean $assertionsDisabled;

    public DOMTransform(TransformService transformService) {
        this.spi = transformService;
    }

    public DOMTransform(Element element2, XMLCryptoContext xMLCryptoContext, Provider provider) throws MarshalException {
        String string2 = DOMUtils.getAttributeValue(element2, "Algorithm");
        try {
            this.spi = TransformService.getInstance(string2, "DOM");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            try {
                this.spi = TransformService.getInstance(string2, "DOM", provider);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException2) {
                throw new MarshalException(noSuchAlgorithmException2);
            }
        }
        try {
            this.spi.init(new javax.xml.crypto.dom.DOMStructure(element2), xMLCryptoContext);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new MarshalException(invalidAlgorithmParameterException);
        }
    }

    public final AlgorithmParameterSpec getParameterSpec() {
        return this.spi.getParameterSpec();
    }

    public final String getAlgorithm() {
        return this.spi.getAlgorithm();
    }

    public void marshal(Node node4, String string2, DOMCryptoContext dOMCryptoContext) throws MarshalException {
        Document document2 = DOMUtils.getOwnerDocument(node4);
        Element element2 = null;
        element2 = node4.getLocalName().equals("Transforms") ? DOMUtils.createElement(document2, "Transform", "http://www.w3.org/2000/09/xmldsig#", string2) : DOMUtils.createElement(document2, "CanonicalizationMethod", "http://www.w3.org/2000/09/xmldsig#", string2);
        DOMUtils.setAttribute(element2, "Algorithm", this.getAlgorithm());
        this.spi.marshalParams(new javax.xml.crypto.dom.DOMStructure(element2), dOMCryptoContext);
        node4.appendChild(element2);
    }

    public Data transform(Data data2, XMLCryptoContext xMLCryptoContext) throws TransformException {
        return this.spi.transform(data2, xMLCryptoContext);
    }

    public Data transform(Data data2, XMLCryptoContext xMLCryptoContext, OutputStream outputStream) throws TransformException {
        return this.spi.transform(data2, xMLCryptoContext, outputStream);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Transform)) {
            return false;
        }
        Transform transform2 = (Transform)object;
        return this.getAlgorithm().equals(transform2.getAlgorithm()) && DOMUtils.paramsEqual(this.getParameterSpec(), transform2.getParameterSpec());
    }

    public int hashCode() {
        if (!$assertionsDisabled) {
            throw new AssertionError((Object)"hashCode not designed");
        }
        return 58;
    }

    Data transform(Data data2, XMLCryptoContext xMLCryptoContext, DOMSignContext dOMSignContext) throws MarshalException, TransformException {
        this.marshal(dOMSignContext.getParent(), DOMUtils.getSignaturePrefix(dOMSignContext), dOMSignContext);
        return this.transform(data2, xMLCryptoContext);
    }

    static {
        $assertionsDisabled = !DOMTransform.class.desiredAssertionStatus();
    }
}

